/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMappingAssembler;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.xml.sax.helpers.DefaultHandler;

public class AspectMapping {
    private static final Logger log = Logger.getLogger(AspectMapping.class);
    private static final String CONFIG_FILE_NAME = "pleiades-config.xml";
    private static final AspectMapping singleton = new AspectMapping();
    private Map<JointPoint, PointCut> jointMap = new HashMap<JointPoint, PointCut>();
    private Set<String> methodCalls = new HashSet<String>();

    public static AspectMapping getInstance() {
        return singleton;
    }

    private AspectMapping() {
        File configFile = FileSystem.getResourceFile(CONFIG_FILE_NAME);
        try {
            if (!configFile.exists()) {
                throw new FileNotFoundException(configFile.getPath());
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(configFile, (DefaultHandler)new AspectMappingAssembler(this.jointMap));
            for (JointPoint jointPoint : this.jointMap.keySet()) {
                if (jointPoint.getEditPoint() != JointPoint.EditPoint.CALL) continue;
                this.methodCalls.add(String.valueOf(jointPoint.getClassName()) + "#" + jointPoint.getMethodName());
            }
            log.info("Pleiades \u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            log.fatal("Pleiades \u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public PointCut getPointCut(JointPoint jointPoint) {
        String descBackup = jointPoint.getDescriptor();
        jointPoint.setDescriptor(null);
        PointCut pointCut = this.jointMap.get(jointPoint);
        jointPoint.setDescriptor(descBackup);
        if (pointCut == null) {
            pointCut = this.jointMap.get(jointPoint);
        }
        return pointCut;
    }

    public boolean containesMethodCall(String className, String methodName) {
        return this.methodCalls.contains(String.valueOf(className) + "#" + methodName);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append(this.jointMap).toString();
    }
}

