/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.IDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.NotFoundProperties;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationLoggingDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationDictionary
implements IDictionary {
    private static final Logger log = Logger.getLogger(TranslationDictionary.class);
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "translation.properties";
    private static final String ADDITIONS_DIRECTORY = "additions";
    private static final File cacheFile = new File(Pleiades.configurationPath, "translation-cached.properties");
    public static final String CONVERTER_PROPERTIES_FILE_NAME = "translation-converter.properties";
    private static final String NOMNEMONIC = "%NOMNEMONIC%";
    private static final TranslationDictionary singleton = log.isDebugEnabled() ? new TranslationLoggingDictionary() : new TranslationDictionary();
    private final Map<String, String> map = new HashMap<String, String>();
    private final Set<String> noMnemonicSet = new HashSet<String>();

    public static TranslationDictionary getInstance() {
        return singleton;
    }

    protected TranslationDictionary() {
        this.load();
    }

    protected void load() {
        if (!Pleiades.getInstance().getPleiadesOption().isClean() && cacheFile.exists()) {
            this.map.putAll(this.loadProperties(cacheFile));
            log.info("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
        } else {
            File propFile = FileSystem.getResourceFile(DEFAULT_PROPERTIES_FILE_NAME);
            if (!propFile.exists()) {
                FileNotFoundException e = new FileNotFoundException(propFile.getPath());
                log.fatal("\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", e);
                return;
            }
            this.map.putAll(this.loadProperties(propFile));
            File additions = FileSystem.getResourceFile(ADDITIONS_DIRECTORY);
            if (additions.exists()) {
                Object[] files = additions.listFiles();
                Arrays.sort(files);
                Object[] objectArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    if (((File)file).isFile() && ((File)file).getName().endsWith(".properties")) {
                        this.map.putAll(this.loadProperties((File)file));
                    }
                    ++n2;
                }
            }
            log.info("\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
            this.convert();
        }
    }

    protected void convert() {
        File convFile = FileSystem.getResourceFile(CONVERTER_PROPERTIES_FILE_NAME);
        if (convFile.exists()) {
            HashMap<? extends String, ? extends String> convMap = new HashMap<String, String>();
            convMap.putAll(this.loadProperties(convFile));
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String value;
                String key = entry.getKey();
                String resultValue = value = entry.getValue();
                for (Map.Entry e : convMap.entrySet()) {
                    String convKey = (String)e.getKey();
                    String convValue = (String)e.getValue();
                    resultValue = resultValue.replaceAll(convKey, convValue);
                }
                if (value.equals(resultValue)) continue;
                this.map.put(key, resultValue);
            }
        }
    }

    public void store() {
        Properties prop = new Properties();
        prop.putAll(this.map);
        FileSystem.storeProperties(prop, cacheFile);
        log.info("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u7ba1\u3057\u307e\u3057\u305f\u3002" + prop.size());
    }

    private Map<? extends String, ? extends String> loadProperties(File file) {
        Properties prop = FileSystem.loadProperties(file);
        return prop;
    }

    @Override
    public String lookup(String en, JointPoint jointPoint) {
        if (this.hasJaMnemonic(en)) {
            return en;
        }
        String enNoMnemonic = en.replaceFirst("\\&([\\w\\.@])", "$1");
        String jaNoMnemonic = this.getJaValue(enNoMnemonic, jointPoint);
        String ja = this.editMnemonicEnToJa(en, enNoMnemonic, jaNoMnemonic);
        return ja;
    }

    @Override
    public String lookupIgnoreMnemonic(String en, JointPoint jointPoint) {
        if (this.hasJaMnemonic(en)) {
            return en;
        }
        String ja = this.getJaValue(en, jointPoint);
        return ja;
    }

    protected boolean hasJaMnemonic(String value) {
        return value.matches("(?s)^.*?\\(\\&[\\w\\.@]\\).*$");
    }

    protected String getJaValue(String enNoMnemonic, JointPoint jointPoint) {
        if (this.isNoTranslation(enNoMnemonic, jointPoint)) {
            return enNoMnemonic;
        }
        String result = this.map.get(enNoMnemonic);
        if (result == null) {
            result = this.getJaValueByTrimmed(enNoMnemonic);
        }
        if (result == null) {
            result = enNoMnemonic;
        }
        if (Pleiades.getInstance().getPleiadesOption().isClean()) {
            this.map.put(enNoMnemonic, result);
        }
        return result;
    }

    protected String getJaValueByTrimmed(String enNoMnemonic) {
        String enTrimmed;
        String result;
        StringBuilder leading = new StringBuilder();
        char[] cArray = enNoMnemonic.toCharArray();
        int i = 0;
        while (i < cArray.length) {
            char c = cArray[i];
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            leading.append(c);
            ++i;
        }
        if (leading != null && leading.length() == enNoMnemonic.length()) {
            return null;
        }
        StringBuilder trailing = new StringBuilder();
        int i2 = cArray.length - 1;
        while (i2 > 0) {
            char c = cArray[i2];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == ':') {
                trailing.insert(0, c);
            } else {
                if (c != '.' || i2 <= 2 || cArray[i2 - 1] != '.' || cArray[i2 - 2] != '.') break;
                trailing.insert(0, "...");
                i2 -= 2;
            }
            --i2;
        }
        if ((result = this.map.get(enTrimmed = enNoMnemonic.substring(leading.length(), enNoMnemonic.length() - trailing.length()))) != null && !result.equals(enTrimmed)) {
            log.debug("\u524d\u5f8c\u30b9\u30da\u30fc\u30b9\u9664\u53bb[" + enTrimmed + "] \u5143[" + enNoMnemonic + "] \u7ffb\u8a33\u7d50\u679c[" + leading + result + trailing + "]");
        }
        if (result == null && (result = this.getJaValueByRegex(enTrimmed)) == null) {
            NotFoundProperties.getInstance().println(enNoMnemonic);
        }
        if (result != null) {
            result = leading + result + trailing;
        }
        return result;
    }

    protected String getJaValueByRegex(String enTrimmed) {
        return RegexDictionary.getInstance().lookup(enTrimmed);
    }

    protected boolean isNoTranslation(String enNoMnemonic, JointPoint jointPoint) {
        Set<String> noTransPathEntries;
        List<JointPoint> excludeTrace;
        PointCut pointCut;
        int TRACE_MAX = 30;
        StackTraceElement[] stes = null;
        if (jointPoint != null && (pointCut = AspectMapping.getInstance().getPointCut(jointPoint)) != null && (excludeTrace = pointCut.getExcludeTrace()).size() > 0) {
            stes = Thread.currentThread().getStackTrace();
            for (JointPoint jp : excludeTrace) {
                int i = 0;
                while (i < 30 && i < stes.length) {
                    String methodName;
                    StackTraceElement ste = stes[i];
                    String className = jp.getClassName();
                    if (className.equals(ste.getClassName()) && ((methodName = jp.getMethodName()) == null || methodName.equals(ste.getMethodName()))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        if ((noTransPathEntries = TranslationExcludeProperties.getInstance().getPathEntries(enNoMnemonic)) != null) {
            if (stes == null) {
                stes = Thread.currentThread().getStackTrace();
            }
            int i = 0;
            while (i < 30 && i < stes.length) {
                StackTraceElement ste = stes[i];
                String className = ste.getClassName();
                for (String noTransPath : noTransPathEntries) {
                    if (!className.startsWith(noTransPath)) continue;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String editMnemonicEnToJa(String en, String enNoMnemonic, String jaNoMnemonic) {
        if (Pleiades.getInstance().getPleiadesOption().isNoMnemonic()) {
            return jaNoMnemonic;
        }
        if (en.equals(enNoMnemonic)) {
            return jaNoMnemonic;
        }
        if (jaNoMnemonic.startsWith(NOMNEMONIC)) {
            String noMnemonicResult = jaNoMnemonic.replaceFirst("^%NOMNEMONIC%", "");
            this.noMnemonicSet.add(noMnemonicResult);
            return noMnemonicResult;
        }
        if (this.noMnemonicSet.contains(en)) {
            return en;
        }
        String mnemonicChar = en.replaceFirst("(?s)^.*?\\&([\\w\\.@]).*$", "$1");
        if (mnemonicChar.length() != 1) {
            log.error("Mnemonic invalid length: " + mnemonicChar.length());
            log.error(" enValue:            " + en);
            log.error(" enValueNonMnemonic: " + enNoMnemonic);
            log.error(" mnemonicChar:       " + mnemonicChar);
            return en;
        }
        String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";
        String ja = jaNoMnemonic.replaceFirst("(?s)^(.{2,}?)(@\\p{ASCII}+|\\s*|:\\s*|:\\s+\\{[0-9]\\}\\s*|\\.\\.\\.(</a>|)\\s*|(:|)\\s+\\(.+\\)\\s*)$", "$1" + mnemonicJa + "$2");
        return ja;
    }
}

