/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.panes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ne.k_tech.kposrcp.Activator;
import jp.ne.k_tech.kposrcp.controls.creators.ButtonCreator;
import jp.ne.k_tech.kposrcp.controls.creators.CLabelCreator;
import jp.ne.k_tech.kposrcp.extentions.ExtentionLoader;
import jp.ne.k_tech.kposrcp.extentions.point.AbstractTopMenuPoint;
import jp.ne.k_tech.kposrcp.panes.BasePane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TopPane
extends BasePane {
    private static Log log = LogFactory.getLog(TopPane.class);
    private static TopPane instance;
    private Map<String, Composite> paneMap = new HashMap<String, Composite>();
    private List<AbstractTopMenuPoint> topMenuPointList;

    public static synchronized void init(Composite parent) {
        if (instance == null) {
            instance = new TopPane(parent, 0);
        }
    }

    public static TopPane getInstance() {
        return instance;
    }

    private TopPane(final Composite parent, int style) {
        super(parent, style);
        ExtentionLoader loader = new ExtentionLoader();
        loader.loadExtentions();
        this.topMenuPointList = loader.getPointList();
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Composite top = new Composite((Composite)this, 0);
        RowLayout layout = new RowLayout();
        layout.justify = true;
        layout.spacing = 10;
        layout.marginHeight = 10;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        final Composite body = new Composite((Composite)this, 0);
        layout = new RowLayout();
        layout.justify = true;
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(1808));
        CLabelCreator labelCreator = new CLabelCreator(top, 4);
        labelCreator.setImageRegistry(Activator.getDefault().getImageRegistry());
        labelCreator.create("labeltoptitle");
        int i = 0;
        while (i < this.topMenuPointList.size()) {
            final AbstractTopMenuPoint point = this.topMenuPointList.get(i);
            log.debug((Object)("createTopMenuButton:" + point.getId()));
            ISafeRunnable runnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    log.error((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", exception);
                }

                public void run() throws Exception {
                    point.createTopMenuButton(body);
                    TopPane.this.paneMap.put(point.getId(), point.createComposite(parent));
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            ++i;
        }
        Composite bottom = new Composite((Composite)this, 0);
        bottom.setLayout((Layout)new GridLayout(3, false));
        bottom.setLayoutData((Object)new GridData(768));
        labelCreator = new CLabelCreator(bottom, 0);
        CLabel sp = labelCreator.create();
        sp.setLayoutData((Object)new GridData(768));
        ButtonCreator buttonCreator = new ButtonCreator(bottom, 8);
        buttonCreator.setImageRegistry(Activator.getDefault().getImageRegistry());
        Button button = buttonCreator.create("buttontoprestart");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().restart();
            }
        });
        button = buttonCreator.create("buttontopclose");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().close();
            }
        });
    }

    public List<AbstractTopMenuPoint> getTopMenuPointList() {
        return this.topMenuPointList;
    }
}

