/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

class CleanupThread
extends Thread {
    private ArrayList nonJarItemRemovalList = new ArrayList();
    private ArrayList jarItemRemovalList = new ArrayList();
    private ArrayList loadedResourceList = new ArrayList();
    private static final double CACHE_THRESHOLD_PERCENT = 0.98;
    private Object syncObject;
    private final long currentCacheMaxSize = Config.getCacheSizeMax();
    private volatile long currentCacheSize = 0L;
    private boolean initCacheSize = true;

    CleanupThread(String string, Object object) {
        super(string);
        this.setDaemon(true);
        this.syncObject = object;
    }

    void addToLoadedResourceList(String string) {
        this.loadedResourceList.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleanup() {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.notify();
        }
    }

    private File[] getCacheResourceFiles() {
        return Cache.getCacheDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                boolean bl = !file.isDirectory() && !string.toLowerCase().endsWith(".idx") && !string.toLowerCase().endsWith(".lap") && !string.toLowerCase().endsWith(".ico") && !string.equals("lastAccessed") && !string.equals("removed.apps");
                return bl;
            }
        });
    }

    private long getCurrentCacheSize() {
        long l = 0L;
        File[] fileArray = this.getCacheResourceFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            boolean bl;
            boolean bl2 = true;
            File file = new File(fileArray[i].getPath() + ".idx");
            if (file.exists()) {
                CacheEntry cacheEntry = Cache.getCacheEntryFromFile(file);
                if (cacheEntry != null) {
                    if (cacheEntry.getURL().toLowerCase().endsWith(".jnlp") || cacheEntry.getURL().toLowerCase().endsWith(".jarjnlp") || cacheEntry.getIsShortcutImage() == 1 || MemoryCache.contains(cacheEntry.getURL()) || this.loadedResourceList.contains(cacheEntry.getURL()) || cacheEntry.getBusy() == 1) {
                        bl2 = false;
                    }
                    if (cacheEntry.getURL().toLowerCase().endsWith(".jar") || cacheEntry.getURL().toLowerCase().endsWith(".jarjar") || cacheEntry.getURL().toLowerCase().endsWith(".zip")) {
                        if (bl2 && !this.jarItemRemovalList.contains(fileArray[i].getPath())) {
                            this.jarItemRemovalList.add(fileArray[i].getPath());
                        }
                    } else if (bl2 && !this.nonJarItemRemovalList.contains(fileArray[i].getPath())) {
                        this.nonJarItemRemovalList.add(fileArray[i].getPath());
                    }
                } else {
                    File file2;
                    boolean bl3 = file.delete();
                    if (!bl3) {
                        file.deleteOnExit();
                    }
                    if (!(bl3 = (file2 = new File(fileArray[i].getPath())).delete())) {
                        file2.deleteOnExit();
                    }
                }
            } else if (!fileArray[i].getPath().endsWith("-temp") && !(bl = fileArray[i].delete())) {
                fileArray[i].deleteOnExit();
            }
            if (!bl2) continue;
            l += fileArray[i].length();
        }
        return l;
    }

    private Object[] prepareRemovalList(ArrayList arrayList) {
        Object object;
        ArrayList<CacheEntry> arrayList2 = new ArrayList<CacheEntry>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            File file = new File((String)object + ".idx");
            if (!file.exists()) continue;
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile(file);
            arrayList2.add(cacheEntry);
        }
        object = arrayList2.toArray();
        Arrays.sort(object, new Comparator(){

            public int compare(Object object, Object object2) {
                CacheEntry cacheEntry = (CacheEntry)object;
                CacheEntry cacheEntry2 = (CacheEntry)object2;
                if (cacheEntry.removeBefore(cacheEntry2)) {
                    return -1;
                }
                if (cacheEntry2.removeBefore(cacheEntry)) {
                    return 1;
                }
                return 0;
            }
        });
        return object;
    }

    private void removeResourceFromList(Object[] objectArray) {
        long l = (long)((double)this.currentCacheMaxSize * 0.98);
        for (int i = 0; i < objectArray.length && this.currentCacheSize >= l; ++i) {
            CacheEntry cacheEntry = (CacheEntry)objectArray[i];
            int n = cacheEntry.getContentLength();
            Cache.removeCacheEntry(cacheEntry);
            this.currentCacheSize -= (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    CleanupThread cleanupThread = this;
                    synchronized (cleanupThread) {
                        this.wait();
                        Object object = this.syncObject;
                        synchronized (object) {
                            if (this.initCacheSize) {
                                this.currentCacheSize = this.getCurrentCacheSize();
                                this.initCacheSize = false;
                            }
                            if (this.currentCacheMaxSize != -1L && this.currentCacheSize >= this.currentCacheMaxSize) {
                                Object[] objectArray = this.prepareRemovalList(this.nonJarItemRemovalList);
                                this.removeResourceFromList(objectArray);
                                objectArray = this.prepareRemovalList(this.jarItemRemovalList);
                                this.removeResourceFromList(objectArray);
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

