/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.server.sei.EndpointArgumentsBuilder;
import com.sun.xml.internal.ws.server.sei.EndpointResponseMessageBuilder;
import com.sun.xml.internal.ws.server.sei.EndpointValueSetter;
import com.sun.xml.internal.ws.server.sei.MessageFiller;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import com.sun.xml.internal.ws.server.sei.ValueGetter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EndpointMethodHandler {
    private final SOAPVersion soapVersion;
    private final Method method;
    private final int noOfArgs;
    private final JavaMethodImpl javaMethodModel;
    private final Boolean isOneWay;
    private final EndpointArgumentsBuilder argumentsBuilder;
    private final EndpointResponseMessageBuilder bodyBuilder;
    private final MessageFiller[] outFillers;
    private final SEIInvokerTube owner;
    private static final Logger LOGGER = Logger.getLogger(EndpointMethodHandler.class.getName());

    public EndpointMethodHandler(SEIInvokerTube sEIInvokerTube, JavaMethodImpl javaMethodImpl, WSBinding wSBinding) {
        this.owner = sEIInvokerTube;
        this.soapVersion = wSBinding.getSOAPVersion();
        this.method = javaMethodImpl.getMethod();
        this.javaMethodModel = javaMethodImpl;
        this.argumentsBuilder = this.createArgumentsBuilder();
        ArrayList<MessageFiller> arrayList = new ArrayList<MessageFiller>();
        this.bodyBuilder = this.createResponseMessageBuilder(arrayList);
        this.outFillers = arrayList.toArray(new MessageFiller[arrayList.size()]);
        this.isOneWay = javaMethodImpl.getMEP().isOneWay();
        this.noOfArgs = this.method.getParameterTypes().length;
    }

    private EndpointArgumentsBuilder createArgumentsBuilder() {
        EndpointArgumentsBuilder endpointArgumentsBuilder;
        Object object;
        List<ParameterImpl> list = this.javaMethodModel.getRequestParameters();
        ArrayList<EndpointArgumentsBuilder> arrayList = new ArrayList<EndpointArgumentsBuilder>();
        block10: for (ParameterImpl object22 : list) {
            object = EndpointValueSetter.get(object22);
            switch (object22.getInBinding().kind) {
                case BODY: {
                    if (object22.isWrapperStyle()) {
                        if (object22.getParent().getBinding().isRpcLit()) {
                            arrayList.add(new EndpointArgumentsBuilder.RpcLit((WrapperParameter)object22));
                            continue block10;
                        }
                        arrayList.add(new EndpointArgumentsBuilder.DocLit((WrapperParameter)object22, WebParam.Mode.OUT));
                        continue block10;
                    }
                    arrayList.add(new EndpointArgumentsBuilder.Body(object22.getBridge(), (EndpointValueSetter)object));
                    continue block10;
                }
                case HEADER: {
                    arrayList.add(new EndpointArgumentsBuilder.Header(this.soapVersion, object22, (EndpointValueSetter)object));
                    continue block10;
                }
                case ATTACHMENT: {
                    arrayList.add(EndpointArgumentsBuilder.AttachmentBuilder.createAttachmentBuilder(object22, (EndpointValueSetter)object));
                    continue block10;
                }
                case UNBOUND: {
                    arrayList.add(new EndpointArgumentsBuilder.NullSetter((EndpointValueSetter)object, EndpointArgumentsBuilder.getVMUninitializedValue(object22.getTypeReference().type)));
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        List<ParameterImpl> list2 = this.javaMethodModel.getResponseParameters();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object = (ParameterImpl)iterator.next();
            if (((ParameterImpl)object).isWrapperStyle()) {
                object2 = (WrapperParameter)object;
                List<ParameterImpl> list3 = ((WrapperParameter)object2).getWrapperChildren();
                for (ParameterImpl parameterImpl : list3) {
                    if (!parameterImpl.isOUT() || parameterImpl.getIndex() == -1) continue;
                    EndpointValueSetter endpointValueSetter = EndpointValueSetter.get(parameterImpl);
                    arrayList.add(new EndpointArgumentsBuilder.NullSetter(endpointValueSetter, null));
                }
                continue;
            }
            if (!((ParameterImpl)object).isOUT() || ((ParameterImpl)object).getIndex() == -1) continue;
            object2 = EndpointValueSetter.get((ParameterImpl)object);
            arrayList.add(new EndpointArgumentsBuilder.NullSetter((EndpointValueSetter)object2, null));
        }
        switch (arrayList.size()) {
            case 0: {
                endpointArgumentsBuilder = EndpointArgumentsBuilder.NONE;
                break;
            }
            case 1: {
                endpointArgumentsBuilder = (EndpointArgumentsBuilder)arrayList.get(0);
                break;
            }
            default: {
                endpointArgumentsBuilder = new EndpointArgumentsBuilder.Composite(arrayList);
            }
        }
        return endpointArgumentsBuilder;
    }

    private EndpointResponseMessageBuilder createResponseMessageBuilder(List<MessageFiller> list) {
        EndpointResponseMessageBuilder endpointResponseMessageBuilder = null;
        List<ParameterImpl> list2 = this.javaMethodModel.getResponseParameters();
        block10: for (ParameterImpl parameterImpl : list2) {
            ValueGetter valueGetter = ValueGetter.get(parameterImpl);
            switch (parameterImpl.getOutBinding().kind) {
                case BODY: {
                    if (parameterImpl.isWrapperStyle()) {
                        if (parameterImpl.getParent().getBinding().isRpcLit()) {
                            endpointResponseMessageBuilder = new EndpointResponseMessageBuilder.RpcLit((WrapperParameter)parameterImpl, this.soapVersion);
                            continue block10;
                        }
                        endpointResponseMessageBuilder = new EndpointResponseMessageBuilder.DocLit((WrapperParameter)parameterImpl, this.soapVersion);
                        continue block10;
                    }
                    endpointResponseMessageBuilder = new EndpointResponseMessageBuilder.Bare(parameterImpl, this.soapVersion);
                    continue block10;
                }
                case HEADER: {
                    list.add(new MessageFiller.Header(parameterImpl.getIndex(), parameterImpl.getBridge(), valueGetter));
                    continue block10;
                }
                case ATTACHMENT: {
                    list.add(MessageFiller.AttachmentFiller.createAttachmentFiller(parameterImpl, valueGetter));
                    continue block10;
                }
                case UNBOUND: {
                    continue block10;
                }
            }
            throw new AssertionError();
        }
        if (endpointResponseMessageBuilder == null) {
            switch (this.soapVersion) {
                case SOAP_11: {
                    endpointResponseMessageBuilder = EndpointResponseMessageBuilder.EMPTY_SOAP11;
                    break;
                }
                case SOAP_12: {
                    endpointResponseMessageBuilder = EndpointResponseMessageBuilder.EMPTY_SOAP12;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return endpointResponseMessageBuilder;
    }

    public Packet invoke(Packet packet) {
        Message message;
        if (this.isOneWay.booleanValue() && packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        Message message2 = packet.getMessage();
        Object[] objectArray = new Object[this.noOfArgs];
        try {
            this.argumentsBuilder.readRequest(message2, objectArray);
        }
        catch (JAXBException jAXBException) {
            throw new DeserializationException("failed.to.read.response", new Object[]{jAXBException});
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException("failed.to.read.response", new Object[]{xMLStreamException});
        }
        try {
            Object object = this.owner.getInvoker(packet).invoke(packet, this.method, objectArray);
            message = this.isOneWay != false ? null : this.createResponseMessage(objectArray, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (!(throwable instanceof RuntimeException) && throwable instanceof Exception) {
                LOGGER.log(Level.INFO, throwable.getMessage(), throwable);
                message = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, this.javaMethodModel.getCheckedException(throwable.getClass()), throwable);
            } else {
                LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
                message = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, throwable);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            message = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, exception);
        }
        return packet.createServerResponse(message, packet.endpoint.getPort(), this.javaMethodModel.getOwner(), packet.endpoint.getBinding());
    }

    private Message createResponseMessage(Object[] objectArray, Object object) {
        Message message = this.bodyBuilder.createMessage(objectArray, object);
        for (MessageFiller messageFiller : this.outFillers) {
            messageFiller.fillIn(objectArray, object, message);
        }
        return message;
    }
}

