/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.InstanceResolver;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.handler.HandlerChainsModel;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.server.EndpointFactory;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.streaming.Attributes;
import com.sun.xml.internal.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.transport.http.ResourceLoader;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.exception.LocatableWebServiceException;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDescriptorParser<A> {
    private final Container container;
    private final ClassLoader classLoader;
    private final ResourceLoader loader;
    private final AdapterFactory<A> adapterFactory;
    private final Set<String> names = new HashSet<String>();
    private final Map<String, SDDocumentSource> docs = new HashMap<String, SDDocumentSource>();
    public static final String NS_RUNTIME = "http://java.sun.com/xml/ns/jax-ws/ri/runtime";
    public static final String JAXWS_WSDL_DD_DIR = "WEB-INF/wsdl";
    public static final QName QNAME_ENDPOINTS = new QName("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoints");
    public static final QName QNAME_ENDPOINT = new QName("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoint");
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_IMPLEMENTATION = "implementation";
    public static final String ATTR_WSDL = "wsdl";
    public static final String ATTR_SERVICE = "service";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_URL_PATTERN = "url-pattern";
    public static final String ATTR_ENABLE_MTOM = "enable-mtom";
    public static final String ATTR_MTOM_THRESHOLD_VALUE = "mtom-threshold-value";
    public static final String ATTR_BINDING = "binding";
    public static final String ATTRVALUE_VERSION_1_0 = "2.0";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");

    public DeploymentDescriptorParser(ClassLoader classLoader, ResourceLoader resourceLoader, Container container, AdapterFactory<A> adapterFactory) throws MalformedURLException {
        this.classLoader = classLoader;
        this.loader = resourceLoader;
        this.container = container;
        this.adapterFactory = adapterFactory;
        this.collectDocs("/WEB-INF/wsdl/");
        logger.fine("war metadata=" + this.docs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<A> parse(String string, InputStream inputStream) {
        List<A> list;
        block11: {
            XMLStreamReader xMLStreamReader = null;
            try {
                xMLStreamReader = new TidyXMLStreamReader(XMLStreamReaderFactory.create(string, inputStream, true), inputStream);
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                list = this.parseAdapters(xMLStreamReader);
                if (xMLStreamReader == null) break block11;
            }
            catch (Throwable throwable) {
                if (xMLStreamReader != null) {
                    try {
                        xMLStreamReader.close();
                    }
                    catch (XMLStreamException xMLStreamException) {
                        throw new ServerRtException("runtime.parser.xmlReader", new Object[]{xMLStreamException});
                    }
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                xMLStreamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new ServerRtException("runtime.parser.xmlReader", new Object[]{xMLStreamException});
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<A> parse(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            List<A> list = this.parse(file.getPath(), fileInputStream);
            return list;
        }
        finally {
            fileInputStream.close();
        }
    }

    private void collectDocs(String string) throws MalformedURLException {
        Set<String> set = this.loader.getResourcePaths(string);
        if (set != null) {
            for (String string2 : set) {
                if (string2.endsWith("/")) {
                    this.collectDocs(string2);
                    continue;
                }
                URL uRL = this.loader.getResource(string2);
                this.docs.put(uRL.toString(), SDDocumentSource.create(uRL));
            }
        }
    }

    private List<A> parseAdapters(XMLStreamReader xMLStreamReader) {
        if (!xMLStreamReader.getName().equals(QNAME_ENDPOINTS)) {
            DeploymentDescriptorParser.failWithFullName("runtime.parser.invalidElement", xMLStreamReader);
        }
        ArrayList<A> arrayList = new ArrayList<A>();
        Attributes attributes = XMLStreamReaderUtil.getAttributes(xMLStreamReader);
        String string = this.getMandatoryNonEmptyAttribute(xMLStreamReader, attributes, ATTR_VERSION);
        if (!string.equals(ATTRVALUE_VERSION_1_0)) {
            DeploymentDescriptorParser.failWithLocalName("runtime.parser.invalidVersionNumber", xMLStreamReader, string);
        }
        while (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) != 2) {
            if (xMLStreamReader.getName().equals(QNAME_ENDPOINT)) {
                QName qName;
                attributes = XMLStreamReaderUtil.getAttributes(xMLStreamReader);
                String string2 = this.getMandatoryNonEmptyAttribute(xMLStreamReader, attributes, ATTR_NAME);
                if (!this.names.add(string2)) {
                    logger.warning(WsservletMessages.SERVLET_WARNING_DUPLICATE_ENDPOINT_NAME());
                }
                String string3 = this.getMandatoryNonEmptyAttribute(xMLStreamReader, attributes, ATTR_IMPLEMENTATION);
                Class clazz = this.getImplementorClass(string3, xMLStreamReader);
                EndpointFactory.verifyImplementorClass(clazz);
                SDDocumentSource sDDocumentSource = this.getPrimaryWSDL(xMLStreamReader, attributes, clazz);
                QName qName2 = this.getQNameAttribute(attributes, ATTR_SERVICE);
                if (qName2 == null) {
                    qName2 = EndpointFactory.getDefaultServiceName(clazz);
                }
                if ((qName = this.getQNameAttribute(attributes, ATTR_PORT)) == null) {
                    qName = EndpointFactory.getDefaultPortName(qName2, clazz);
                }
                String string4 = this.getAttribute(attributes, ATTR_ENABLE_MTOM);
                String string5 = this.getAttribute(attributes, ATTR_MTOM_THRESHOLD_VALUE);
                String string6 = this.getAttribute(attributes, ATTR_BINDING);
                if (string6 != null) {
                    string6 = DeploymentDescriptorParser.getBindingIdForToken(string6);
                }
                WSBinding wSBinding = DeploymentDescriptorParser.createBinding(string6, clazz, string4, string5);
                String string7 = this.getMandatoryNonEmptyAttribute(xMLStreamReader, attributes, ATTR_URL_PATTERN);
                boolean bl = this.setHandlersAndRoles(wSBinding, xMLStreamReader, qName2, qName);
                DeploymentDescriptorParser.ensureNoContent(xMLStreamReader);
                WSEndpoint wSEndpoint = WSEndpoint.create(clazz, !bl, InstanceResolver.createDefault(clazz).createInvoker(), qName2, qName, this.container, wSBinding, sDDocumentSource, this.docs.values(), this.createEntityResolver(), false);
                arrayList.add(this.adapterFactory.createAdapter(string2, string7, wSEndpoint));
                continue;
            }
            DeploymentDescriptorParser.failWithLocalName("runtime.parser.invalidElement", xMLStreamReader);
        }
        return arrayList;
    }

    private static WSBinding createBinding(String string, Class clazz, String string2, String string3) {
        WebServiceFeatureList webServiceFeatureList;
        BindingID bindingID;
        MTOMFeature mTOMFeature = null;
        if (string2 != null) {
            mTOMFeature = string3 != null ? new MTOMFeature(Boolean.valueOf(string2), Integer.valueOf(string3)) : new MTOMFeature(Boolean.valueOf(string2));
        }
        if (string != null) {
            bindingID = BindingID.parse(string);
            webServiceFeatureList = bindingID.createBuiltinFeatureList();
            if (DeploymentDescriptorParser.checkMtomConflict(webServiceFeatureList.get(MTOMFeature.class), mTOMFeature)) {
                throw new ServerRtException(ServerMessages.DD_MTOM_CONFLICT(string, string2), new Object[0]);
            }
        } else {
            bindingID = BindingID.parse(clazz);
            webServiceFeatureList = new WebServiceFeatureList();
            if (mTOMFeature != null) {
                webServiceFeatureList.add(mTOMFeature);
            }
            webServiceFeatureList.addAll(bindingID.createBuiltinFeatureList());
        }
        return bindingID.createBinding(webServiceFeatureList.toArray());
    }

    private static boolean checkMtomConflict(MTOMFeature mTOMFeature, MTOMFeature mTOMFeature2) {
        if (mTOMFeature == null || mTOMFeature2 == null) {
            return false;
        }
        return mTOMFeature.isEnabled() ^ mTOMFeature2.isEnabled();
    }

    @NotNull
    public static String getBindingIdForToken(@NotNull String string) {
        if (string.equals("##SOAP11_HTTP")) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (string.equals("##SOAP11_HTTP_MTOM")) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
        }
        if (string.equals("##SOAP12_HTTP")) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        if (string.equals("##SOAP12_HTTP_MTOM")) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
        }
        if (string.equals("##XML_HTTP")) {
            return "http://www.w3.org/2004/08/wsdl/http";
        }
        return string;
    }

    private SDDocumentSource getPrimaryWSDL(XMLStreamReader xMLStreamReader, Attributes attributes, Class<?> clazz) {
        String string = this.getAttribute(attributes, ATTR_WSDL);
        if (string == null) {
            string = EndpointFactory.getWsdlLocation(clazz);
        }
        if (string != null) {
            URL uRL;
            if (!string.startsWith(JAXWS_WSDL_DD_DIR)) {
                logger.warning("Ignoring wrong wsdl=" + string + ". It should start with " + JAXWS_WSDL_DD_DIR + ". Going to generate and publish a new WSDL.");
                return null;
            }
            try {
                uRL = this.loader.getResource('/' + string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new LocatableWebServiceException(ServerMessages.RUNTIME_PARSER_WSDL_NOT_FOUND(string), (Throwable)malformedURLException, xMLStreamReader);
            }
            if (uRL == null) {
                throw new LocatableWebServiceException(ServerMessages.RUNTIME_PARSER_WSDL_NOT_FOUND(string), xMLStreamReader);
            }
            SDDocumentSource sDDocumentSource = this.docs.get(uRL.toExternalForm());
            assert (sDDocumentSource != null);
            return sDDocumentSource;
        }
        return null;
    }

    private EntityResolver createEntityResolver() {
        try {
            return XmlUtil.createEntityResolver(this.loader.getCatalogFile());
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebServiceException(malformedURLException);
        }
    }

    protected String getAttribute(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected QName getQNameAttribute(Attributes attributes, String string) {
        String string2 = this.getAttribute(attributes, string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return QName.valueOf(string2);
    }

    protected String getNonEmptyAttribute(XMLStreamReader xMLStreamReader, Attributes attributes, String string) {
        String string2 = this.getAttribute(attributes, string);
        if (string2 != null && string2.equals("")) {
            DeploymentDescriptorParser.failWithLocalName("runtime.parser.invalidAttributeValue", xMLStreamReader, string);
        }
        return string2;
    }

    protected String getMandatoryAttribute(XMLStreamReader xMLStreamReader, Attributes attributes, String string) {
        String string2 = this.getAttribute(attributes, string);
        if (string2 == null) {
            DeploymentDescriptorParser.failWithLocalName("runtime.parser.missing.attribute", xMLStreamReader, string);
        }
        return string2;
    }

    protected String getMandatoryNonEmptyAttribute(XMLStreamReader xMLStreamReader, Attributes attributes, String string) {
        String string2 = this.getAttribute(attributes, string);
        if (string2 == null) {
            DeploymentDescriptorParser.failWithLocalName("runtime.parser.missing.attribute", xMLStreamReader, string);
        } else if (string2.equals("")) {
            DeploymentDescriptorParser.failWithLocalName("runtime.parser.invalidAttributeValue", xMLStreamReader, string);
        }
        return string2;
    }

    protected boolean setHandlersAndRoles(WSBinding wSBinding, XMLStreamReader xMLStreamReader, QName qName, QName qName2) {
        if (XMLStreamReaderUtil.nextElementContent(xMLStreamReader) == 2 || !xMLStreamReader.getName().equals(HandlerChainsModel.QNAME_HANDLER_CHAINS)) {
            return false;
        }
        HandlerAnnotationInfo handlerAnnotationInfo = HandlerChainsModel.parseHandlerFile(xMLStreamReader, this.classLoader, qName, qName2, wSBinding);
        wSBinding.setHandlerChain(handlerAnnotationInfo.getHandlers());
        if (wSBinding instanceof SOAPBinding) {
            ((SOAPBinding)((Object)wSBinding)).setRoles(handlerAnnotationInfo.getRoles());
        }
        XMLStreamReaderUtil.nextContent(xMLStreamReader);
        return true;
    }

    protected static void ensureNoContent(XMLStreamReader xMLStreamReader) {
        if (xMLStreamReader.getEventType() != 2) {
            DeploymentDescriptorParser.fail("runtime.parser.unexpectedContent", xMLStreamReader);
        }
    }

    protected static void fail(String string, XMLStreamReader xMLStreamReader) {
        logger.log(Level.SEVERE, string + xMLStreamReader.getLocation().getLineNumber());
        throw new ServerRtException(string, Integer.toString(xMLStreamReader.getLocation().getLineNumber()));
    }

    protected static void failWithFullName(String string, XMLStreamReader xMLStreamReader) {
        throw new ServerRtException(string, xMLStreamReader.getLocation().getLineNumber(), xMLStreamReader.getName());
    }

    protected static void failWithLocalName(String string, XMLStreamReader xMLStreamReader) {
        throw new ServerRtException(string, xMLStreamReader.getLocation().getLineNumber(), xMLStreamReader.getLocalName());
    }

    protected static void failWithLocalName(String string, XMLStreamReader xMLStreamReader, String string2) {
        throw new ServerRtException(string, xMLStreamReader.getLocation().getLineNumber(), xMLStreamReader.getLocalName(), string2);
    }

    protected Class loadClass(String string) {
        try {
            return Class.forName(string, true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            throw new ServerRtException("runtime.parser.classNotFound", string);
        }
    }

    private Class getImplementorClass(String string, XMLStreamReader xMLStreamReader) {
        try {
            return Class.forName(string, true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            throw new LocatableWebServiceException(ServerMessages.RUNTIME_PARSER_CLASS_NOT_FOUND(string), (Throwable)classNotFoundException, xMLStreamReader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AdapterFactory<A> {
        public A createAdapter(String var1, String var2, WSEndpoint<?> var3);
    }
}

