/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.update.actions;

import java.net.MalformedURLException;
import java.net.URL;
import jp.ne.k_tech.kposrcp.update.Activator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;
import org.eclipse.update.ui.UpdateManagerUI;

public class OpenInstallerAction
implements IWorkbenchWindowActionDelegate {
    private static Log log = LogFactory.getLog(OpenInstallerAction.class);
    private IWorkbenchWindow window;

    public void run(IAction action) {
        log.debug((Object)"openInstaller()");
        UpdateJob job = new UpdateJob(String.format("Search for new extensions from %s.", Activator.getDefault().getPreferenceStore().getString("UPDATE_SITE_NAME")), this.getSearchRequest());
        UpdateManagerUI.openInstaller((Shell)this.window.getShell(), (UpdateJob)job);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.window = null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private UpdateSearchRequest getSearchRequest() {
        URL url = null;
        String siteURL = Activator.getDefault().getPreferenceStore().getString("UPDATE_SITE_URL");
        String siteName = Activator.getDefault().getPreferenceStore().getString("UPDATE_SITE_NAME");
        try {
            url = new URL(siteURL);
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)String.format("invalid update site URL[%s:%s]", siteName, siteURL));
        }
        UpdateSearchRequest request = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), new UpdateSearchScope());
        request.addFilter((IUpdateSearchFilter)new BackLevelFilter());
        request.addFilter((IUpdateSearchFilter)new EnvironmentFilter());
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.addSearchSite(siteName, url, null);
        request.setScope(scope);
        return request;
    }
}

