/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HelpData {
    private static final String ELEMENT_TOC_ORDER = "tocOrder";
    private static final String ELEMENT_HIDDEN = "hidden";
    private static final String ELEMENT_TOC = "toc";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_INDEX = "index";
    private static final String ATTRIBUTE_ID = "id";
    private static HelpData productHelpData;
    private URL url;
    private List tocOrder;
    private Set hiddenTocs;
    private Set hiddenIndexes;

    public static synchronized HelpData getProductHelpData() {
        IProduct product;
        String helpDataFile;
        if (productHelpData == null && (helpDataFile = HelpPlugin.getDefault().getPluginPreferences().getString("HELP_DATA")).length() != 0 && (product = Platform.getProduct()) != null) {
            URL url = product.getDefiningBundle().getEntry(helpDataFile);
            productHelpData = new HelpData(url);
        }
        return productHelpData;
    }

    public HelpData(URL url) {
        this.url = url;
    }

    public synchronized List getTocOrder() {
        if (this.tocOrder == null) {
            this.loadHelpData();
        }
        return this.tocOrder;
    }

    public synchronized Set getHiddenTocs() {
        if (this.hiddenTocs == null) {
            this.loadHelpData();
        }
        return this.hiddenTocs;
    }

    public synchronized Set getHiddenIndexes() {
        if (this.hiddenIndexes == null) {
            this.loadHelpData();
        }
        return this.hiddenIndexes;
    }

    public InputStream getHelpDataFile(String filePath) throws IOException {
        return Platform.getProduct().getDefiningBundle().getEntry(filePath).openStream();
    }

    private void loadHelpData() {
        this.tocOrder = new ArrayList();
        this.hiddenTocs = new HashSet();
        this.hiddenIndexes = new HashSet();
        if (this.url != null) {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                InputStream in = this.url.openStream();
                parser.parse(in, (DefaultHandler)new Handler());
            }
            catch (Throwable t) {
                String msg = "Error loading help data file \"" + this.url + "\"";
                HelpPlugin.logError(msg, t);
            }
        }
    }

    private class Handler
    extends DefaultHandler {
        private boolean inTocOrder;
        private boolean inHidden;

        private Handler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String id;
            if (HelpData.ELEMENT_TOC_ORDER.equals(name)) {
                this.inTocOrder = true;
            } else if (HelpData.ELEMENT_HIDDEN.equals(name)) {
                this.inHidden = true;
            } else if (HelpData.ELEMENT_TOC.equals(name) || HelpData.ELEMENT_CATEGORY.equals(name)) {
                String id2 = attributes.getValue(HelpData.ATTRIBUTE_ID);
                if (id2 != null) {
                    if (this.inTocOrder) {
                        HelpData.this.tocOrder.add(id2);
                    } else if (this.inHidden) {
                        HelpData.this.hiddenTocs.add(id2);
                    }
                }
            } else if (HelpData.ELEMENT_INDEX.equals(name) && this.inHidden && (id = attributes.getValue(HelpData.ATTRIBUTE_ID)) != null) {
                HelpData.this.hiddenIndexes.add(id);
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (HelpData.ELEMENT_TOC_ORDER.equals(name)) {
                this.inTocOrder = false;
            } else if (HelpData.ELEMENT_HIDDEN.equals(name)) {
                this.inHidden = false;
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }
    }
}

