/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.device.opos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jp.ne.k_tech.kposrcp.device.Constants;
import jp.ne.k_tech.kposrcp.device.opos.AbstractOpos;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.common.util.FileUtil;
import jp.ne.k_tech.kposrcp.device.opos.common.util.StringUtil;

public class OposCustomerDisplay
extends AbstractOpos {
    public static final int CONDITION_UNKNOWN = 0;
    public static final int CONDITION_NORMAL = 10;
    public static final int CONDITION_ERROR = 20;
    private static final String FILE_SURFIX = ".txt";
    private static final String clearDisplayName = "cleardisplay";
    private static Emulator form = null;
    private int condition = 0;
    private String oposCommander;
    private String dirPath;
    private String message;

    public OposCustomerDisplay(boolean mode) {
        this.setEmulate(mode);
    }

    @Override
    public void initialize() {
        this.oposCommander = this.store.getString("OPOS_COMMANDER");
        this.dirPath = this.store.getString("OPOS_CUSTOMERDISPLAY_EXCHANGEDIR");
        if (!this.dirPath.endsWith(Constants.SEP)) {
            this.dirPath = String.valueOf(this.dirPath) + Constants.SEP;
        }
        File file = new File(String.valueOf(this.dirPath) + "CustomerDisplay.ERROR");
        file.delete();
        file = null;
        if (this.isEmulate()) {
            if (form == null) {
                form = new Emulator();
            }
            String[] data = new String[2];
            data[0] = "< CustomerDisplay >";
            int i = 1;
            while (i < 2) {
                data[i] = "----+----1----+----2----+----3----+----4";
                ++i;
            }
            OposCustomerDisplay.form.display(data);
            OposCustomerDisplay.form.setCondition(10);
        }
    }

    @Override
    public void terminate() {
        if (this.isEmulate()) {
            OposCustomerDisplay.form.setCondition(0);
            form.dispose();
        } else {
            this.setCondition(0);
        }
    }

    @Override
    public void sense() {
        if (!this.isEmulate()) {
            File file = new File(String.valueOf(this.dirPath) + "CustomerDisplay.ERROR");
            if (file.exists()) {
                this.message = FileUtil.readFile(String.valueOf(this.dirPath) + "CustomerDisplay.ERROR");
                if (this.message.startsWith("ERROR")) {
                    this.setCondition(20);
                } else {
                    this.setCondition(10);
                }
            } else {
                this.setCondition(10);
            }
        } else {
            OposCustomerDisplay.form.setCondition(10);
        }
    }

    public void display(String receipt, String[] data) {
        if (!this.isEmulate()) {
            String path = String.valueOf(this.dirPath) + receipt + FILE_SURFIX;
            data = this.formatPrint(data);
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(path));
                int i = 0;
                while (i < data.length) {
                    pw.println(data[i]);
                    ++i;
                }
                pw.close();
            }
            catch (IOException iOException) {}
            String[] cmd = new String[]{this.oposCommander, "L", receipt};
            OposController.execute(cmd, false);
        } else {
            OposCustomerDisplay.form.display(data);
        }
    }

    public void clear() {
        String[] data = new String[2];
        int i = 0;
        while (i < 2) {
            data[i] = StringUtil.fill("", ' ', 20, 2);
            ++i;
        }
        this.display(clearDisplayName, data);
    }

    private String[] formatPrint(String[] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i].length() < 20) {
                data[i] = StringUtil.fill(data[i], ' ', 20, 1);
            }
            ++i;
        }
        return data;
    }

    public int getCondition() {
        if (!this.isEmulate()) {
            return this.condition;
        }
        return OposCustomerDisplay.form.getCondition();
    }

    private void setCondition(int condition) {
        if (!this.isEmulate()) {
            this.condition = condition;
        } else {
            OposCustomerDisplay.form.setCondition(condition);
        }
    }

    @Override
    public String getMessage() {
        this.sense();
        if (this.isEmulate()) {
            this.message = "\u30ab\u30b9\u30bf\u30de\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u306f\u30a8\u30df\u30e5\u30ec\u30fc\u30bf\u30e2\u30fc\u30c9\u3067\u52d5\u4f5c\u3057\u3066\u3044\u307e\u3059\u3002\n";
        }
        return this.message;
    }

    private class Emulator
    extends JFrame {
        private static final long serialVersionUID = -5535180955289927368L;
        private static final String WINDOW_TITLE = "CustomerDisplay";
        private static final String FONT_NAME = "MS Gothic";
        private int condition;
        private JTextArea area;

        private Emulator() {
            super(WINDOW_TITLE);
            this.condition = 0;
            this.area = null;
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.area = new JTextArea(2, 80);
            this.area.setForeground(Color.GREEN);
            this.area.setBackground(Color.BLACK);
            this.area.setFont(new Font(FONT_NAME, 0, 18));
            this.area.setEditable(false);
            panel.add((Component)this.area, "Center");
            this.getContentPane().add(panel);
            this.setBounds(380, 0, 220, 80);
            this.setDefaultCloseOperation(3);
            this.setDefaultCloseOperation(0);
            this.setVisible(true);
            this.setFocusable(false);
            this.setAlwaysOnTop(true);
        }

        private void display(String[] data) {
            this.area.setText(String.valueOf(data[0]) + "\n" + data[1]);
        }

        private int getCondition() {
            return this.condition;
        }

        private void setCondition(int condition) {
            this.condition = condition;
        }
    }
}

