/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.device.opos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.ne.k_tech.kposrcp.device.Constants;
import jp.ne.k_tech.kposrcp.device.opos.AbstractOpos;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.common.util.DateUtil;
import jp.ne.k_tech.kposrcp.device.opos.common.util.FileUtil;

public class OposReceiptPrinter
extends AbstractOpos {
    public static final int CONDITION_UNKNOWN = 0;
    public static final int CONDITION_NORMAL = 10;
    public static final int CONDITION_ERROR = 20;
    private static final String FILE_SURFIX = ".txt";
    private static final String RepertReceiptName = "repert";
    private int condition = 0;
    private String oposCommander;
    private String dirPath;
    private String message;

    public OposReceiptPrinter(boolean mode) {
        this.setEmulate(mode);
    }

    @Override
    public void initialize() {
        this.oposCommander = this.store.getString("OPOS_COMMANDER");
        this.dirPath = this.store.getString("OPOS_RECEIPTPRINTER_EXCHANGEDIR");
        if (!this.dirPath.endsWith(Constants.SEP)) {
            this.dirPath = String.valueOf(this.dirPath) + Constants.SEP;
        }
        File file = new File(String.valueOf(this.dirPath) + "ReceiptPrinter.ERROR");
        file.delete();
        file = null;
    }

    @Override
    public void terminate() {
        this.setCondition(0);
    }

    @Override
    public void sense() {
        if (!this.isEmulate()) {
            File file = new File(String.valueOf(this.dirPath) + "ReceiptPrinter.ERROR");
            if (file.exists()) {
                this.message = FileUtil.readFile(String.valueOf(this.dirPath) + "ReceiptPrinter.ERROR");
                if (this.message.startsWith("ERROR")) {
                    this.setCondition(20);
                } else {
                    this.setCondition(10);
                }
            } else {
                this.setCondition(10);
            }
        } else {
            this.setCondition(10);
        }
    }

    public void print(String slipNo, List<String> list) {
        if (slipNo == null || slipNo.length() < 16) {
            log.warn((Object)"\u30ec\u30b7\u30fc\u30c8\u5370\u5b57\u306e\u969b\u3001\u4f1d\u7968No(slipNo)\u306f16\u6841\u5fc5\u8981\u3067\u3059\u3002");
            return;
        }
        this.print(slipNo.substring(9, 16), list, false);
    }

    public void printNoRepeatData(String slipNo, List<String> list) {
        if (slipNo == null || slipNo.length() < 16) {
            log.warn((Object)"\u30ec\u30b7\u30fc\u30c8\u5370\u5b57\u306e\u969b\u3001\u4f1d\u7968No(slipNo)\u306f16\u6841\u5fc5\u8981\u3067\u3059\u3002");
            return;
        }
        this.print(slipNo.substring(9, 16), list, true);
    }

    public void printRepeat(String slipNo) {
        if (slipNo == null) {
            return;
        }
        String path = String.valueOf(this.dirPath) + RepertReceiptName + FILE_SURFIX;
        ArrayList<String> list = FileUtil.readFileToArrayList(path);
        if (list != null && list.size() > 0) {
            this.print(slipNo, list, true);
        }
    }

    private void print(String receipt, List<String> list, boolean repert) {
        String path = String.valueOf(this.dirPath) + RepertReceiptName + FILE_SURFIX;
        int lineMax = this.store.getInt("OPOS_RECEIPTPRINTER_LINEMAX");
        int i = 0;
        try {
            PrintWriter pw = null;
            if (!repert) {
                pw = new PrintWriter(new FileWriter(path));
            }
            String fileNoSurfix = receipt;
            int j = 0;
            while (true) {
                String[] data = new String[lineMax + 6];
                int k = 0;
                while (i < lineMax * (j + 1) && i < list.size()) {
                    String line;
                    if (j > 0 && k == 0) {
                        fileNoSurfix = String.valueOf(receipt) + "-" + j;
                        data[k++] = "|N\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0";
                        data[k++] = "|N\u25a0\u25a0\uff0e\uff0e\uff0e \u7d9a\u304d\u3067\u3059 \uff0e\uff0e\uff0e\u25a0\u25a0";
                        data[k++] = "|N\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0\u25a0";
                        data[k++] = "|200uF";
                        data[k++] = "|N" + DateUtil.formatYyyyMMddHHmm(new Date()) + "   No." + fileNoSurfix;
                        data[k++] = "|200uF";
                    }
                    if (!((line = list.get(i)).length() == 1 && (line.equals("*") || line.equals("!") || line.equals("_")) || line.startsWith("[") && line.endsWith("]") && line.length() == 15 || line.startsWith("|"))) {
                        line = "|N" + line;
                    }
                    data[k] = line;
                    if (!repert) {
                        pw.println(line);
                    }
                    ++i;
                    ++k;
                }
                this.createReceipt(fileNoSurfix, data);
                this.executePrint(fileNoSurfix);
                data = null;
                if (i == list.size()) break;
                ++j;
            }
            if (!repert) {
                pw.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void createReceipt(String fileNoSurfix, String[] data) {
        String path = String.valueOf(this.dirPath) + fileNoSurfix + FILE_SURFIX;
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(path));
            int i = 0;
            while (i < data.length) {
                if (data[i] == null) break;
                pw.println(data[i]);
                ++i;
            }
            pw.close();
        }
        catch (IOException iOException) {}
    }

    private void executePrint(String fileNoSurfix) {
        String[] cmd = new String[3];
        if (!this.isEmulate()) {
            cmd[0] = this.oposCommander;
            cmd[1] = "P";
            cmd[2] = fileNoSurfix;
            OposController.execute(cmd, false);
        } else {
            cmd[0] = "Notepad";
            cmd[1] = String.valueOf(this.dirPath) + fileNoSurfix + FILE_SURFIX;
            cmd[2] = "";
            this.shell(cmd, false);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public int getCondition() {
        if (!this.isEmulate()) {
            return this.condition;
        }
        return this.condition;
    }

    private void shell(String[] args, boolean wait) {
        String cmdline = "";
        int i = 0;
        while (i < args.length) {
            cmdline = String.valueOf(cmdline) + " " + args[i];
            ++i;
        }
        try {
            Process proc = Runtime.getRuntime().exec(cmdline);
            if (wait) {
                int result = proc.waitFor();
                log.debug((Object)("result=" + result));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setCondition(int condition) {
        this.condition = !this.isEmulate() ? condition : condition;
    }

    @Override
    public String getMessage() {
        this.sense();
        if (this.isEmulate()) {
            this.message = "\u30ec\u30b7\u30fc\u30c8\u30d7\u30ea\u30f3\u30bf\u30fc\u306f\u30a8\u30df\u30e5\u30ec\u30fc\u30bf\u30e2\u30fc\u30c9\u3067\u52d5\u4f5c\u3057\u3066\u3044\u307e\u3059\u3002\n";
        }
        return this.message;
    }
}

