/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common;

import java.awt.Toolkit;
import java.io.IOException;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PosCommon {
    private static Log log = LogFactory.getLog(PosCommon.class);

    public static void addKeyListener(Composite composite, KeyListener keyListener) {
        Control[] controls = composite.getChildren();
        int i = 0;
        int s = controls.length;
        while (i < s) {
            Control control = controls[i];
            if (control instanceof Composite) {
                PosCommon.addKeyListener((Composite)control, keyListener);
            }
            control.addKeyListener(keyListener);
            ++i;
        }
    }

    public static void addFocusListener(Composite composite, FocusListener focusListener) {
        Control[] controls = composite.getChildren();
        int i = 0;
        int s = controls.length;
        while (i < s) {
            Control control = controls[i];
            if (control instanceof Composite) {
                PosCommon.addFocusListener((Composite)control, focusListener);
            }
            control.addFocusListener(focusListener);
            ++i;
        }
    }

    public static void addTraverseListener(Composite composite, TraverseListener traverseListener) {
        Control[] controls = composite.getChildren();
        int i = 0;
        int s = controls.length;
        while (i < s) {
            Control control = controls[i];
            if (control instanceof Composite) {
                PosCommon.addTraverseListener((Composite)control, traverseListener);
            }
            control.addTraverseListener(traverseListener);
            ++i;
        }
    }

    public static void shell(String[] args, boolean wait) {
        String cmdline = "";
        int i = 0;
        while (i < args.length) {
            cmdline = String.valueOf(cmdline) + " " + args[i];
            ++i;
        }
        try {
            System.out.println("cmdline=" + cmdline);
            Process proc = Runtime.getRuntime().exec(cmdline);
            if (wait) {
                int result = proc.waitFor();
                log.debug((Object)("result=" + result));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean authorize() {
        if (Activator.getDefault().getPreferenceStore().getInt("REGISTER_NO") == 0) {
            return true;
        }
        return true;
    }

    public static String getCheckdigit(String barcode) {
        String result = null;
        if (barcode.length() == 12) {
            int sum = 0;
            int i = 0;
            while (i < barcode.length()) {
                int temp = Integer.parseInt(barcode.substring(i, i + 1));
                if (i % 2 == 1) {
                    temp *= 3;
                }
                sum += temp;
                ++i;
            }
            if ((sum = 10 - sum % 10) > 9) {
                sum = 0;
            }
            result = String.valueOf(sum);
        }
        return result;
    }

    public static String convertISBN2JAN(String isbnCode) {
        String result = null;
        if (isbnCode.toUpperCase().startsWith("N") && isbnCode.length() == 11) {
            String isbn = isbnCode.substring(1, 10);
            result = "978" + isbn + PosCommon.getCheckdigit("978" + isbn);
            log.debug((Object)String.format("ISBN[%s]\u2192JAN[%s]", isbn, result));
        } else {
            result = isbnCode;
        }
        return result;
    }

    public static String convertDual2JAN(String dualCode) {
        String result = null;
        if (dualCode.length() == 27) {
            String[] barcodes = dualCode.split(",");
            if (barcodes.length == 2) {
                result = barcodes[0];
                log.debug((Object)String.format("DualCode[%s]\u2192JAN[%s]", dualCode, result));
            } else {
                result = dualCode;
            }
        } else {
            result = dualCode;
        }
        return result;
    }

    public static String getBarcodeTop() {
        StringBuffer top = new StringBuffer();
        top.append("7");
        top.append(Activator.getDefault().getPreferenceStore().getString("STORE_CD"));
        return top.toString();
    }

    public static void beep() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
    }
}

