/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class PosDateUtils {
    private static final DateFormat DATE_FORMAT_yyyyMMddHHmm = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final DateFormat DATE_FORMAT_yyyyMMdd = new SimpleDateFormat("yyyy/MM/dd");
    private static final DateFormat DATE_FORMAT_yyMMdd = new SimpleDateFormat("yyMMdd");
    private static final DateFormat DATE_FORMAT_HHmm = new SimpleDateFormat("HHmm");
    private static final DateFormat DATE_FORMAT_HH = new SimpleDateFormat("HH");
    private static final DateFormat DATE_FORMAT_jp = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff08EEE\uff09HH\u6642mm\u5206");

    public static String getNowHHmm() {
        return PosDateUtils.formatHHmm(new Date());
    }

    public static String formatHHmm(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT_HHmm.format(date);
    }

    public static String format_yyyyMMddHHmm(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT_yyyyMMddHHmm.format(date);
    }

    public static String format_yyyyMMdd(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT_yyyyMMdd.format(date);
    }

    public static String format_yyMMdd(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT_yyMMdd.format(date);
    }

    public static String format_jp(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMAT_jp.format(date);
    }

    public static String format_jp() {
        return DATE_FORMAT_jp.format(new Date());
    }

    public static Date format_parse(String yyyyMMdd) {
        Date date = null;
        try {
            date = DATE_FORMAT_yyyyMMdd.parse(yyyyMMdd);
        }
        catch (ParseException parseException) {}
        return date;
    }

    public static Date format_parse_yyMMdd(String yyMMdd) {
        Date date = null;
        try {
            date = DATE_FORMAT_yyMMdd.parse(yyMMdd);
        }
        catch (ParseException parseException) {}
        return date;
    }

    public static Date getBizDate() {
        Date now = new Date();
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        if (Integer.parseInt(DATE_FORMAT_HH.format(now)) >= 0 && Integer.parseInt(DATE_FORMAT_HH.format(now)) <= Activator.getDefault().getPreferenceStore().getInt("BIZ_DAY_HOUR") - 1) {
            return yesterday.getTime();
        }
        return now;
    }

    public static String getBizDate4SlipNo() {
        return DATE_FORMAT_yyMMdd.format(PosDateUtils.getBizDate());
    }

    public static boolean isReboot(String date) {
        Date now = new Date();
        if (DATE_FORMAT_yyMMdd.format(now).equals(date)) {
            return false;
        }
        return Integer.parseInt(DATE_FORMAT_HHmm.format(now)) > Activator.getDefault().getPreferenceStore().getInt("BIZ_DAY_HOUR") * 100;
    }

    public static long dateDiff(Date from, Date to) {
        if (from == null || to == null) {
            return 99999999L;
        }
        return (to.getTime() - from.getTime()) / 86400000L;
    }

    public static long timeDiff(Date from, Date to) {
        if (from == null || to == null) {
            return 99999999L;
        }
        return to.getTime() - from.getTime();
    }

    public static boolean checkDate(String aDate) {
        int month;
        int year;
        String[] adate;
        block8: {
            block7: {
                block6: {
                    if (aDate.length() != 10) {
                        return false;
                    }
                    adate = aDate.split("/", 3);
                    try {
                        if (adate[0] != null && adate[0].getBytes().length == 4 && adate[0].length() == adate[0].getBytes().length) break block6;
                        return false;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                year = Integer.parseInt(adate[0]);
                if (adate[1] != null && (adate[1].getBytes().length == 2 || adate[1].getBytes().length == 1) && adate[1].getBytes().length == adate[1].length()) break block7;
                return false;
            }
            month = Integer.parseInt(adate[1]);
            if (adate[2] != null && (adate[2].getBytes().length == 2 || adate[2].getBytes().length == 1) && adate[2].getBytes().length == adate[2].length()) break block8;
            return false;
        }
        int day = Integer.parseInt(adate[2]);
        GregorianCalendar cl = new GregorianCalendar();
        cl.setLenient(false);
        cl.set(year, month - 1, day);
        cl.getTime();
        return true;
    }

    public static boolean checkHHmm(String target) {
        if (StringUtils.isEmpty((String)target)) {
            return true;
        }
        if (target.length() != 4) {
            return false;
        }
        int hh = NumberUtils.toInt((String)target.substring(0, 2), (int)-1);
        int mm = NumberUtils.toInt((String)target.substring(2, 4), (int)-1);
        return hh >= 0 && hh <= 23 && mm >= 0 && mm <= 59;
    }

    public static int getYearMonth(int val, int type) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(PosDateUtils.getBizDate());
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.set(year, month + val, 1);
        return calendar.get(type);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }
}

