/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.exception.ExitException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class PosNumberUtils {
    public static final String TAX_OUT_METHOD = "1";
    private static BigDecimal rateTax = new BigDecimal(Activator.getDefault().getPreferenceStore().getInt("RATE_TAX"));
    private static int roundingModeTax = Activator.getDefault().getPreferenceStore().getInt("ROUNDING_MODE_TAX");
    private static BigDecimal hundred = new BigDecimal(100);
    private static final NumberFormat NUMBER_FORMAT_COMMMA = new DecimalFormat("#,###");
    private static final NumberFormat CURRENCY_FORMAT = new DecimalFormat("\\#,###");
    private static final NumberFormat NUMBER_FORMAT_000 = new DecimalFormat("000");
    private static final NumberFormat NUMBER_FORMAT_0000 = new DecimalFormat("0000");
    private static final NumberFormat NUMBER_FORMAT_00000000 = new DecimalFormat("00000000");

    public static String currencyFormat(long number) {
        return CURRENCY_FORMAT.format(number);
    }

    public static String commaFormat(long number) {
        return NUMBER_FORMAT_COMMMA.format(number);
    }

    public static String commaFormat(String number) {
        return NUMBER_FORMAT_COMMMA.format(NumberUtils.toLong((String)number));
    }

    public static String format_000(int number) {
        String result = NUMBER_FORMAT_000.format(number);
        if (result.length() > 3) {
            result = result.substring(result.length() - 3, result.length());
        }
        return result;
    }

    public static String format_0000(int number) {
        return NUMBER_FORMAT_0000.format(number);
    }

    public static String format_00000000(long number) {
        String result = NUMBER_FORMAT_00000000.format(number);
        if (result.length() > 8) {
            result = result.substring(result.length() - 8, result.length());
        }
        return result;
    }

    public static long currencyParse(String value) {
        return PosNumberUtils.commaParse(StringUtils.defaultIfEmpty((String)value, (String)"0").replace("\\", ""));
    }

    public static long commaParse(String value) {
        try {
            return NUMBER_FORMAT_COMMMA.parse(StringUtils.defaultIfEmpty((String)value, (String)"0")).longValue();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    public static long round(double value) {
        return Double.valueOf(Math.round(value)).longValue();
    }

    public static long floor(double value) {
        return Double.valueOf(Math.floor(value)).longValue();
    }

    public static long ceil(double value) {
        return Double.valueOf(Math.ceil(value)).longValue();
    }

    public static long taxOUT(long price, double rate) {
        long ret = "0".equals(TAX_OUT_METHOD) ? PosNumberUtils.ceil((double)price * (1.0 + rate)) : (TAX_OUT_METHOD.equals(TAX_OUT_METHOD) ? PosNumberUtils.floor((double)price * (1.0 + rate)) : PosNumberUtils.round((double)price * (1.0 + rate)));
        return ret - price;
    }

    public static long taxOUT(long price) {
        return BigDecimal.valueOf(price).multiply(rateTax).divide(hundred, roundingModeTax).longValue();
    }

    public static long multiplyPercent(long target, int percent, int roundingMode) {
        return BigDecimal.valueOf(target).multiply(new BigDecimal(percent)).divide(hundred, roundingMode).longValue();
    }

    public static long tax(long price, String taxKind) {
        if ("0".equals(taxKind)) {
            return 0L;
        }
        if (TAX_OUT_METHOD.equals(taxKind)) {
            return PosNumberUtils.taxOUT(price);
        }
        if ("2".equals(taxKind)) {
            return 0L;
        }
        throw new ExitException(String.format("\u7a0e\u533a\u5206\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\uff0e[%s]", taxKind));
    }

    public static long amountWithTax(long price, String taxKind) {
        if ("0".equals(taxKind)) {
            return price;
        }
        if (TAX_OUT_METHOD.equals(taxKind)) {
            return price + PosNumberUtils.taxOUT(price);
        }
        if ("2".equals(taxKind)) {
            return price;
        }
        throw new ExitException(String.format("\u7a0e\u533a\u5206\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\uff0e[%s]", taxKind));
    }
}

