/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db;

import java.util.Properties;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.exception.NotInitializedException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class SessionManager {
    private static SessionManager instance = null;
    private SessionFactory sessionFactory = null;

    private SessionManager() {
        Configuration configuration = new Configuration();
        configuration.configure("hibernate.cfg.xml");
        Properties props = configuration.getProperties();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        props.setProperty("hibernate.connection.driver_class", store.getString("DB_DRIVER_CLASS"));
        props.setProperty("hibernate.connection.pool_size", Integer.toString(store.getInt("DB_POOL_SIZE")));
        props.setProperty("hibernate.connection.url", store.getString("DB_URL"));
        props.setProperty("hibernate.connection.username", store.getString("DB_USERNAME"));
        props.setProperty("hibernate.connection.password", store.getString("DB_PASSWORD"));
        props.setProperty("hibernate.dialect", store.getString("DB_DIALECT"));
        props.setProperty("hibernate.show_sql", Boolean.toString(store.getBoolean("DB_SHOW_SQL")));
        configuration.addProperties(props);
        this.sessionFactory = configuration.buildSessionFactory();
    }

    public static synchronized SessionManager getInstance() {
        if (instance == null) {
            throw new NotInitializedException();
        }
        return instance;
    }

    public static synchronized void initialize() {
        if (instance == null) {
            instance = new SessionManager();
        }
    }

    public Session getSession() {
        return this.sessionFactory.openSession();
    }
}

