/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.db.dao.BaseDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Indicate;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.IndicateTableData;
import org.hibernate.Query;
import org.hibernate.Session;

public class IndicateDAO
extends BaseDAO {
    public Serializable save(Session session, Indicate indicate) {
        return session.save((Object)indicate);
    }

    public Serializable incrementAfterQuantity(Session session, JournalDetail journalDetail, String kindCd) {
        StringBuffer hql = new StringBuffer();
        hql.append("UPDATE");
        hql.append(" Indicate indicate");
        hql.append(" SET");
        hql.append(" indicate.afterQuantity = (COALESCE(indicate.afterQuantity,0) + :itemQuantity)");
        hql.append(" WHERE");
        hql.append(" indicate.itemCd = :itemCd");
        hql.append(" AND indicate.suppCd = :suppCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        String toStoreCd = null;
        if ("S0".equals(kindCd)) {
            toStoreCd = journalDetail.getToStoreCd();
            if (toStoreCd != null && toStoreCd.length() > 0) {
                hql.append(" AND indicate.toStoreCd = :toStoreCd");
            } else {
                toStoreCd = null;
            }
        }
        Query query = session.createQuery(hql.toString());
        query.setString("itemCd", journalDetail.getItemCd());
        query.setString("suppCd", journalDetail.getSuppCd());
        query.setInteger("itemQuantity", journalDetail.getItemQuantity().intValue());
        if (toStoreCd != null) {
            query.setString("toStoreCd", toStoreCd);
        }
        return Integer.valueOf(query.executeUpdate());
    }

    public Serializable incrementAfterQuantityCancel(Session session, JournalDetail journalDetail) {
        StringBuffer hql = new StringBuffer();
        hql.append("UPDATE");
        hql.append(" Indicate indicate");
        hql.append(" SET");
        hql.append(" indicate.afterQuantity = indicate.indicateQuantity");
        hql.append(" WHERE");
        hql.append(" indicate.itemCd = :itemCd");
        hql.append(" AND indicate.suppCd = :suppCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        Query query = session.createQuery(hql.toString());
        query.setString("itemCd", journalDetail.getItemCd());
        query.setString("suppCd", journalDetail.getSuppCd());
        return Integer.valueOf(query.executeUpdate());
    }

    public List<Indicate> getIndicateMoveOut(String itemCd, String suppCd, String storeCd) {
        ArrayList<Indicate> result = new ArrayList<Indicate>();
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" indicate");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", Indicate indicate");
        hql.append(" WHERE");
        hql.append(" slip.kindMst.kindCd = :kindCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND slip.slipNo = indicate.comp_id.slipNo");
        hql.append(" AND indicate.itemCd = :itemCd");
        hql.append(" AND indicate.suppCd = :suppCd");
        hql.append(" AND indicate.toStoreCd = :toStoreCd");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        hql.append(" ORDER BY");
        hql.append(" indicate.comp_id.slipNo");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("kindCd", "S0");
            query.setString("itemCd", itemCd);
            query.setString("suppCd", suppCd);
            query.setString("toStoreCd", storeCd);
            result.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<Indicate> getIndicateDetail(IndicateTableData indicateTabelData) {
        ArrayList<Indicate> result = new ArrayList<Indicate>();
        if (indicateTabelData.getIndicateKindCd() == 0) {
            result.addAll(this.getIndicateDetail4Move(indicateTabelData));
        } else if (indicateTabelData.getIndicateKindCd() == 1) {
            result.addAll(this.getIndicateDetail4Back(indicateTabelData));
        }
        return result;
    }

    public List<Indicate> getIndicateDetail4Move(IndicateTableData indicateTabelData) {
        ArrayList<Indicate> result = new ArrayList<Indicate>();
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" indicate");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", Indicate indicate");
        hql.append(" WHERE");
        hql.append(" slip.kindMst.kindCd = :kindCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND slip.slipNo = indicate.comp_id.slipNo");
        hql.append(" AND (indicate.afterQuantity IS NULL OR indicate.afterQuantity < indicate.indicateQuantity)");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        if (indicateTabelData.getIndicateDate() == null) {
            hql.append(" AND indicate.indicateDate IS NULL");
        } else {
            hql.append(" AND indicate.indicateDate = :indicateDate");
        }
        if (indicateTabelData.getLimitDate() == null) {
            hql.append(" AND indicate.limitDate IS NULL");
        } else {
            hql.append(" AND indicate.limitDate = :limitDate");
        }
        if (indicateTabelData.getCd() == null) {
            hql.append(" AND indicate.toStoreCd IS NULL");
        } else {
            hql.append(" AND indicate.toStoreCd = :cd");
        }
        hql.append(" ORDER BY");
        hql.append(" slip.kindMst.kindCd");
        hql.append(", indicate.limitDate");
        hql.append(", indicate.indicateDate");
        hql.append(", indicate.toStoreCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("kindCd", "C2");
            if (indicateTabelData.getIndicateDate() != null) {
                query.setDate("indicateDate", indicateTabelData.getIndicateDate());
            }
            if (indicateTabelData.getLimitDate() != null) {
                query.setDate("limitDate", indicateTabelData.getLimitDate());
            }
            if (indicateTabelData.getCd() != null) {
                query.setString("cd", indicateTabelData.getCd());
            }
            result.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<Indicate> getIndicateDetail4Back(IndicateTableData indicateTabelData) {
        ArrayList<Indicate> result = new ArrayList<Indicate>();
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" indicate");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", Indicate indicate");
        hql.append(" WHERE");
        hql.append(" slip.kindMst.kindCd = :kindCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND slip.slipNo = indicate.comp_id.slipNo");
        hql.append(" AND (indicate.afterQuantity IS NULL OR indicate.afterQuantity < indicate.indicateQuantity)");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        hql.append(" AND indicate.transDate IS NULL");
        hql.append(" AND indicate.approveDate IS NULL");
        if (indicateTabelData.getIndicateDate() == null) {
            hql.append(" AND indicate.indicateDate IS NULL");
        } else {
            hql.append(" AND indicate.indicateDate = :indicateDate");
        }
        if (indicateTabelData.getLimitDate() == null) {
            hql.append(" AND indicate.limitDate IS NULL");
        } else {
            hql.append(" AND indicate.limitDate = :limitDate");
        }
        if (indicateTabelData.getCd() == null) {
            hql.append(" AND indicate.suppCd IS NULL");
        } else {
            hql.append(" AND indicate.suppCd = :cd");
        }
        hql.append(" ORDER BY");
        hql.append(" slip.kindMst.kindCd");
        hql.append(", indicate.limitDate");
        hql.append(", indicate.indicateDate");
        hql.append(", indicate.suppCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("kindCd", "A3");
            if (indicateTabelData.getIndicateDate() != null) {
                query.setDate("indicateDate", indicateTabelData.getIndicateDate());
            }
            if (indicateTabelData.getLimitDate() != null) {
                query.setDate("limitDate", indicateTabelData.getLimitDate());
            }
            if (indicateTabelData.getCd() != null) {
                query.setString("cd", indicateTabelData.getCd());
            }
            result.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }
}

