/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db.dao;

import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.db.dao.BaseDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMstPK;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.ItemSearchTableData;
import org.hibernate.Query;
import org.hibernate.Session;

public class ItemMstDAO
extends BaseDAO {
    private int rownum = 0;

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public ItemMst findByPrimaryKey(ItemMstPK itemMstPK) {
        ItemMst result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" UPPER(itemMst.comp_id.itemCd) = UPPER(:itemCd)");
        hql.append(" AND itemMst.comp_id.suppCd = :suppCd");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("itemCd", itemMstPK.getItemCd());
            query.setString("suppCd", itemMstPK.getSuppCd());
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = (ItemMst)query.uniqueResult();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findByOfficialBarcode(String officialBarcode) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" itemMst.officialBarcode = :officialBarcode");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" ,itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("officialBarcode", officialBarcode);
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findByBarcode(String barcode) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" itemMst.barcode = :barcode");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("barcode", barcode);
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findByItemcode(String itemcode) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" UPPER(itemMst.comp_id.itemCd) LIKE :itemcode");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("itemcode", "%" + itemcode.toUpperCase() + "%");
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findByMakerCode(String makerCd) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" UPPER(itemMst.makerCd) LIKE :makerCd");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("makerCd", "%" + makerCd.toUpperCase() + "%");
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findByItemname(String itemname) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" UPPER(itemMst.itemName) LIKE :itemname");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("itemname", "%" + itemname.toUpperCase() + "%");
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findByGenrename(String genrename) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(", GenreMst genreMst");
        hql.append(" WHERE");
        hql.append(" UPPER(genreMst.genreName) LIKE :genrename");
        hql.append(" AND itemMst.genreCd = genreMst.genreCd");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("genrename", "%" + genrename.toUpperCase() + "%");
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findBySuppname(String suppname) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(", SupplierMst supplierMst");
        hql.append(" WHERE");
        hql.append(" UPPER(supplierMst.suppName) LIKE :suppname");
        hql.append(" AND itemMst.comp_id.suppCd = supplierMst.suppCd");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("suppname", "%" + suppname.toUpperCase() + "%");
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemSearchTableData> findByOrderSuppname(String orderSuppname) {
        ArrayList<ItemSearchTableData> result = new ArrayList<ItemSearchTableData>();
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" new " + ItemSearchTableData.class.getName() + "(itemMst, MAX(orderDetail.orderDate), SUM(orderDetail.itemQuantity))");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(", SupplierMst supplierMst");
        hql.append(", OrderDetail orderDetail");
        hql.append(" WHERE");
        hql.append(" UPPER(supplierMst.suppName) LIKE :orderSuppname");
        hql.append(" AND itemMst.comp_id.suppCd = supplierMst.suppCd");
        hql.append(" AND orderDetail.itemCd = itemMst.comp_id.itemCd");
        hql.append(" AND orderDetail.suppCd = itemMst.comp_id.suppCd");
        hql.append(" AND orderDetail.comp_id.seq > 0");
        hql.append(" AND orderDetail.journalSlipNo IS NULL");
        hql.append(" AND orderDetail.journalSeq IS NULL");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" GROUP BY");
        hql.append(" itemMst.comp_id.itemCd");
        hql.append(", itemMst.comp_id.suppCd");
        hql.append(" HAVING");
        hql.append(" SUM(orderDetail.itemQuantity) > 0");
        hql.append(" ORDER BY");
        hql.append(" COALESCE(itemMst.lastDate, cast('1900-01-01' as date)) DESC");
        hql.append(" , itemMst.comp_id.itemCd");
        try {
            Query query = session.createQuery(hql.toString());
            if (this.rownum > 0) {
                query.setMaxResults(this.rownum);
            }
            query.setString("orderSuppname", "%" + orderSuppname.toUpperCase() + "%");
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            result.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public long getMaxBarcodeNo(String barcodeTop) {
        long result = 0L;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" MAX(itemMst.barcode)");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" itemMst.comp_id.itemCd LIKE :prefix");
        hql.append(" AND itemMst.barcode LIKE :barcodeTop");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("prefix", "USED_%");
            query.setString("barcodeTop", String.valueOf(barcodeTop) + "%");
            String tmp = (String)query.uniqueResult();
            result = tmp == null ? 0L : Long.valueOf(tmp.substring(4, 12));
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<ItemMst> findRecommendItems(String classCd) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" itemMst");
        hql.append(" FROM");
        hql.append(" ItemMst itemMst");
        hql.append(" WHERE");
        hql.append(" itemMst.classCd = :classCd");
        hql.append(" AND COALESCE(itemMst.validityFlag, :validityFlagDefault) != :validityFlag");
        hql.append(" ORDER BY");
        hql.append(" itemMst.lastDate DESC");
        hql.append(", itemMst.orderUnitQuantity DESC");
        hql.append(", itemMst.onsaleDate DESC");
        hql.append(", itemMst.lastQuantity DESC");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("classCd", classCd);
            query.setString("validityFlagDefault", "0");
            query.setString("validityFlag", "1");
            query.setFetchSize(2);
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }
}

