/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db.dao;

import java.io.Serializable;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.BaseDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.JournalSearchTableData;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class JournalDetailDAO
extends BaseDAO {
    public Serializable save(Session session, JournalDetail journalDetail) {
        return session.save((Object)journalDetail);
    }

    public void saveJournalDetail(JournalDetail journalDetail) {
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            try {
                transaction = session.beginTransaction();
                this.save(session, journalDetail);
                transaction.commit();
            }
            catch (HibernateException e) {
                this.rollback(transaction);
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public int updatejournalDetail(Session session, JournalDetail journalDetail) {
        StringBuffer hql = new StringBuffer();
        hql.append("UPDATE");
        hql.append(" JournalDetail journalDetail");
        hql.append(" SET");
        hql.append(" journalDetail.comp_id.seq = :minusSeq");
        hql.append(" WHERE");
        hql.append(" journalDetail.comp_id.slipNo = :slipNo");
        hql.append(" AND journalDetail.comp_id.seq = :seq");
        Query query = session.createQuery(hql.toString());
        query.setString("slipNo", journalDetail.getComp_id().getSlipNo());
        query.setInteger("seq", journalDetail.getComp_id().getSeq().intValue());
        query.setInteger("minusSeq", -1 * journalDetail.getComp_id().getSeq());
        return query.executeUpdate();
    }

    public List<JournalDetail> findBySlip(String slipNo, Integer seq) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" journalDetail");
        hql.append(" FROM");
        hql.append(" JournalDetail journalDetail");
        hql.append(" WHERE");
        hql.append(" journalDetail.comp_id.slipNo = :slipNo");
        hql.append(" AND journalDetail.comp_id.seq = :seq");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("slipNo", slipNo);
            query.setInteger("seq", seq.intValue());
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<JournalSearchTableData> findByCancel(String kindCd, String slipNo, String itemCd) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" new " + JournalSearchTableData.class.getName() + "(");
        hql.append(" journalDetail.comp_id.slipNo");
        hql.append(", journalDetail.comp_id.seq");
        hql.append(", slip.createDate");
        hql.append(", journalDetail.itemCd");
        hql.append(", journalDetail.makerCd");
        hql.append(", journalDetail.classCd");
        hql.append(", journalDetail.itemName");
        hql.append(", journalDetail.itemNum");
        hql.append(", journalDetail.price");
        hql.append(", journalDetail.cost");
        hql.append(", journalDetail.itemQuantity");
        if (kindCd.equals("U0")) {
            hql.append(", journalDetail.amount - COALESCE(journalDetail.discountAmount, 0)");
        } else {
            hql.append(", journalDetail.amount");
        }
        hql.append(" )");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", JournalHead journalHead");
        hql.append(", JournalDetail journalDetail");
        hql.append(" WHERE");
        hql.append(" slip.kindMst.kindCd = :kindCd");
        if (PosStringUtils.isNotEmpty(slipNo)) {
            if (slipNo.length() >= 16) {
                hql.append(" AND slip.slipNo = :slipNo");
            } else if (slipNo.length() == 15) {
                hql.append(" AND (slip.slipNo LIKE :slipNoFront");
                hql.append("  OR slip.slipNo LIKE :slipNoBack)");
            } else {
                hql.append(" AND slip.slipNo LIKE :slipNo");
            }
        }
        hql.append(" AND journalHead.slipNo = slip.slipNo");
        hql.append(" AND journalDetail.comp_id.slipNo = slip.slipNo");
        hql.append(" AND journalDetail.comp_id.seq > 0");
        if (PosStringUtils.isNotEmpty(itemCd)) {
            if (itemCd.length() >= 30) {
                hql.append(" AND UPPER(journalDetail.makerCd) = :makerCd");
            } else if (itemCd.length() == 29) {
                hql.append(" AND (UPPER(journalDetail.makerCd) LIKE :makerCdFront");
                hql.append("  OR UPPER(journalDetail.makerCd) LIKE :makerCdBack)");
            } else {
                hql.append(" AND UPPER(journalDetail.makerCd) LIKE :makerCd");
            }
        }
        hql.append(" ORDER BY");
        hql.append(" journalDetail.comp_id.slipNo");
        hql.append(", journalDetail.comp_id.seq");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("kindCd", kindCd);
            if (PosStringUtils.isNotEmpty(slipNo)) {
                if (slipNo.length() >= 16) {
                    query.setString("slipNo", slipNo);
                } else if (slipNo.length() == 15) {
                    query.setString("slipNoFront", String.valueOf(slipNo) + "%");
                    query.setString("slipNoBack", "%" + slipNo);
                } else {
                    query.setString("slipNo", "%" + slipNo + "%");
                }
            }
            if (PosStringUtils.isNotEmpty(itemCd)) {
                if (itemCd.length() >= 30) {
                    query.setString("makerCd", itemCd.toUpperCase());
                } else if (itemCd.length() == 29) {
                    query.setString("makerCdFront", String.valueOf(itemCd.toUpperCase()) + "%");
                    query.setString("makerCdBack", "%" + itemCd.toUpperCase());
                } else {
                    query.setString("makerCd", "%" + itemCd.toUpperCase() + "%");
                }
            }
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public long getMaxBarcodeNo(String barcodeTop) {
        long result = 0L;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" MAX(journalDetail.barcode)");
        hql.append(" FROM");
        hql.append(" JournalDetail journalDetail");
        hql.append(" WHERE");
        hql.append(" journalDetail.itemCd LIKE :prefix");
        hql.append(" AND journalDetail.barcode LIKE :barcodeTop");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("prefix", "USED_%");
            query.setString("barcodeTop", String.valueOf(barcodeTop) + "%");
            String tmp = (String)query.uniqueResult();
            result = tmp == null ? 0L : Long.valueOf(tmp.substring(4, 12));
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }
}

