/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.dialogs;

import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import jp.ne.k_tech.kposrcp.kpos.gui.component.MoneyText;
import jp.ne.k_tech.kposrcp.kpos.gui.component.QuantityText;
import jp.ne.k_tech.kposrcp.kpos.logic.PosSales;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogCashier
extends DialogAbstract {
    private static Log log = LogFactory.getLog(DialogCashier.class);
    private static final String BR = System.getProperty("line.separator");
    private Text salesItemQuantityTotal = null;
    private Text salesItemAmount = null;
    private Text salesItemTax = null;
    private Text salesItemAmountWithTax = null;
    private Text salesPercent = null;
    private Text salesDiscount = null;
    private Text salesMoney = null;
    private Text salesChange = null;
    private Button salesCredit = null;
    private long amountWithTax = 0L;

    @Override
    public Composite createDialog(Display display, final Shell shell) {
        log.debug((Object)"\u8ca9\u58f2\u4f1a\u8a08\u30c0\u30a4\u30a2\u30ed\u30b0\u751f\u6210\u958b\u59cb");
        Composite base = null;
        shell.setText("\u8ca9\u58f2\u4f1a\u8a08");
        shell.setSize(new Point(1000, 338));
        shell.setLayout((Layout)new GridLayout(1, true));
        base = new Composite((Composite)shell, 0);
        base.setLayout((Layout)new GridLayout(1, true));
        base.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        Composite headerArea = new Composite(base, 0);
        headerArea.setLayout((Layout)new GridLayout(1, false));
        Composite middleArea = new Composite(base, 2048);
        middleArea.setLayout((Layout)new GridLayout(9, true));
        middleArea.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        Composite middleBottom1Area = new Composite(base, 2048);
        middleBottom1Area.setLayout((Layout)new GridLayout(5, false));
        middleBottom1Area.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        Composite footerArea = new Composite(base, 0);
        footerArea.setLayout((Layout)new GridLayout(3, false));
        Composite buttonArea = new Composite(base, 0);
        buttonArea.setLayout((Layout)new GridLayout(10, false));
        Label labelTopTitle = new Label(headerArea, 0);
        labelTopTitle.setText(shell.getText());
        labelTopTitle.setFont(this.posMain.getLargeFont());
        Label labelMessage = new Label(headerArea, 0);
        StringBuffer message = new StringBuffer();
        message.append("\u304a\u9810\u304b\u308a\u306e\u91d1\u984d\u3092\u5165\u529b\u3057\u307e\u3059\u3002");
        message.append(BR);
        message.append("\u91d1\u984d\u3092\u5165\u529b\u3057\u3066\uff3bEnter\uff3d\u30ad\u30fc\u3067\u6c7a\u5b9a\u3057\u307e\u3059\u3002");
        labelMessage.setText(message.toString());
        labelMessage.setFont(this.posMain.getNormalFont());
        Label labelSalesItemQuantityTotal = new Label(middleArea, 0);
        labelSalesItemQuantityTotal.setText("\u5546\u54c1\u70b9\u6570");
        labelSalesItemQuantityTotal.setFont(this.posMain.getNormalFont());
        this.salesItemQuantityTotal = new QuantityText(this.posMain, middleArea).getText(false);
        Label labelSalesItemQuantityTotalEnd = new Label(middleArea, 0);
        labelSalesItemQuantityTotalEnd.setText("\u70b9");
        labelSalesItemQuantityTotalEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesItemAmount = new Label(middleArea, 0);
        labelSalesItemAmount.setText("\u7a0e\u629c\u304d\u5408\u8a08");
        labelSalesItemAmount.setFont(this.posMain.getNormalFont());
        this.salesItemAmount = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesItemAmountEnd = new Label(middleArea, 0);
        labelSalesItemAmountEnd.setText("\u5186");
        labelSalesItemAmountEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesItemTax = new Label(middleArea, 0);
        labelSalesItemTax.setText("\u6d88\u8cbb\u7a0e");
        labelSalesItemTax.setFont(this.posMain.getNormalFont());
        this.salesItemTax = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesItemTaxEnd = new Label(middleArea, 0);
        labelSalesItemTaxEnd.setText("\u5186");
        labelSalesItemTaxEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesPercent = new Label(middleArea, 0);
        labelSalesPercent.setText("\u5272\u5f15\u304d");
        labelSalesPercent.setFont(this.posMain.getNormalFont());
        this.salesPercent = new QuantityText(this.posMain, middleArea, 2).getText(true);
        this.salesPercent.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NumberUtils.toInt((String)DialogCashier.this.salesPercent.getText(), (int)-1) > 0) {
                    DialogCashier.this.salesDiscount.setText(PosNumberUtils.commaFormat(0L));
                }
                DialogCashier.this.setSalesItemAmountWithTax();
                DialogCashier.this.setSalesChange();
            }
        });
        Label labelSalesPercentEnd = new Label(middleArea, 0);
        labelSalesPercentEnd.setText("\uff05\u5f15\u304d");
        labelSalesPercentEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesPoint = new Label(middleArea, 0);
        labelSalesPoint.setText("");
        labelSalesPoint.setFont(this.posMain.getNormalFont());
        Label labelSalesPointDummy = new Label(middleArea, 0);
        labelSalesPointDummy.setText(" ");
        Label labelSalesPointEnd = new Label(middleArea, 0);
        labelSalesPointEnd.setText(" ");
        labelSalesPointEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesDiscount = new Label(middleArea, 0);
        labelSalesDiscount.setText("\u5024\u5f15\u304d");
        labelSalesDiscount.setFont(this.posMain.getNormalFont());
        this.salesDiscount = new MoneyText(this.posMain, middleArea).getText(true);
        this.salesDiscount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NumberUtils.toInt((String)DialogCashier.this.salesDiscount.getText(), (int)-1) > 0) {
                    DialogCashier.this.salesPercent.setText(PosNumberUtils.commaFormat(0L));
                }
                DialogCashier.this.setSalesItemAmountWithTax();
                DialogCashier.this.setSalesChange();
            }
        });
        Label labelSalesDiscountEnd = new Label(middleArea, 0);
        labelSalesDiscountEnd.setText("\u5186\u5f15\u304d");
        labelSalesDiscountEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesItemAmountWithTax = new Label(middleArea, 0);
        labelSalesItemAmountWithTax.setText("\u8ca9\u58f2\u7a0e\u8fbc\u307f\u5408\u8a08");
        labelSalesItemAmountWithTax.setFont(this.posMain.getNormalFont());
        this.salesItemAmountWithTax = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesItemAmountWithTaxEnd = new Label(middleArea, 0);
        labelSalesItemAmountWithTaxEnd.setText("\u5186");
        labelSalesItemAmountWithTaxEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesMoney = new Label(middleArea, 0);
        labelSalesMoney.setText("\u9810\u308a\u91d1");
        labelSalesMoney.setFont(this.posMain.getNormalFont());
        this.salesMoney = new MoneyText(this.posMain, middleArea).getText(true);
        this.salesMoney.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogCashier.this.setSalesChange();
            }
        });
        Label labelSalesMoneyEnd = new Label(middleArea, 0);
        labelSalesMoneyEnd.setText("\u5186");
        labelSalesMoneyEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesChange = new Label(middleArea, 0);
        labelSalesChange.setText("\u304a\u91e3\u308a");
        labelSalesChange.setFont(this.posMain.getNormalFont());
        this.salesChange = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesChangeEnd = new Label(middleArea, 0);
        labelSalesChangeEnd.setText("\u5186");
        labelSalesChangeEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesCredit = new Label(middleBottom1Area, 0);
        labelSalesCredit.setText("\u3000\u30af\u30ec\u30b8\u30c3\u30c8(K)");
        labelSalesCredit.setFont(this.posMain.getNormalFont());
        this.salesCredit = new Button(middleBottom1Area, 32);
        this.salesCredit.setFont(this.posMain.getNormalFont());
        Label labelSalesCreditMessage = new Label(middleBottom1Area, 0);
        labelSalesCreditMessage.setText("\u3000");
        labelSalesCreditMessage.setFont(this.posMain.getNormalFont());
        Label labelFooter = new Label(footerArea, 0);
        labelFooter.setText("[ENTER]\u6c7a\u5b9a\u3000[ESC]\u53d6\u6d88\u3057\u3000[\u2191\u3042\u308b\u3044\u306f\u2190] [\u2193\u3042\u308b\u3044\u306f\u2192]\u30d5\u30a9\u30fc\u30ab\u30b9\u79fb\u52d5");
        labelFooter.setFont(this.posMain.getNormalFont());
        this.buttonOk = new Button(buttonArea, 0);
        this.buttonOk.setText("\u3000\u3000\uff2f\u3000\uff2b\u3000\u3000");
        this.buttonOk.setFont(this.posMain.getLargeFont());
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogCashier.this.salesMoney.setFocus();
                PosSales posSales = new PosSales(DialogCashier.this.posMain);
                if (posSales.enterDialogCashier(DialogCashier.this.instance) && !shell.isDisposed()) {
                    shell.close();
                }
            }
        });
        Label work1 = new Label(buttonArea, 0);
        work1.setText("    ");
        work1.setFont(this.posMain.getNormalFont());
        this.buttonCancel = new Button(buttonArea, 0);
        this.buttonCancel.setText("\u3000\u3000\u53d6\u6d88\u3057\u3000\u3000");
        this.buttonCancel.setFont(this.posMain.getLargeFont());
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!shell.isDisposed()) {
                    shell.close();
                }
            }
        });
        base.layout();
        this.initText();
        log.debug((Object)"\u8ca9\u58f2\u4f1a\u8a08\u30c0\u30a4\u30a2\u30ed\u30b0\u751f\u6210\u7d42\u4e86");
        return base;
    }

    @Override
    public Control[] getAllControl() {
        Control[] objects = null;
        objects = new Control[]{this.salesPercent, this.salesDiscount, this.salesMoney};
        return objects;
    }

    private void initText() {
        this.salesPercent.setText(PosNumberUtils.commaFormat(0L));
        this.salesDiscount.setText(PosNumberUtils.commaFormat(0L));
        this.salesItemQuantityTotal.setText(PosNumberUtils.commaFormat(this.posMain.getPosTabFolder().calcQuantityTotal()));
        this.salesItemAmount.setText(PosNumberUtils.commaFormat(this.posMain.getPosTabFolder().calcAmount()));
        this.salesItemTax.setText(PosNumberUtils.commaFormat(this.posMain.getPosTabFolder().calcTax()));
        this.amountWithTax = this.posMain.getPosTabFolder().calcAmountWithTax();
        this.salesItemAmountWithTax.setText(PosNumberUtils.commaFormat(this.amountWithTax));
        this.salesChange.setText(PosNumberUtils.commaFormat(0L));
    }

    public boolean validate() {
        if (this.getSalesItemAmountWithTax() <= 0L) {
            this.posMain.getStatusBar().setText("\u8ca9\u58f2\u7a0e\u8fbc\u307f\u5408\u8a08\u304c\uff10\u5186\u3068\u306a\u308b\u8a2d\u5b9a\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        long l = this.getSalesMoney() - this.getSalesItemAmountWithTax();
        if (l < 0L) {
            this.posMain.getStatusBar().setText("\u9810\u308a\u91d1\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        if ("1".equals(this.getSalesCredit()) && l != 0L) {
            this.posMain.getStatusBar().setText("\u30af\u30ec\u30b8\u30c3\u30c8\u306e\u3068\u304d\u306f\u9810\u308a\u91d1\u306f\u8ca9\u58f2\u7a0e\u8fbc\u307f\u5408\u8a08\u3068\u540c\u984d\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002");
            return false;
        }
        return true;
    }

    private void setSalesChange() {
        long l = this.getSalesMoney() - this.getSalesItemAmountWithTax();
        if (l > 0L) {
            this.salesChange.setText(PosNumberUtils.commaFormat(l));
        } else {
            this.salesChange.setText(PosNumberUtils.commaFormat(0L));
        }
    }

    private void setSalesItemAmountWithTax() {
        long l = this.amountWithTax - this.getDiscountAmount();
        if (l > 0L) {
            this.salesItemAmountWithTax.setText(PosNumberUtils.commaFormat(l));
        } else {
            this.salesItemAmountWithTax.setText(PosNumberUtils.commaFormat(0L));
        }
    }

    public long getSalesChange() {
        return PosNumberUtils.commaParse(this.salesChange.getText());
    }

    public String getSalesCredit() {
        if (this.salesCredit.getSelection()) {
            return "1";
        }
        return "0";
    }

    private long getSalesDiscount() {
        return NumberUtils.toLong((String)this.salesDiscount.getText());
    }

    public long getSalesItemAmount() {
        return PosNumberUtils.commaParse(this.salesItemAmount.getText());
    }

    public long getSalesItemAmountWithTax() {
        return PosNumberUtils.commaParse(this.salesItemAmountWithTax.getText());
    }

    public long getSalesItemQuantityTotal() {
        return PosNumberUtils.commaParse(this.salesItemQuantityTotal.getText());
    }

    public long getSalesItemTax() {
        return PosNumberUtils.commaParse(this.salesItemTax.getText());
    }

    public long getSalesMoney() {
        return PosNumberUtils.commaParse(StringUtils.defaultIfEmpty((String)this.salesMoney.getText(), (String)"0"));
    }

    private double getSalesPercent() {
        return NumberUtils.toDouble((String)this.salesPercent.getText()) / 100.0;
    }

    public long getDiscountAmount() {
        String saleKind = this.getSaleKind();
        if ("1".equals(saleKind)) {
            return this.discount(this.amountWithTax, this.getSalesPercent());
        }
        if ("2".equals(saleKind)) {
            return MstManager.getInstance().findPricePerPoint() * (long)this.getUsePoint().intValue();
        }
        if ("3".equals(saleKind)) {
            return this.getSalesDiscount();
        }
        return 0L;
    }

    public Integer getUsePoint() {
        return 0;
    }

    public String getCustomerSex() {
        String sex = null;
        return sex;
    }

    public void setCustomerSex(String sex) {
    }

    public String getCustomerAge() {
        String age = null;
        return age;
    }

    public void setCustomerAge(String age) {
    }

    public String getRepeater() {
        return PosConstants.REPEATER_OFF;
    }

    public void setCheckRepeater() {
    }

    public String getCustomerCd() {
        return null;
    }

    public void setCustomerFocus() {
    }

    public String getWebSaleKind() {
        String websale = null;
        return websale;
    }

    public void setWebSaleKind(String websale) {
        if (this.salesCredit.getSelection()) {
            return;
        }
    }

    public String getSaleKind() {
        String sale = null;
        sale = NumberUtils.toInt((String)this.salesPercent.getText(), (int)-1) > 0 ? "1" : (NumberUtils.toInt((String)this.salesDiscount.getText(), (int)-1) > 0 ? "3" : "0");
        return sale;
    }

    public void setSalesCredit() {
        boolean selection = true;
        if (this.salesCredit.getSelection()) {
            selection = false;
        }
        this.salesCredit.setSelection(selection);
    }
}

