/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list;

import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmBarcode;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ItemListMoveIn
extends ItemList {
    private static Log log = LogFactory.getLog(ItemListMoveIn.class);
    private String storeCd = null;
    private DbmBarcode.MoveBarcode moveBarcode;

    public ItemListMoveIn(PosMain posMain, int tabindex) {
        super(posMain, tabindex);
        try {
            this.storeCd = MstManager.getInstance().findStoreMstByCD().getStoreCd();
        }
        catch (AbsentMstException absentMstException) {
            this.storeCd = "";
        }
    }

    @Override
    public void addRow(ItemMst itemMst) throws AbsentMstException {
        log.debug((Object)"addRow@override");
        if ("0".equals(itemMst.getUsedFlag())) {
            this.posMain.getStatusBar().setText("\u4e2d\u53e4\u8cb7\u53d6\u5546\u54c1\u4ee5\u5916\u3092\u5e97\u9593\u5165\u5eab\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        if (this.moveBarcode == null) {
            this.posMain.getStatusBar().setText("\u51fa\u5eab\u30ec\u30b7\u30fc\u30c8\u306e\u30d0\u30fc\u30b3\u30fc\u30c9\u3092\u8aad\u307f\u53d6\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        String fromStoreName = "";
        try {
            fromStoreName = MstManager.getInstance().findStoreNameByCD(this.moveBarcode.getFromStoreCd());
        }
        catch (AbsentMstException absentMstException) {
            log.debug((Object)"\u5e97\u8217\u540d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
            return;
        }
        if (!this.isSameStoreName(fromStoreName)) {
            this.posMain.getStatusBar().setText(String.format("\u79fb\u52d5\u5143\u304c\u7570\u306a\u308a\u307e\u3059\u3002[\u5546\u54c1\u756a\u53f7\uff1a%s\uff0c\u5546\u54c1\u540d\uff1a%s\uff0c\u5bfe\u8c61\u5e97(\u79fb\u52d5\u5143)\uff1a%s]", itemMst.getComp_id().getItemCd(), itemMst.getItemName(), fromStoreName));
            return;
        }
        DbmBarcode.MoveBarcode mb = this.moveBarcode;
        super.addRow(itemMst);
        this.moveBarcode = mb;
        this.refreshMoveInInfo();
        super.updateTableItemList(13, fromStoreName);
    }

    public void setMoveBarcode(String moveBarcode) {
        String info = moveBarcode.substring("23".length());
        log.debug((Object)("\u79fb\u52d5\u30d0\u30fc\u30b3\u30fc\u30c9\u8a2d\u5b9a\uff1a" + info));
        DbmBarcode dbmBarcode = MstManager.getInstance().getDbmBarcode();
        dbmBarcode.getClass();
        DbmBarcode.MoveBarcode mb = dbmBarcode.new DbmBarcode.MoveBarcode(info.substring(0, 3), info.substring(3, 6), info.substring(6, 10));
        if (!this.storeCd.equals(mb.getToStoreCd())) {
            this.posMain.getStatusBar().setText("\u5e97\u9593\u5165\u5eab\u5bfe\u8c61\u5e97\u8217\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        if (!this.getFinished() && this.getTableItemList().getItemCount() > 0) {
            this.posMain.getStatusBar().setText("\u5e97\u9593\u5165\u5eab\u51e6\u7406\u4e2d\u306b\u51fa\u5eab\u30ec\u30b7\u30fc\u30c8\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        this.removeAll();
        log.debug((Object)PosStringUtils.toString4Bean(mb));
        this.moveBarcode = mb;
        this.refreshMoveInInfo();
    }

    private void refreshMoveInInfo() {
        String itemsQuantity = null;
        String fromStoreCd = null;
        if (this.moveBarcode != null) {
            itemsQuantity = Integer.toString(this.moveBarcode.getCount());
            fromStoreCd = this.moveBarcode.getFromStoreCd();
        }
        this.posMain.getPosTabFolder().setMoveinReceiptItemsQuantity(itemsQuantity);
        this.posMain.getPosTabFolder().setMoveinReceiptFromStore(fromStoreCd);
    }

    private void clearMoveBarcode() {
        this.moveBarcode = null;
        this.refreshMoveInInfo();
    }

    @Override
    public void finished() {
        super.finished();
        this.clearMoveBarcode();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.clearMoveBarcode();
    }

    @Override
    public void removeRow() {
        super.removeRow();
        if (this.getTableItemList().getItemCount() <= 0) {
            this.clearMoveBarcode();
        }
    }
}

