/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list;

import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.JournalSearchTableData;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class JournalSearchResultList {
    private static Log log = LogFactory.getLog(JournalSearchResultList.class);
    private Table tableJournalSearchResultList = null;
    private List<JournalSearchTableData> bodyList = null;

    public JournalSearchResultList(PosMain posMain, List<JournalSearchTableData> list) {
        this.bodyList = list;
    }

    public void createJournalSearchResultList(Composite parent, final String kindCd) {
        this.tableJournalSearchResultList = new Table(parent, 67586);
        this.tableJournalSearchResultList.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tableJournalSearchResultList.setLinesVisible(true);
        this.tableJournalSearchResultList.setHeaderVisible(true);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                log.debug((Object)String.format("widgetDefaultSelected", new Object[0]));
            }

            public void widgetSelected(SelectionEvent e) {
                if (!"U0".equals(kindCd) && !"S0".equals(kindCd)) {
                    return;
                }
                int index = JournalSearchResultList.this.tableJournalSearchResultList.getSelectionIndex();
                if (index >= 0) {
                    JournalSearchResultList.this.tableJournalSearchResultList.deselectAll();
                    String slipNo = JournalSearchResultList.this.tableJournalSearchResultList.getItem(index).getText(1);
                    boolean start = false;
                    int i = 0;
                    while (i < JournalSearchResultList.this.tableJournalSearchResultList.getItemCount()) {
                        if (slipNo.equals(JournalSearchResultList.this.tableJournalSearchResultList.getItem(i).getText(1)) && !start) {
                            start = true;
                        }
                        if (start && !slipNo.equals(JournalSearchResultList.this.tableJournalSearchResultList.getItem(i).getText(1))) break;
                        if (start && !JournalSearchResultList.this.tableJournalSearchResultList.isSelected(i)) {
                            JournalSearchResultList.this.tableJournalSearchResultList.select(i);
                        }
                        ++i;
                    }
                }
            }
        };
        this.tableJournalSearchResultList.addSelectionListener((SelectionListener)selectionAdapter);
        this.tableJournalSearchResultList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: {
                        if ((e.stateMask & 0x40000) == 0) break;
                        e.doit = false;
                        break;
                    }
                    default: {
                        e.doit = false;
                    }
                }
            }
        });
        this.initJournalSearchResultTableHeader();
        this.refreshBody(kindCd);
        if (this.tableJournalSearchResultList.getItemCount() > 0) {
            this.tableJournalSearchResultList.setSelection(0);
            selectionAdapter.widgetSelected(null);
        }
    }

    private void initJournalSearchResultTableHeader() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < PosConstants.COLUMN_NAME_JOURNALSEARCH.length) {
            TableColumn column = new TableColumn(this.tableJournalSearchResultList, 16384);
            column.setText(PosConstants.COLUMN_NAME_JOURNALSEARCH[i]);
            int w = PosConstants.COLUMN_WIDTH_JOURNALSEARCH[i];
            layout.addColumnData((ColumnLayoutData)(w > 0 ? new ColumnWeightData(w) : new ColumnPixelData(0)));
            column.setResizable(w > 0);
            if (ArrayUtils.contains((Object[])PosConstants.COLUMN_NAMES_ALIGN_RIGHT, (Object)PosConstants.COLUMN_NAME_JOURNALSEARCH[i])) {
                column.setAlignment(131072);
            }
            ++i;
        }
        this.tableJournalSearchResultList.setLayout((Layout)layout);
        this.tableJournalSearchResultList.layout();
    }

    private void refreshBody(String kindCd) {
        ArrayList<JournalSearchTableData> resultList = new ArrayList<JournalSearchTableData>();
        String kindName = null;
        try {
            kindName = MstManager.getInstance().findKindNameByCD(kindCd);
        }
        catch (AbsentMstException absentMstException) {
            kindName = "--";
        }
        int i = 0;
        while (i < this.bodyList.size()) {
            block12: {
                JournalSearchTableData journalSearchTableData = this.bodyList.get(i);
                if (PosConstants.SEARCH_MAX_RECORD <= i) {
                    resultList.add(journalSearchTableData);
                    break;
                }
                String className = null;
                try {
                    className = MstManager.getInstance().findClassNameByCD(journalSearchTableData.getClassCd());
                }
                catch (AbsentMstException e) {
                    log.error((Object)"\u30de\u30b9\u30bf\u53d6\u5f97\u5931\u6557\uff0e", (Throwable)e);
                    break block12;
                }
                TableItem item = new TableItem(this.tableJournalSearchResultList, 0);
                int count = this.tableJournalSearchResultList.getItemCount();
                item.setBackground(count % 2 == 1 ? JFaceResources.getColorRegistry().get("white") : JFaceResources.getColorRegistry().get("aliceblue"));
                item.setImage(Activator.getDefault().getImageRegistry().get("bgdummy"));
                int col = 0;
                item.setText(col++, String.valueOf(this.tableJournalSearchResultList.getItemCount()));
                item.setText(col++, journalSearchTableData.getSlipNo());
                item.setText(col++, journalSearchTableData.getSeq().toString());
                item.setText(col++, PosDateUtils.format_yyyyMMddHHmm(journalSearchTableData.getCreateDate()));
                item.setText(col++, kindName);
                item.setText(col++, journalSearchTableData.getMakerCd());
                item.setText(col++, className);
                item.setText(col++, StringUtils.defaultString((String)journalSearchTableData.getItemName()));
                item.setText(col++, ObjectUtils.toString((Object)journalSearchTableData.getItemNum()));
                item.setText(col++, PosNumberUtils.currencyFormat(journalSearchTableData.getPrice()));
                if (journalSearchTableData.getCost() == null) {
                    item.setText(col++, "");
                } else {
                    item.setText(col++, PosNumberUtils.currencyFormat(journalSearchTableData.getCost()));
                }
                if (journalSearchTableData.getItemQuantity() == null) {
                    item.setText(col++, "");
                } else {
                    item.setText(col++, PosNumberUtils.commaFormat(journalSearchTableData.getItemQuantity().intValue()));
                }
                if (journalSearchTableData.getAmount() == null) {
                    item.setText(col++, "");
                } else {
                    item.setText(col++, PosNumberUtils.currencyFormat(journalSearchTableData.getAmount()));
                }
                resultList.add(journalSearchTableData);
            }
            ++i;
        }
        this.bodyList.clear();
        this.bodyList.addAll(resultList);
    }

    public Table getItemSearchResultList() {
        return this.tableJournalSearchResultList;
    }

    public List<JournalSearchTableData> getSelectedData() {
        ArrayList<JournalSearchTableData> list = new ArrayList<JournalSearchTableData>();
        int i = 0;
        while (i < this.tableJournalSearchResultList.getItemCount()) {
            if (this.tableJournalSearchResultList.isSelected(i)) {
                list.add(this.bodyList.get(i));
            }
            ++i;
        }
        return list;
    }
}

