/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list.valueobject;

import java.io.Serializable;
import java.util.Date;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.exception.InappropriateUsageException;
import org.apache.commons.lang.StringUtils;

public class IndicateTableData
implements Serializable {
    public static final int INDICATE_KIND_MOVE = 0;
    public static final int INDICATE_KIND_BACK = 1;
    public static final String[] INDICATE_KIND_NAMES = new String[]{"\u79fb\u52d5\u6307\u793a", "\u8fd4\u54c1\u6307\u793a"};
    private int indicateKindCd = -1;
    private String kindCd = null;
    private String indicateKindName = null;
    private Date indicateDate = null;
    private Date limitDate = null;
    private long amount = 0L;
    private String cd = null;

    public IndicateTableData(String kindCd, Date indicateDate, Date limitDate, long amount, String cd, int indicateKindCd) {
        this.kindCd = kindCd;
        this.indicateDate = indicateDate;
        this.limitDate = limitDate;
        this.amount = amount;
        this.cd = cd;
        this.indicateKindCd = indicateKindCd;
        if (StringUtils.isEmpty((String)kindCd)) {
            return;
        }
        this.indicateKindName = INDICATE_KIND_NAMES[indicateKindCd];
    }

    public String getKindCd() {
        return this.kindCd;
    }

    public void setKindCd(String kindCd) {
        this.kindCd = kindCd;
    }

    public Date getIndicateDate() {
        return this.indicateDate;
    }

    public void setIndicateDate(Date indicateDate) {
        this.indicateDate = indicateDate;
    }

    public Date getLimitDate() {
        return this.limitDate;
    }

    public void setLimitDate(Date limitDate) {
        this.limitDate = limitDate;
    }

    public String getCd() {
        return this.cd;
    }

    public void setCd(String cd) {
        this.cd = cd;
    }

    public String getName() throws AbsentMstException {
        String name = null;
        MstManager mstManager = MstManager.getInstance();
        if ("C2".equals(this.kindCd)) {
            name = mstManager.findStoreNameByCD(this.cd);
        } else if ("A3".equals(this.kindCd)) {
            name = mstManager.findSupplierNameByCD(this.cd);
        } else {
            throw new InappropriateUsageException(String.format("\u533a\u5206\u304c\u4e0d\u9069\u5207\u3067\u3059\uff0e[%s]", this.kindCd));
        }
        return name;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public String getIndicateKindName() {
        return this.indicateKindName;
    }

    public void setIndicateKindName(String indicateKindName) {
        this.indicateKindName = indicateKindName;
    }

    public int getIndicateKindCd() {
        return this.indicateKindCd;
    }

    public void setIndicateKindCd(int indicateKindCd) {
        this.indicateKindCd = indicateKindCd;
    }
}

