/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCheck;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.CheckMoneyData;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosCheck
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosCheck.class);

    public PosCheck(PosMain posMain) {
        super(posMain);
    }

    public boolean enterDialog(DialogAbstract dialog) {
        log.info((Object)"\u70b9\u691c:START");
        DialogCheck dialogCheck = (DialogCheck)dialog;
        if (!dialogCheck.validate()) {
            log.info((Object)"\u70b9\u691c:END");
            return false;
        }
        dialogCheck.setMoney();
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD("K0"));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd("K0");
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setTotalSaleAmount(dialogCheck.getMoneyTotal());
        journalHead.setTotalAmount(dialogCheck.getCashTotal());
        journalHead.setInfo(this.journalInfo());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead);
        ReceiptCheck receiptSales = new ReceiptCheck(dialogCheck.getDiff());
        receiptSales.setJournalHead(journalHead);
        receiptSales.executePrint(this.posMain, slipNo);
        CheckMoneyData.refresh();
        this.posMain.updateLabelSlipNo();
        this.posMain.getStatusBar().setText("\u70b9\u691c\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        log.info((Object)"\u70b9\u691c:END");
        return true;
    }

    public void escapeDialog(DialogAbstract dialog) {
        log.info((Object)"\u70b9\u691c[\u91d1\u7a2e\u5185\u5bb9\u4fdd\u5b58]:START");
        DialogCheck dialogCheck = (DialogCheck)dialog;
        dialogCheck.setMoney();
        log.info((Object)"\u70b9\u691c[\u91d1\u7a2e\u5185\u5bb9\u4fdd\u5b58]:END");
    }

    private String journalInfo() {
        String info = "10000\u5186\u672d<%10000>\u679a 5000\u5186\u672d<%5000>\u679a 2000\u5186\u672d<%2000>\u679a 1000\u5186\u672d<%1000>\u679a 500\u5186\u7389<%500>\u679a 100\u5186\u7389<%100>\u679a 50\u5186\u7389<%50>\u679a 10\u5186\u7389<%10>\u679a 5\u5186\u7389<%5>\u679a 1\u5186\u7389<%1>\u679a";
        info = info.replace("<%10000>", CheckMoneyData.getInstance().getMoney10000());
        info = info.replace("<%5000>", CheckMoneyData.getInstance().getMoney5000());
        info = info.replace("<%2000>", CheckMoneyData.getInstance().getMoney2000());
        info = info.replace("<%1000>", CheckMoneyData.getInstance().getMoney1000());
        info = info.replace("<%500>", CheckMoneyData.getInstance().getMoney500());
        info = info.replace("<%100>", CheckMoneyData.getInstance().getMoney100());
        info = info.replace("<%50>", CheckMoneyData.getInstance().getMoney50());
        info = info.replace("<%10>", CheckMoneyData.getInstance().getMoney10());
        info = info.replace("<%5>", CheckMoneyData.getInstance().getMoney5());
        info = info.replace("<%1>", CheckMoneyData.getInstance().getMoney1());
        return info;
    }
}

