/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayDispose;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptDispose;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.TableItem;

public class PosDispose
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosDispose.class);
    private ReceiptAbstract receiptRecycle = null;
    private DisplayAbstract displayRecycle = null;
    private ItemList itemList = null;

    public PosDispose(PosMain posMain) {
        super(posMain);
        this.itemList = posMain.getPosTabFolder().getPosAbstract()[posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList();
    }

    public boolean enterDialogDispose() {
        log.info((Object)"\u5ec3\u68c4:START");
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD("V0"));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd("B0");
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setDetailsCount(this.itemList.getBodyList().size());
        journalHead.setTotalItemQuantity(Long.valueOf(this.posMain.getPosTabFolder().calcQuantityTotal()).intValue());
        journalHead.setTotalAmount(this.posMain.getPosTabFolder().calcCostAmount());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        List<JournalDetail> journalDetailList = this.getJournalDetailList();
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead, journalDetailList);
        this.displayRecycle = new DisplayDispose();
        this.displayRecycle.setJournalHead(journalHead);
        this.displayRecycle.executePrint(this.posMain);
        this.receiptRecycle = new ReceiptDispose();
        this.receiptRecycle.setJournalHead(journalHead);
        this.receiptRecycle.setJournalDetail(journalDetailList);
        this.receiptRecycle.executePrint(this.posMain, slipNo);
        this.posMain.updateLabelSlipNo();
        if (!this.itemList.getFinished()) {
            this.itemList.finished();
        }
        this.posMain.getStatusBar().setText("\u5ec3\u68c4\u51e6\u7406\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        log.info((Object)"\u5ec3\u68c4:END");
        return true;
    }

    private List<JournalDetail> getJournalDetailList() {
        ArrayList<JournalDetail> journalDetailList = new ArrayList<JournalDetail>();
        List<ItemMst> list = this.itemList.getBodyList();
        int i = 0;
        while (i < list.size()) {
            TableItem tableItem = this.itemList.getTableItemList().getItem(i);
            ItemMst itemMst = list.get(i);
            JournalDetail journalDetail = new JournalDetail();
            journalDetail.setItemCd(itemMst.getComp_id().getItemCd());
            journalDetail.setSuppCd(itemMst.getComp_id().getSuppCd());
            journalDetail.setMakerCd(itemMst.getMakerCd());
            journalDetail.setItemName(tableItem.getText(4));
            journalDetail.setItemDetail1(itemMst.getItemDetail1());
            journalDetail.setItemDetail2(itemMst.getItemDetail2());
            journalDetail.setLabelCd(itemMst.getLabelCd());
            journalDetail.setClassCd(itemMst.getClassCd());
            journalDetail.setGenreCd(itemMst.getGenreCd());
            journalDetail.setOnsaleDate(itemMst.getOnsaleDate());
            journalDetail.setItemNum(itemMst.getItemNum());
            journalDetail.setPrice(Long.valueOf(tableItem.getText(11)));
            journalDetail.setPriceTaxKind(itemMst.getPriceTaxKind());
            journalDetail.setCost(Long.valueOf(tableItem.getText(12)));
            journalDetail.setCostTaxKind(itemMst.getCostTaxKind());
            String rankCd = null;
            try {
                rankCd = MstManager.getInstance().findRankCdByRankName(journalDetail.getClassCd(), tableItem.getText(13));
            }
            catch (AbsentMstException absentMstException) {
                rankCd = tableItem.getText(13);
            }
            journalDetail.setRankCd(rankCd);
            journalDetail.setBarcode(itemMst.getBarcode());
            journalDetail.setStockKind(itemMst.getStockKind());
            journalDetail.setOfficialBarcode(itemMst.getOfficialBarcode());
            journalDetail.setItemQuantity(Integer.valueOf(tableItem.getText(10)));
            journalDetail.setAmount((long)journalDetail.getItemQuantity().intValue() * PosNumberUtils.amountWithTax(journalDetail.getCost(), journalDetail.getCostTaxKind()));
            journalDetail.setMakerPrice(itemMst.getMakerPrice());
            journalDetail.setUsedFlag(itemMst.getUsedFlag());
            journalDetail.setSetFlag(itemMst.getSetFlag());
            journalDetail.setEndFlag(itemMst.getEndFlag());
            journalDetailList.add(journalDetail);
            ++i;
        }
        return journalDetailList;
    }
}

