/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.io.File;
import java.util.Date;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogMoney;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;

public class PosMoney
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosMoney.class);

    public PosMoney(PosMain posMain, Shell self) {
        super(posMain, self);
    }

    public void enterDialogMoney(DialogAbstract dialog) {
        log.info((Object)"\u91e3\u92ad\u51e6\u7406:START");
        DialogMoney dialogMoney = (DialogMoney)dialog;
        if (PosStringUtils.isEmpty(dialogMoney.getMoney())) {
            this.posMain.getStatusBar().setText("\u91e3\u92ad\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044");
            this.dialogCreate(dialog);
        } else if (!PosStringUtils.isInteger(dialogMoney.getMoney())) {
            this.posMain.getStatusBar().setText("\u91e3\u92ad\u306f\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044");
            this.dialogCreate(dialog);
        } else {
            DbmSlip dbmSlip = new DbmSlip();
            Slip slip = new Slip();
            try {
                slip.setKindMst(MstManager.getInstance().findKindMstByCD("R0"));
            }
            catch (AbsentMstException e) {
                log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
                KindMst kindMst = new KindMst();
                kindMst.setKindCd("R0");
                slip.setKindMst(kindMst);
            }
            slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd().trim());
            JournalHead journalHead = new JournalHead();
            journalHead.setTotalAmount(Long.valueOf(dialogMoney.getMoney()));
            journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd().trim());
            dbmSlip.regist(slip, journalHead);
            this.posMain.updateLabelSlipNo();
            this.self.close();
            this.posMain.getShell().setFocus();
            this.posMain.getStatusBar().setText("\u91e3\u92ad\u51e6\u7406\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
            this.renameRecycleSummaryCsv();
        }
        log.info((Object)"\u91e3\u92ad\u51e6\u7406:END");
    }

    private void renameRecycleSummaryCsv() {
        log.info((Object)"\u8cb7\u53d6\u96c6\u8a08\u7528CSV\u30d5\u30a1\u30a4\u30eb\u306e\u5b58\u5728\u30c1\u30a7\u30c3\u30af");
        log.debug((Object)"\u30d5\u30a1\u30a4\u30eb\u540d: recycle_summary.csv");
        File file = new File("recycle_summary.csv");
        if (file.isFile()) {
            String newFileName = String.valueOf(PosDateUtils.format_yyyyMMdd(new Date()).replaceAll("/", "")) + ".csv";
            log.warn((Object)("\u8cb7\u53d6\u96c6\u8a08\u7528CSV\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002\u30ea\u30cd\u30fc\u30e0\u3057\u3066\u9000\u907f\u3057\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u540d: " + newFileName));
            file.renameTo(new File(newFileName));
        } else {
            log.info((Object)"CSV\u30d5\u30a1\u30a4\u30eb\u306a\u3057");
        }
    }
}

