/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogMoveConfirm;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayMove;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptMove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosMove
extends LogicAbstract {
    private static Log logger = LogFactory.getLog(PosMove.class);
    private ReceiptAbstract receiptMove = null;
    private DisplayAbstract displayMove = null;
    private ItemList itemList = null;
    private String kindCd = null;
    private BigDecimal totalAmount = null;

    public PosMove(PosMain posMain) {
        super(posMain);
        this.itemList = posMain.getPosTabFolder().getPosAbstract()[posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList();
    }

    public boolean enterDialogMove(DialogAbstract dialog) {
        logger.info((Object)"\u51fa\u5165\u5eab:START");
        DialogMoveConfirm dialogMoveConfirm = (DialogMoveConfirm)dialog;
        logger.debug((Object)("\u51fa\u5165\u5eab\u5185\u5bb9:" + dialogMoveConfirm.getMoveInfo()));
        logger.debug((Object)("\u4ed6\u5e97\u8217\u30b3\u30fc\u30c9:" + dialogMoveConfirm.getMoveStoreCd()));
        if (this.kindCd == null) {
            logger.info((Object)"\u51fa\u5165\u5eab:END");
            return false;
        }
        this.totalAmount = BigDecimal.ZERO;
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD(this.kindCd));
        }
        catch (AbsentMstException e) {
            logger.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd(this.kindCd);
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        List<JournalDetail> journalDetailList = this.getJournalDetailList(dialogMoveConfirm.getMoveStoreCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setDetailsCount(this.itemList.getBodyList().size());
        journalHead.setTotalItemQuantity(BigDecimal.valueOf(this.posMain.getPosTabFolder().calcQuantityTotal()).intValue());
        journalHead.setTotalAmount(this.totalAmount.longValue());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead, journalDetailList);
        this.displayMove = new DisplayMove();
        this.displayMove.setJournalHead(journalHead);
        this.displayMove.executePrint(this.posMain);
        this.receiptMove = new ReceiptMove(this.kindCd, dialogMoveConfirm.getMoveInfo(), dialogMoveConfirm.getMoveStoreCd(), false);
        this.receiptMove.setJournalHead(journalHead);
        this.receiptMove.setJournalDetail(journalDetailList);
        this.receiptMove.executePrint(this.posMain, slipNo);
        if ("S0".equals(this.kindCd)) {
            this.receiptMove = new ReceiptMove(this.kindCd, dialogMoveConfirm.getMoveInfo(), dialogMoveConfirm.getMoveStoreCd(), true);
            this.receiptMove.setJournalHead(journalHead);
            this.receiptMove.setJournalDetail(journalDetailList);
            this.receiptMove.executePrint(this.posMain, SlipNoManager.getInstance().getNextSlipNo());
        }
        if ("S0".equals(this.kindCd)) {
            String storeName = null;
            try {
                storeName = MstManager.getInstance().findStoreNameByCD(dialogMoveConfirm.getMoveStoreCd());
            }
            catch (AbsentMstException absentMstException) {
                storeName = "";
            }
            this.itemList.updateTableItemListAll(13, storeName);
        }
        this.posMain.updateLabelSlipNo();
        if (!this.itemList.getFinished()) {
            this.itemList.finished();
        }
        if ("S0".equals(this.kindCd)) {
            this.posMain.getStatusBar().setText("\u5e97\u9593\u51fa\u5eab\u51e6\u7406\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        } else if ("Q0".equals(this.kindCd)) {
            this.posMain.getStatusBar().setText("\u5e97\u9593\u5165\u5eab\u51e6\u7406\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        }
        logger.info((Object)"\u51fa\u5165\u5eab:END");
        return true;
    }

    public boolean enterDialogMoveCancel(DialogAbstract dialog) {
        logger.info((Object)"\u51fa\u5eab\u4e0d\u53ef:START");
        if (this.kindCd == null) {
            logger.info((Object)"\u51fa\u5eab\u4e0d\u53ef:END");
            return false;
        }
        this.kindCd = "60";
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD(this.kindCd));
        }
        catch (AbsentMstException e) {
            logger.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd(this.kindCd);
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setDetailsCount(this.itemList.getBodyList().size());
        journalHead.setTotalItemQuantity(0);
        journalHead.setTotalAmount(BigDecimal.ZERO.longValue());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        List<JournalDetail> journalDetailList = this.getJournalDetailList("");
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead, journalDetailList);
        this.displayMove = new DisplayMove();
        this.displayMove.setJournalHead(journalHead);
        this.displayMove.executePrint(this.posMain);
        this.receiptMove = new ReceiptMove(this.kindCd, "", null, false);
        this.receiptMove.setJournalHead(journalHead);
        this.receiptMove.setJournalDetail(journalDetailList);
        this.receiptMove.executePrint(this.posMain, slipNo);
        this.posMain.updateLabelSlipNo();
        if (!this.itemList.getFinished()) {
            this.itemList.finished();
        }
        this.posMain.getStatusBar().setText("\u51fa\u5eab\u4e0d\u53ef\u51e6\u7406\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        logger.info((Object)"\u51fa\u5eab\u4e0d\u53ef:END");
        return true;
    }

    private List<JournalDetail> getJournalDetailList(String storeCd) {
        ArrayList<JournalDetail> journalDetailList = new ArrayList<JournalDetail>();
        List<ItemMst> list = this.itemList.getBodyList();
        int i = 0;
        while (i < list.size()) {
            ItemMst itemMst = list.get(i);
            JournalDetail journalDetail = new JournalDetail();
            journalDetail.setItemCd(itemMst.getComp_id().getItemCd());
            journalDetail.setSuppCd(itemMst.getComp_id().getSuppCd());
            journalDetail.setMakerCd(itemMst.getMakerCd());
            journalDetail.setItemName(itemMst.getItemName());
            journalDetail.setItemDetail1(itemMst.getItemDetail1());
            journalDetail.setItemDetail2(itemMst.getItemDetail2());
            journalDetail.setLabelCd(itemMst.getLabelCd());
            journalDetail.setClassCd(itemMst.getClassCd());
            journalDetail.setGenreCd(itemMst.getGenreCd());
            journalDetail.setOnsaleDate(itemMst.getOnsaleDate());
            journalDetail.setItemNum(itemMst.getItemNum());
            journalDetail.setPrice(itemMst.getPrice());
            journalDetail.setPriceTaxKind(itemMst.getPriceTaxKind());
            journalDetail.setCost(itemMst.getCost());
            journalDetail.setCostTaxKind(itemMst.getCostTaxKind());
            String rankCd = null;
            try {
                rankCd = MstManager.getInstance().findRankCdByRankName(journalDetail.getClassCd(), this.itemList.getTableItemList().getItem(i).getText(12));
            }
            catch (AbsentMstException absentMstException) {
                rankCd = this.itemList.getTableItemList().getItem(i).getText(12);
            }
            journalDetail.setRankCd(rankCd);
            journalDetail.setBarcode(itemMst.getBarcode());
            journalDetail.setOfficialBarcode(itemMst.getOfficialBarcode());
            journalDetail.setStockKind(itemMst.getStockKind());
            if (this.kindCd == "60") {
                journalDetail.setItemQuantity(0);
                journalDetail.setAmount(BigDecimal.ZERO.longValue());
                journalDetail.setCostAmount(BigDecimal.ZERO.longValue());
            } else {
                journalDetail.setItemQuantity(Integer.valueOf(this.itemList.getTableItemList().getItem(i).getText(10)));
                journalDetail.setAmount(journalDetail.getCost() * (long)journalDetail.getItemQuantity().intValue());
                journalDetail.setCostAmount(journalDetail.getAmount());
                this.totalAmount = this.totalAmount.add(BigDecimal.valueOf(journalDetail.getCostAmount()));
            }
            if (this.kindCd == "S0") {
                journalDetail.setFromStoreCd(this.getStoreCd());
                journalDetail.setToStoreCd(storeCd);
            } else if (this.kindCd == "Q0") {
                journalDetail.setFromStoreCd(storeCd);
                journalDetail.setToStoreCd(this.getStoreCd());
            }
            journalDetail.setMakerPrice(itemMst.getMakerPrice());
            journalDetail.setUsedFlag(itemMst.getUsedFlag());
            journalDetail.setSetFlag(itemMst.getSetFlag());
            journalDetail.setEndFlag(itemMst.getEndFlag());
            journalDetailList.add(journalDetail);
            ++i;
        }
        return journalDetailList;
    }

    private String getStoreCd() {
        String storeCd = "";
        try {
            storeCd = MstManager.getInstance().findStoreMstByCD().getStoreCd();
        }
        catch (AbsentMstException absentMstException) {}
        return storeCd;
    }
}

