/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosCommon;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosFileUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.ItemMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.JournalDetailDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ClassMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMstPK;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.RankMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAssessment;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogLineCopy;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogRecycle;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogRecycleUnknown;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogRecycleUp;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import jp.ne.k_tech.kposrcp.kpos.list.ItemListRecycle;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayRecycle;
import jp.ne.k_tech.kposrcp.kpos.print.label.LabelAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.label.LabelRecycle;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptRecycle;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.TableItem;

public class PosRecycle
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosRecycle.class);
    private ReceiptAbstract receiptRecycle = null;
    private LabelAbstract labelRecycle = null;
    private DisplayAbstract displayRecycle = null;
    private ItemList itemList = null;

    public PosRecycle(PosMain posMain) {
        super(posMain);
        this.itemList = posMain.getPosTabFolder().getPosAbstract()[posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList();
    }

    public boolean enterDialogRecycle(DialogAbstract dialog) {
        log.info((Object)"\u8cb7\u53d6:START");
        DialogRecycle dialogRecycle = (DialogRecycle)dialog;
        log.debug((Object)("\u5546\u54c1\u70b9\u6570:" + dialogRecycle.getRecycleItemQuantityTotal()));
        log.debug((Object)("\u8cb7\u53d6\u5408\u8a08:" + dialogRecycle.getRecycleItemAmount()));
        log.debug((Object)("\u30e9\u30d9\u30eb\u5370\u5237:" + dialogRecycle.getLabelPrint()));
        if (!dialogRecycle.validate()) {
            log.info((Object)"\u8cb7\u53d6:END");
            return false;
        }
        if (PosNumberUtils.commaParse(dialogRecycle.getRecycleItemQuantityTotal()) <= 0L) {
            log.info((Object)"\u8cb7\u53d6:END");
            return true;
        }
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD("B0"));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd("B0");
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setDetailsCount(this.itemList.getBodyList().size());
        journalHead.setTotalItemQuantity(this.itemList.getBodyList().size());
        journalHead.setTotalAmount(PosNumberUtils.commaParse(dialogRecycle.getRecycleItemAmount()));
        journalHead.setCustomerCd(dialogRecycle.getCustomerNo());
        journalHead.setCustomerSex(dialogRecycle.getCustomerSex());
        journalHead.setCustomerAge(dialogRecycle.getCustomerAge());
        journalHead.setRepeater(dialogRecycle.getCheckRepeater());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        List<JournalDetail> journalDetailList = this.getJournalDetailList();
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead, journalDetailList);
        this.displayRecycle = new DisplayRecycle("B0");
        this.displayRecycle.setJournalHead(journalHead);
        this.displayRecycle.executePrint(this.posMain);
        this.receiptRecycle = new ReceiptRecycle(true);
        ((ReceiptRecycle)this.receiptRecycle).setRecycleUpAmountList(((ItemListRecycle)this.itemList).getRecycleUpAmountList());
        this.receiptRecycle.setJournalHead(journalHead);
        this.receiptRecycle.setJournalDetail(journalDetailList);
        this.receiptRecycle.executePrint(this.posMain, slipNo);
        this.receiptRecycle = new ReceiptRecycle("");
        ((ReceiptRecycle)this.receiptRecycle).setRecycleUpAmountList(((ItemListRecycle)this.itemList).getRecycleUpAmountList());
        this.receiptRecycle.setJournalHead(journalHead);
        this.receiptRecycle.setJournalDetail(journalDetailList);
        this.receiptRecycle.executePrint(this.posMain, SlipNoManager.getInstance().getNextSlipNo());
        ArrayList<String> lineList = new ArrayList<String>();
        String line = String.format("%d,%d", journalHead.getTotalAmount(), journalHead.getTotalItemQuantity());
        lineList.add(line);
        try {
            PosFileUtils.appendLineToFile("recycle_summary.csv", lineList);
        }
        catch (IOException e) {
            log.error((Object)("CSV\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(\u8cb7\u53d6\u5408\u8a08,\u4ef6\u6570) = (" + line + ")"), (Throwable)e);
        }
        if (dialogRecycle.getLabelPrint()) {
            this.labelRecycle = new LabelRecycle(journalDetailList);
            this.labelRecycle.executePrint(this.posMain);
        }
        OposController.getInstance().getCashDrawer().open();
        this.posMain.updateLabelSlipNo();
        if (!this.itemList.getFinished()) {
            this.itemList.finished();
        }
        log.info((Object)"\u8cb7\u53d6:END");
        return true;
    }

    public boolean enterDialogAssessment(DialogAbstract dialog) {
        log.info((Object)"\u8cb7\u53d6\u67fb\u5b9a:START");
        DialogAssessment dialogAssessment = (DialogAssessment)dialog;
        log.debug((Object)("\u5546\u54c1\u70b9\u6570:" + dialogAssessment.getRecycleItemQuantityTotal()));
        log.debug((Object)("\u8cb7\u53d6\u5408\u8a08:" + dialogAssessment.getRecycleItemAmount()));
        if (PosNumberUtils.commaParse(dialogAssessment.getRecycleItemQuantityTotal()) <= 0L) {
            log.info((Object)"\u8cb7\u53d6\u67fb\u5b9a:END");
            return true;
        }
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD("C0"));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd("C0");
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setDetailsCount(this.itemList.getBodyList().size());
        journalHead.setTotalItemQuantity(this.itemList.getBodyList().size());
        journalHead.setTotalAmount(this.posMain.getPosTabFolder().calcRecycleItemAmount());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        List<JournalDetail> journalDetailList = this.getJournalDetailList();
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead, journalDetailList);
        this.displayRecycle = new DisplayRecycle("C0");
        this.displayRecycle.setJournalHead(journalHead);
        this.displayRecycle.executePrint(this.posMain);
        this.receiptRecycle = new ReceiptRecycle(false);
        ((ReceiptRecycle)this.receiptRecycle).setRecycleUpAmountList(((ItemListRecycle)this.itemList).getRecycleUpAmountList());
        this.receiptRecycle.setJournalHead(journalHead);
        this.receiptRecycle.setJournalDetail(journalDetailList);
        this.receiptRecycle.executePrint(this.posMain, slipNo);
        this.posMain.updateLabelSlipNo();
        this.itemList.getFinished();
        this.posMain.getStatusBar().setText("\u67fb\u5b9a\u984d\u78ba\u8a8d\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        log.info((Object)"\u8cb7\u53d6\u67fb\u5b9a:END");
        return true;
    }

    public boolean enterDialogLineCopy(DialogAbstract dialog) {
        log.info((Object)"\u884c\u30b3\u30d4\u30fc:START");
        DialogLineCopy dialogLineCopy = (DialogLineCopy)dialog;
        log.debug((Object)("\u30b3\u30d4\u30fc\u6570:" + dialogLineCopy.getCopyCount()));
        if (!dialogLineCopy.validate()) {
            log.info((Object)"\u884c\u30b3\u30d4\u30fc:END");
            return false;
        }
        int selectionIndex = this.itemList.getTableItemList().getSelectionIndex();
        try {
            int i = 0;
            while (i < NumberUtils.toInt((String)dialogLineCopy.getCopyCount())) {
                this.itemList.copyTableItem(selectionIndex);
                ++i;
            }
            this.posMain.getPosTabFolder().updateTableFooter();
            this.posMain.getStatusBar().setText("\u884c\u30b3\u30d4\u30fc\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        }
        catch (AbsentMstException e) {
            this.posMain.getStatusBar().setText(e.getMessage());
        }
        log.info((Object)"\u884c\u30b3\u30d4\u30fc:END");
        return true;
    }

    public boolean enterDialogRecycleUp(DialogAbstract dialog) {
        log.info((Object)"\u8cb7\u53d6UP:START");
        DialogRecycleUp dialogRecycleUp = (DialogRecycleUp)dialog;
        log.debug((Object)("\u8cb7\u53d6UP\u7387:" + dialogRecycleUp.getUpRate()));
        if (!dialogRecycleUp.validate()) {
            log.info((Object)"\u8cb7\u53d6UP\u7387\uff08validate\uff09:END");
            return false;
        }
        int upRate = NumberUtils.toInt((String)dialogRecycleUp.getUpRate());
        int count = this.itemList.getTableItemList().getItemCount();
        int i = 0;
        while (i < count) {
            TableItem tableItem = this.itemList.getTableItemList().getItem(i);
            tableItem.setText(11, String.valueOf(PosNumberUtils.multiplyPercent(NumberUtils.toLong((String)tableItem.getText(11)), upRate + 100, Activator.getDefault().getPreferenceStore().getInt("ROUNDING_MODE_RECYCLE"))));
            ++i;
        }
        this.posMain.getPosTabFolder().updateTableFooter();
        this.posMain.getStatusBar().setText(String.format("\u8cb7\u53d6UP\u7387[%d%%]\u9069\u7528\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f", upRate));
        log.info((Object)"\u8cb7\u53d6UP:END");
        return true;
    }

    public boolean enterDialogUnknown(DialogAbstract dialog) {
        log.info((Object)"\u672a\u77e5\u5546\u54c1\u8a2d\u5b9a:START");
        DialogRecycleUnknown dialogRecycleUnknown = (DialogRecycleUnknown)dialog;
        ClassMst classMst = dialogRecycleUnknown.getClassSelection();
        RankMst rankMst = dialogRecycleUnknown.getRankSelection();
        dialogRecycleUnknown.setOfficialBarcodeConfirm(dialogRecycleUnknown.getOfficialBarcodeConfirm().trim());
        if (!dialogRecycleUnknown.validate()) {
            log.info((Object)"\u672a\u77e5\u5546\u54c1\u8a2d\u5b9a:END");
            return false;
        }
        log.debug((Object)("\u5206\u985e:" + classMst.getClassName()));
        log.debug((Object)("\u30e9\u30f3\u30af:" + rankMst.getRankName()));
        log.debug((Object)("\u6d41\u901a\u30d0\u30fc\u30b3\u30fc\u30c9:" + dialogRecycleUnknown.getOfficialBarcode()));
        try {
            String offcialBarcode = dialogRecycleUnknown.getOfficialBarcode();
            Calendar onsaleDate = Calendar.getInstance();
            int year = onsaleDate.get(1);
            int month = onsaleDate.get(2);
            onsaleDate.clear();
            onsaleDate.set(year, month, 1);
            onsaleDate.add(5, dialogRecycleUnknown.getRankSelection().getStartDays() * -1);
            ItemMstPK itemMstPK = new ItemMstPK(offcialBarcode, "0998", Activator.getDefault().getPreferenceStore().getString("STORE_CD"));
            ItemMst itemMst = new ItemMst(itemMstPK, offcialBarcode, "\u30de\u30b9\u30bf\u30fc\u7121\u3057\u5546\u54c1", "\u30de\u30b9\u30bf\u30fc\u30ca\u30b7\u30b7\u30e7\u30a6\u30d2\u30f3", "--", "900001", classMst.getClassCd(), "9001", onsaleDate.getTime(), null, 0L, "0", 0L, 0L, "0", offcialBarcode, offcialBarcode, "1", "0", "1", "0", rankMst.getComp_id().getRankCd(), null, null, null, null, null, null, null, null, null, null);
            this.itemList.addRow(itemMst);
            this.posMain.getStatusBar().setText("\u30de\u30b9\u30bf\u30fc\u7121\u3057\u5546\u54c1\u8a2d\u5b9a\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u767a\u751f", (Throwable)e);
            this.posMain.getStatusBar().setText("\u30de\u30b9\u30bf\u30fc\u7121\u3057\u5546\u54c1\u306e\u4e00\u89a7\u8ffd\u52a0\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
        log.info((Object)"\u672a\u77e5\u5546\u54c1\u8a2d\u5b9a:END");
        return true;
    }

    private List<JournalDetail> getJournalDetailList() {
        ArrayList<JournalDetail> journalDetailList = new ArrayList<JournalDetail>();
        List<ItemMst> list = this.itemList.getBodyList();
        String barcodeTop = PosCommon.getBarcodeTop();
        long barcodeNo = this.getStartBarcodeNo(barcodeTop);
        int i = 0;
        while (i < list.size()) {
            TableItem tableItem = this.itemList.getTableItemList().getItem(i);
            String barcode = barcodeTop.concat(PosNumberUtils.format_00000000(barcodeNo++));
            barcode = barcode.concat(PosCommon.getCheckdigit(barcode));
            JournalDetail journalDetail = new JournalDetail();
            String itemCd = "USED_<%1><%2>".replaceAll("<%1>", barcode);
            itemCd = itemCd.replaceAll("<%2>", tableItem.getText(11));
            journalDetail.setItemCd(itemCd);
            journalDetail.setSuppCd("0998");
            ItemMst itemMst = list.get(i);
            journalDetail.setMakerCd(itemMst.getMakerCd());
            journalDetail.setItemName(tableItem.getText(4));
            journalDetail.setItemDetail1(itemMst.getItemDetail1());
            journalDetail.setItemDetail2(itemMst.getItemDetail2());
            journalDetail.setLabelCd(itemMst.getLabelCd());
            journalDetail.setClassCd(this.convertClassCd(itemMst.getClassCd()));
            journalDetail.setGenreCd(itemMst.getGenreCd());
            journalDetail.setOnsaleDate(itemMst.getOnsaleDate());
            journalDetail.setItemNum(itemMst.getItemNum());
            journalDetail.setPrice(Long.valueOf(tableItem.getText(10)));
            journalDetail.setPriceTaxKind("0");
            journalDetail.setCost(Long.valueOf(tableItem.getText(11)));
            journalDetail.setCostTaxKind("0");
            String rankCd = null;
            try {
                rankCd = MstManager.getInstance().findRankCdByRankName(journalDetail.getClassCd(), tableItem.getText(12));
            }
            catch (AbsentMstException absentMstException) {
                rankCd = tableItem.getText(12);
            }
            journalDetail.setRankCd(rankCd);
            journalDetail.setBarcode(barcode);
            journalDetail.setStockKind("1");
            journalDetail.setOfficialBarcode(itemMst.getOfficialBarcode());
            journalDetail.setItemQuantity(1);
            journalDetail.setAmount(Long.valueOf(tableItem.getText(11)));
            journalDetail.setCostAmount(Long.valueOf(tableItem.getText(11)));
            String initRankCd = null;
            long initPrice = 0L;
            long initCost = 0L;
            try {
                RankMst rankMst = MstManager.getInstance().findRank(itemMst.getClassCd(), itemMst.getOnsaleDate(), itemMst.getRankCd());
                initRankCd = rankMst.getComp_id().getRankCd();
                if ("1".equals(itemMst.getSetFlag())) {
                    initPrice = journalDetail.getPrice();
                    initCost = journalDetail.getCost();
                } else {
                    initPrice = rankMst.getRecycleSalePrice();
                    initCost = rankMst.getRecycleBuyPrice();
                }
            }
            catch (AbsentMstException absentMstException) {
                initRankCd = journalDetail.getRankCd();
                initPrice = journalDetail.getPrice();
                initCost = journalDetail.getCost();
            }
            journalDetail.setRecycleInitCost(initCost);
            journalDetail.setRecycleInitPrice(initPrice);
            journalDetail.setRecycleInitRankCd(initRankCd);
            journalDetail.setMakerPrice(itemMst.getMakerPrice());
            journalDetail.setUsedFlag("1");
            journalDetail.setSetFlag(itemMst.getSetFlag());
            journalDetail.setEndFlag(itemMst.getEndFlag());
            journalDetailList.add(journalDetail);
            ++i;
        }
        return journalDetailList;
    }

    private String convertClassCd(String classCd) {
        return classCd;
    }

    private long getStartBarcodeNo(String barcodeTop) {
        long journalMax;
        long result = 0L;
        ItemMstDAO itemMstDAO = new ItemMstDAO();
        JournalDetailDAO journalDetailDAO = new JournalDetailDAO();
        long itemMax = itemMstDAO.getMaxBarcodeNo(barcodeTop);
        if (itemMax > (journalMax = journalDetailDAO.getMaxBarcodeNo(barcodeTop))) {
            result = itemMax;
        } else if (itemMax < journalMax) {
            result = journalMax;
        } else if (itemMax > 0L) {
            result = itemMax;
        }
        return result + 1L;
    }
}

