/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.util.Arrays;
import java.util.List;
import jp.ne.k_tech.kposrcp.Constants;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosFileUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogRecycleSummary;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptRecycleSummary;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.MessageBox;

public class PosRecycleSummary
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosRecycleSummary.class);
    private String posLinkBarcode12 = null;
    private String posLinkBarcode13 = null;

    public PosRecycleSummary(PosMain posMain) {
        super(posMain);
    }

    public void enterDialogRecycleSummary(DialogAbstract dialog) {
        log.info((Object)"\u8cb7\u53d6\u96c6\u8a08:START");
        List<String> summaryDataList = PosFileUtils.readTextFile2List("recycle_summary.csv");
        if (summaryDataList.isEmpty()) {
            log.warn((Object)"CSV\u306b\u8cb7\u53d6\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
            log.warn((Object)"\u8cb7\u53d6\u96c6\u8a08\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3059");
            log.info((Object)"\u8cb7\u53d6\u96c6\u8a08:END");
            this.posMain.getStatusBar().setText("\u8cb7\u53d6\u30c7\u30fc\u30bf\u306b\u554f\u984c\u304c\u3042\u308b\u305f\u3081\u3001\u51e6\u7406\u306f\u4e2d\u65ad\u3055\u308c\u307e\u3057\u305f");
            return;
        }
        long amount = 0L;
        int quantity = 0;
        for (String line : summaryDataList) {
            if (line.endsWith(",")) {
                log.warn((Object)"\u8cb7\u53d6\u96c6\u8a08CSV\u30d5\u30a1\u30a4\u30eb\u3067\u5f62\u5f0f\u304c\u4e0d\u6b63\u306a\u884c\u304c\u3042\u308a\u307e\u3057\u305f\u3002\u3053\u306e\u884c\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\u3002");
                continue;
            }
            Object[] splitLine = line.split(",");
            log.info((Object)("\u884c\u30c7\u30fc\u30bf: " + Arrays.toString(splitLine)));
            if (splitLine.length != 2) {
                log.warn((Object)"\u8cb7\u53d6\u96c6\u8a08CSV\u30d5\u30a1\u30a4\u30eb\u3067\u5f62\u5f0f\u304c\u4e0d\u6b63\u306a\u884c\u304c\u3042\u308a\u307e\u3057\u305f\u3002\u3053\u306e\u884c\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\u3002");
                continue;
            }
            long a = NumberUtils.toLong((String)splitLine[0], (long)0L);
            if (a == 0L) {
                log.warn((Object)"\u8cb7\u53d6\u91d1\u984d\u5408\u8a08\u304c\u4e0d\u6b63\u3067\u3059\u3002\u3053\u306e\u884c\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\u3002");
                continue;
            }
            int q = NumberUtils.toInt((String)splitLine[1], (int)0);
            if (q == 0) {
                log.warn((Object)"\u8cb7\u53d6\u4ef6\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002\u3053\u306e\u884c\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\u3002");
                continue;
            }
            log.debug((Object)String.format("a=%d, q=%d", a, q));
            amount += a;
            quantity += q;
        }
        log.info((Object)String.format("\u8cb7\u53d6\u96c6\u8a08\u7d50\u679c: \u8cb7\u53d6\u91d1\u984d\u5408\u8a08=%d, \u8cb7\u53d6\u4ef6\u6570=%d", amount, quantity));
        if (amount == 0L) {
            log.warn((Object)"\u96c6\u8a08\u7d50\u679c\u304c0\u5186\u306b\u306a\u308a\u307e\u3057\u305f");
            log.warn((Object)"\u8cb7\u53d6\u96c6\u8a08\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3059");
            log.info((Object)"\u8cb7\u53d6\u96c6\u8a08:END");
            this.posMain.getStatusBar().setText("\u96c6\u8a08\u7d50\u679c\u304c0\u5186\u306b\u306a\u308a\u307e\u3057\u305f\u3002\u96c6\u8a08\u51e6\u7406\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD("K0"));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd("B0");
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setTotalItemQuantity(quantity);
        journalHead.setTotalAmount(amount);
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        boolean retry = false;
        boolean success = true;
        DialogRecycleSummary dialogRecycleSummary = (DialogRecycleSummary)dialog;
        do {
            ProgressMonitorDialog progressMonitorDialog = null;
            try {
                progressMonitorDialog = new ProgressMonitorDialog(dialogRecycleSummary.getShell());
            }
            finally {
                if (progressMonitorDialog != null) {
                    progressMonitorDialog.close();
                }
            }
            retry = StringUtils.isEmpty((String)this.posLinkBarcode13);
            if (!retry) continue;
            StringBuffer message = new StringBuffer("POS\u9023\u643a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            message.append(Constants.EOL);
            message.append(Constants.EOL);
            message.append("\u518d\u8a66\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            message.append(Constants.EOL);
            message.append(Constants.EOL);
            message.append("\u4f55\u5ea6\u518d\u8a66\u884c\u3057\u3066\u3082\u3053\u306e\u753b\u9762\u304c\u8868\u793a\u3055\u308c\u308b\u5834\u5408\u306f\u3001\u8cb7\u53d6\u30ec\u30b7\u30fc\u30c8\u756a\u53f7\u30fb\u5546\u54c1\u70b9\u6570\u30fb\u91d1\u984d\u3092\u63a7\u3048\u3001\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            message.append(Constants.EOL);
            message.append(Constants.EOL);
            MessageBox messageBox = new MessageBox(dialogRecycleSummary.getShell(), 1288);
            messageBox.setMessage(message.toString());
            boolean bl = retry = 1024 == messageBox.open();
            if (retry) continue;
            log.warn((Object)"POS\u9023\u643a\u306b\u5931\u6557\u3057\uff0c\u518d\u8a66\u884c\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f\uff0e");
            success = false;
        } while (retry);
        if (success) {
            DbmSlip dbmSlip = new DbmSlip();
            dbmSlip.regist(slip, journalHead);
            ReceiptRecycleSummary receiptRecycleSummary = new ReceiptRecycleSummary(this.posLinkBarcode13);
            receiptRecycleSummary.setJournalHead(journalHead);
            receiptRecycleSummary.executePrint(this.posMain, SlipNoManager.getInstance().getNextSlipNo());
            PosFileUtils.removeFiles("recycle_summary.csv");
            this.posMain.getStatusBar().setText("\u30ea\u30b5\u30a4\u30af\u30eb\u8cb7\u53d6\u753b\u9762\u306b\u79fb\u308a\u3001\u8cb7\u53d6\u96c6\u8a08\u306e\u30d0\u30fc\u30b3\u30fc\u30c9\u3092\u30b9\u30ad\u30e3\u30f3\u3057\u3066\u304f\u3060\u3055\u3044");
            this.posMain.updateLabelSlipNo();
        } else {
            this.posMain.getStatusBar().setText("POS\u9023\u643a\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        log.info((Object)"\u8cb7\u53d6\u96c6\u8a08:END");
    }
}

