/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.PosTabFolder;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCashier;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogDiscount;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplaySales;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptSales;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PosSales
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosSales.class);
    private ReceiptAbstract receiptSales = null;
    private DisplayAbstract displaySales = null;

    public PosSales(PosMain posMain) {
        super(posMain);
    }

    public boolean enterDialogCashier(DialogAbstract dialog) {
        return this.doDialogCashier(dialog, "U0");
    }

    private boolean doDialogCashier(DialogAbstract dialog, String kind) {
        log.info((Object)"\u8ca9\u58f2\u4f1a\u8a08:START");
        DialogCashier dialogCashier = (DialogCashier)dialog;
        if ("U0".equals(kind) && !dialogCashier.validate()) {
            log.info((Object)"\u8ca9\u58f2\u4f1a\u8a08:END");
            return false;
        }
        PosTabFolder posTabFolder = this.posMain.getPosTabFolder();
        MstManager mstManager = MstManager.getInstance();
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD(kind));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd(kind);
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        JournalHead journalHead = new JournalHead();
        journalHead.setTotalItemQuantity(BigDecimal.valueOf(posTabFolder.calcQuantityTotal()).intValue());
        journalHead.setTotalSaleAmount(posTabFolder.calcAmount());
        journalHead.setTotalSaleTax(posTabFolder.calcTax());
        journalHead.setTotalAmount(dialogCashier.getSalesItemAmountWithTax());
        journalHead.setSaleReceiveAmount(dialogCashier.getSalesMoney());
        journalHead.setSaleBackAmount(dialogCashier.getSalesChange());
        journalHead.setCreditKind(dialogCashier.getSalesCredit());
        journalHead.setWebSaleKind("0");
        journalHead.setUsePoint(dialogCashier.getUsePoint());
        journalHead.setPointAmount(0L);
        journalHead.setSaleKind(dialogCashier.getSaleKind());
        journalHead.setTotalDiscountAmount(dialogCashier.getDiscountAmount());
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd());
        journalHead.setCustomerCd(dialogCashier.getCustomerCd());
        journalHead.setCustomerSex(dialogCashier.getCustomerSex());
        journalHead.setCustomerAge(dialogCashier.getCustomerAge());
        journalHead.setRepeater(dialogCashier.getRepeater());
        ArrayList<JournalDetail> journalDetailList = new ArrayList<JournalDetail>();
        List<ItemMst> list = posTabFolder.getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getBodyList();
        Table table = posTabFolder.getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getTableItemList();
        double discountRate = this.getDiscountRate(dialogCashier.getSalesItemAmountWithTax(), dialogCashier.getDiscountAmount());
        long sumDiscountAmount = 0L;
        int i = 0;
        while (i < list.size()) {
            JournalDetail journalDetail = new JournalDetail();
            ItemMst itemMst = list.get(i);
            TableItem tableItem = table.getItem(i);
            journalDetail.setItemCd(itemMst.getComp_id().getItemCd());
            journalDetail.setSuppCd(itemMst.getComp_id().getSuppCd());
            journalDetail.setMakerCd(itemMst.getMakerCd());
            journalDetail.setItemName(itemMst.getItemName());
            journalDetail.setItemDetail1(itemMst.getItemDetail1());
            journalDetail.setItemDetail2(itemMst.getItemDetail2());
            journalDetail.setLabelCd(itemMst.getLabelCd());
            journalDetail.setClassCd(itemMst.getClassCd());
            journalDetail.setGenreCd(itemMst.getGenreCd());
            journalDetail.setOnsaleDate(itemMst.getOnsaleDate());
            journalDetail.setItemNum(itemMst.getItemNum());
            journalDetail.setPrice(Long.valueOf(tableItem.getText(11)));
            journalDetail.setPriceTaxKind(itemMst.getPriceTaxKind());
            journalDetail.setCost(itemMst.getCost());
            journalDetail.setCostTaxKind(itemMst.getCostTaxKind());
            String rankCd = null;
            try {
                rankCd = mstManager.findRankCdByRankName(itemMst.getClassCd(), tableItem.getText(13));
            }
            catch (AbsentMstException absentMstException) {
                rankCd = tableItem.getText(13);
            }
            journalDetail.setRankCd(rankCd);
            journalDetail.setBarcode(itemMst.getBarcode());
            journalDetail.setStockKind(itemMst.getStockKind());
            journalDetail.setItemQuantity(Integer.valueOf(tableItem.getText(10)));
            journalDetail.setSaleAmount(journalDetail.getPrice() * (long)journalDetail.getItemQuantity().intValue());
            journalDetail.setTax(PosNumberUtils.tax(journalDetail.getPrice(), itemMst.getPriceTaxKind()) * (long)journalDetail.getItemQuantity().intValue());
            journalDetail.setAmount(PosNumberUtils.amountWithTax(journalDetail.getPrice(), itemMst.getPriceTaxKind()) * (long)journalDetail.getItemQuantity().intValue());
            journalDetail.setSaleKind(dialogCashier.getSaleKind());
            long discountAmount = this.getDiscountAmount(journalDetail.getAmount() + NumberUtils.toLong((String)tableItem.getText(12)), discountRate);
            journalDetail.setDiscountAmount(NumberUtils.toLong((String)tableItem.getText(12)) * -1L + discountAmount);
            sumDiscountAmount += discountAmount;
            long cost = itemMst.getCost();
            journalDetail.setCostAmount(cost * (long)journalDetail.getItemQuantity().intValue());
            journalDetailList.add(journalDetail);
            ++i;
        }
        long mod = dialogCashier.getDiscountAmount() - sumDiscountAmount;
        ((JournalDetail)journalDetailList.get(0)).setDiscountAmount(((JournalDetail)journalDetailList.get(0)).getDiscountAmount() + mod);
        DbmSlip dbmSlip = new DbmSlip();
        String slipNo = dbmSlip.regist(slip, journalHead, journalDetailList);
        if ("U0".equals(kind)) {
            this.displaySales = new DisplaySales();
            this.displaySales.setJournalHead(journalHead);
            this.displaySales.executePrint(this.posMain);
        }
        if ("U0".equals(kind)) {
            this.receiptSales = new ReceiptSales();
            this.receiptSales.setJournalHead(journalHead);
            this.receiptSales.setJournalDetail(journalDetailList);
            this.receiptSales.executePrint(this.posMain, slipNo);
        }
        if ("U0".equals(kind)) {
            OposController.getInstance().getCashDrawer().open();
        }
        if ("U0".equals(kind)) {
            posTabFolder.setSalesMoney(dialogCashier.getSalesMoney());
            posTabFolder.setSalesChange(dialogCashier.getSalesChange());
            posTabFolder.setAmountWithTax(dialogCashier.getSalesItemAmountWithTax());
            posTabFolder.getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().finished();
        }
        if ("U0".equals(kind)) {
            this.posMain.getStatusBar().setText("\u8ca9\u58f2\u4f1a\u8a08\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        log.info((Object)"\u8ca9\u58f2\u4f1a\u8a08:END");
        return true;
    }

    public boolean enterDialogDiscount(DialogAbstract dialog) {
        log.info((Object)"\u8ca9\u58f2\u5024\u5f15:START");
        DialogDiscount dialogDiscount = (DialogDiscount)dialog;
        if (!dialogDiscount.validate()) {
            log.info((Object)"\u8ca9\u58f2\u5024\u5f15:END");
            return false;
        }
        PosTabFolder posTabFolder = this.posMain.getPosTabFolder();
        TableItem tableItem = posTabFolder.getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getTableItemSelected();
        tableItem.setText(12, String.valueOf(dialogDiscount.getDiscountAmount() * -1L));
        posTabFolder.updateTableFooter();
        this.posMain.getStatusBar().setText("\u8ca9\u58f2\u5024\u5f15\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        log.info((Object)"\u8ca9\u58f2\u5024\u5f15:END");
        return true;
    }

    private double getDiscountRate(long totalAmount, long totalDiscountAmount) {
        double rate = 0.0;
        if (totalAmount != 0L) {
            rate = Long.valueOf(totalDiscountAmount).doubleValue() / Long.valueOf(totalDiscountAmount + totalAmount).doubleValue();
        }
        return rate;
    }

    private long getDiscountAmount(long amount, double discountRate) {
        return PosNumberUtils.floor((double)amount * discountRate);
    }
}

