/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print;

import jp.ne.k_tech.kposrcp.kpos.print.label.Label;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class Print
implements Runnable {
    private static Log log = LogFactory.getLog(Print.class);
    private static final String JOB_NAME = "Printing Label";
    private PrinterData printerData = null;
    private GC gc = null;
    private Thread waittingThread = null;
    private String code = null;
    private String itemCode = null;
    private String itemName = null;
    private Integer itemNum = null;
    private String gnereName = null;
    private String lastDate = null;
    private int price = 0;
    private String info = null;

    public void setGc(GC gc) {
        this.gc = gc;
    }

    public PrinterData getPrinter(String printerName) {
        PrinterData[] data = this.getPrinterList();
        int i = 0;
        while (i < data.length) {
            log.info((Object)("Printer:" + data[i].name));
            if (printerName.equals(data[i].name)) {
                return data[i];
            }
            ++i;
        }
        return null;
    }

    private PrinterData[] getPrinterList() {
        PrinterData[] data = Printer.getPrinterList();
        return data;
    }

    public final void print(PrinterData data) {
        if (data == null) {
            log.warn((Object)"Warning: No default printer.");
            return;
        }
        log.info((Object)("Print Start:" + data.name));
        Printer printer = new Printer(data);
        if (printer.startJob(JOB_NAME)) {
            if (this.gc == null) {
                this.gc = new GC((Drawable)printer);
            }
            Label label = new Label(this.gc);
            if (printer.startPage()) {
                log.debug((Object)"Print Image Create");
                label.create(this.code, this.itemCode, this.itemName, this.itemNum, this.gnereName, this.lastDate, this.price, this.info);
                printer.endPage();
                log.debug((Object)"Print End");
            }
            label = null;
            this.gc.dispose();
            this.gc = null;
            printer.endJob();
            log.debug((Object)"Print OK");
        }
        printer.dispose();
        printer = null;
    }

    @Override
    public void run() {
        try {
            if (this.waittingThread != null) {
                this.waittingThread.join();
            }
            this.print(this.printerData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWaittingThread(Thread thread) {
        this.waittingThread = thread;
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(Integer itemNnum) {
        this.itemNum = itemNnum;
    }

    public String getGnereName() {
        return this.gnereName;
    }

    public void setGnereName(String genreName) {
        this.gnereName = genreName;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public String getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(String suppName) {
        this.lastDate = suppName;
    }
}

