/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.label;

import java.text.DecimalFormat;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.print.label.barcode.Barcode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;

public class Label {
    private GC gc = null;
    private int leftMargin = 0;
    private DecimalFormat df = new DecimalFormat("###,###,###,###,###");

    public Label(GC gc) {
        this.gc = gc;
        this.leftMargin = Activator.getDefault().getPreferenceStore().getInt("LABEL_PRINTER_LEFT_MARGIN") * 4;
        this.leftMargin += 6;
    }

    public void create(String code, String itemCode, String itemName, Integer itemNum, String genreName, String lastDate, int price, String info) {
        Font fontItemName = new Font(this.gc.getDevice(), "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 6, 1);
        Font fontPrice = new Font(this.gc.getDevice(), "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 14, 1);
        Font fontItemCode = new Font(this.gc.getDevice(), "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 5, 1);
        Font fontBarcodeNumber = new Font(this.gc.getDevice(), "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 5, 1);
        int offsetY = 3;
        int itemNamePlaceX = 4;
        int itemNamePlaceY = 0 + offsetY;
        int classNamePlaceX = 4;
        int classNamePlaceY = 20 + offsetY;
        int taxInfoPlaceX = 4;
        int taxInfoPlaceY = 40 + offsetY;
        int pricePlaceX = 114;
        int pricePlaceY = 20 + offsetY;
        int barcodePlaceX = 25;
        int barcodePlaceY = 60 + offsetY;
        int barcodeHeight = 138;
        int barcodeNumberPlaceX = 25;
        int barcodeNumberPlaceY = 138 + offsetY;
        int itemCodePlaceX = 25;
        int itemCodePlaceY = 155 + offsetY;
        this.gc.setFont(fontItemName);
        this.gc.drawString(String.valueOf(PosStringUtils.cut(itemName, 18)) + this.makeItemNum(itemNum), this.leftMargin + itemNamePlaceX, itemNamePlaceY);
        this.gc.drawString(PosStringUtils.cut(genreName, 12), this.leftMargin + classNamePlaceX, classNamePlaceY);
        this.gc.drawString("\u7a0e\u8fbc", this.leftMargin + taxInfoPlaceX, taxInfoPlaceY);
        this.gc.setFont(fontPrice);
        this.gc.drawString(this.makePrice(price), this.leftMargin + pricePlaceX, pricePlaceY);
        this.gc.setFont(fontBarcodeNumber);
        this.gc.drawString(String.valueOf(code) + " " + PosStringUtils.cut(lastDate, 10), this.leftMargin + barcodeNumberPlaceX, barcodeNumberPlaceY);
        this.gc.setFont(fontItemCode);
        this.gc.drawString(PosStringUtils.cut(itemCode, 24), this.leftMargin + itemCodePlaceX, itemCodePlaceY);
        Barcode barcode = new Barcode();
        barcode.leftMargin = this.leftMargin;
        barcode.barcodePlaceX = barcodePlaceX;
        barcode.barcodePlaceY = barcodePlaceY;
        barcode.barcodeHeight = barcodeHeight;
        barcode.printBarcode(this.gc, code);
        fontItemName.dispose();
        fontPrice.dispose();
        fontItemCode.dispose();
        fontBarcodeNumber.dispose();
        barcode = null;
    }

    private String makePrice(int price) {
        String result = "";
        if (price > 0 && String.valueOf(price).length() < 6) {
            result = "\\" + this.df.format(price);
            int j = result.length();
            while (j < 7) {
                result = " " + result;
                ++j;
            }
        } else {
            result = "";
        }
        return result;
    }

    private String makeItemNum(Integer itemNum) {
        if (itemNum == null) {
            return "";
        }
        return String.format("[%d]", itemNum >= 1000 ? itemNum % 1000 : itemNum);
    }
}

