/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.EmpMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Indicate;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.StoreMst;

public abstract class ReceiptAbstract {
    protected PosMain posMain = null;
    protected JournalHead journalHead = null;
    protected List<JournalDetail> journalDetail = null;
    protected List<Indicate> indicate = null;
    protected static final int line = 30;

    protected abstract void executeReceiptPrint(String var1);

    public void executePrint(PosMain posMain, String slipNo) {
        if (posMain == null) {
            return;
        }
        this.posMain = posMain;
        this.executeReceiptPrint(slipNo);
    }

    public void setJournalHead(JournalHead journalHead) {
        this.journalHead = journalHead;
    }

    public void setJournalDetail(List<JournalDetail> journalDetailList) {
        this.journalDetail = journalDetailList;
    }

    public void setIndicateil(List<Indicate> indicateList) {
        this.indicate = indicateList;
    }

    public String getStoreHeader() {
        String recHead = "";
        StringBuffer result = new StringBuffer();
        try {
            StoreMst storeMst = MstManager.getInstance().findStoreMstByCD();
            recHead = storeMst.getPosRectHead();
            recHead = recHead.replaceAll("&n", storeMst.getStoreLongName());
            recHead = recHead.replaceAll("&i", storeMst.getStoreCd().trim());
        }
        catch (AbsentMstException absentMstException) {}
        result.append("|cA" + recHead);
        return result.toString();
    }

    public List<String> getReceiptHeader(String slipNo) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(PosDateUtils.format_yyyyMMddHHmm(new Date()));
        list.add(PosStringUtils.fill("No." + slipNo, 30));
        return list;
    }

    public List<String> getReceiptFooter(boolean printName) {
        ArrayList<String> list = new ArrayList<String>();
        EmpMst emp = this.posMain.getPosEmpMst();
        EmpMst manager = this.posMain.getManagerEmpMst();
        if (printName) {
            list.add(String.format("%s:%s", emp.getEmpCd(), emp.getEmpName()));
        } else {
            list.add(emp.getEmpCd());
        }
        if (manager != null) {
            if (printName) {
                list.add(String.format("%s:%s", manager.getEmpCd(), manager.getEmpName()));
            } else {
                list.add(manager.getEmpCd());
            }
        }
        return list;
    }

    public String getReceiptLine() {
        String result = "|uC                              ";
        return result;
    }

    public String getEmptyLine() {
        String result = "|200uF";
        return result;
    }

    public boolean showItemName() {
        return true;
    }

    public String getReceiptTitle(String title) {
        return "|4C" + title;
    }
}

