/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.JournalHeadDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SlipDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.EmpMst;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.CheckMoneyData;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.GroupWebSaleKindData;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptCheck
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptCheck.class);
    private long diff = 0L;
    private List<GroupWebSaleKindData> listWebSaleKindData;
    private List<GroupWebSaleKindData> listWebSaleKindCancel;

    public ReceiptCheck(long diff) {
        this.diff = diff;
    }

    @Override
    public void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u70b9\u691c\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        SlipDAO slipDAO = new SlipDAO();
        this.listWebSaleKindData = new ArrayList<GroupWebSaleKindData>();
        this.listWebSaleKindCancel = new ArrayList<GroupWebSaleKindData>();
        this.listWebSaleKindData = slipDAO.getGroupWebSaleKindData(false);
        this.listWebSaleKindCancel = slipDAO.getGroupWebSaleKindData(true);
        CheckMoneyData checkMoneyData = CheckMoneyData.getInstance();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getReceiptTitle("\u3000\u3000\u70b9\u3000 \u691c\u3000\u3000"));
        list.add(this.getReceiptLine());
        Date checkDate = PosDateUtils.format_parse_yyMMdd(slipNo.substring(0, 6));
        list.add("\u8a08\u4e0a\u65e5\uff1a" + PosDateUtils.format_yyyyMMdd(checkDate));
        list.add(" ");
        list.add(PosStringUtils.fill("\u8cb7\u5ba2\u6570", String.valueOf(PosNumberUtils.commaFormat(slipDAO.countPurchaser())) + "\u4eba", 30));
        list.add(PosStringUtils.fill("\u4e21\u66ff", String.valueOf(PosNumberUtils.commaFormat(slipDAO.countChange())) + "\u56de", 30));
        list.add("        \u300a\u30ec\u30b8\u5185\u73fe\u91d1\u300b");
        long change = slipDAO.sumChange();
        list.add(PosStringUtils.fill("\u91e3\u92ad", PosNumberUtils.currencyFormat(change), 30));
        list.add(PosStringUtils.fill("\u73fe\u91d1\u58f2\u4e0a", PosNumberUtils.commaFormat(slipDAO.countPurchaser()), 15));
        list.add(PosStringUtils.fill("  \u58f2\u4e0a", PosNumberUtils.currencyFormat(checkMoneyData.getSumCashTotal()), 30));
        list.add(PosStringUtils.fill("  \u5024\u5f15", PosNumberUtils.currencyFormat(checkMoneyData.getSumCashTotalDiscount() * -1L), 30));
        list.add(PosStringUtils.fill("  \u53d6\u6d88", PosNumberUtils.currencyFormat((checkMoneyData.getSumCashTotalCancel() - checkMoneyData.getSumCashTotalDiscountCancel()) * -1L), 30));
        list.add(this.getReceiptLine());
        long totalAmount = this.journalHead.getTotalSaleAmount();
        list.add(PosStringUtils.fill("\u30ec\u30b8\u5408\u8a08", PosNumberUtils.currencyFormat(totalAmount), 30));
        list.add(PosStringUtils.fill("\u91e3\u92ad\u9664\u5916\u5408\u8a08", PosNumberUtils.currencyFormat(totalAmount - change), 30));
        list.add(this.getEmptyLine());
        list.add("      \u300a\u305d\u306e\u4ed6\u58f2\u4e0a\u96c6\u8a08\u300b");
        list.add("\u30af\u30ec\u30b8\u30c3\u30c8");
        list.add(PosStringUtils.fill("  \u58f2\u4e0a", PosNumberUtils.currencyFormat(slipDAO.sumCreditTotalAmount()), 30));
        list.add(PosStringUtils.fill("  \u5024\u5f15", PosNumberUtils.currencyFormat(slipDAO.sumCreditTotalDiscountAmount() * -1L), 30));
        list.add(PosStringUtils.fill("  \u53d6\u6d88", PosNumberUtils.currencyFormat((slipDAO.sumCreditTotalCancel() - slipDAO.sumCreditTotalDiscountCancel()) * -1L), 30));
        list.add("         \u300a\u70b9\u691c\u5185\u5bb9\u300b");
        int side = 12;
        String moneyInfo = "";
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e10000\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney10000())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney10000()) * 10000L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e 5000\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney5000())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney5000()) * 5000L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e 2000\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney2000())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney2000()) * 2000L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e 1000\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney1000())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney1000()) * 1000L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e  500\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney500())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney500()) * 500L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e  100\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney100())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney100()) * 100L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e   50\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney50())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney50()) * 50L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e   10\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney10())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney10()) * 10L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e    5\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney5())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney5()) * 5L), 30));
        moneyInfo = PosStringUtils.fill("\u91d1\u7a2e    1\u5186", String.valueOf(PosNumberUtils.commaFormat(checkMoneyData.getMoney1())) + "\u679a", 30 - side);
        list.add(PosStringUtils.fill(moneyInfo, PosNumberUtils.currencyFormat(NumberUtils.toLong((String)checkMoneyData.getMoney1()) * 1L), 30));
        list.add(this.getReceiptLine());
        list.add(PosStringUtils.fill("\u91d1\u7a2e\u6bce\u8a08", PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()), 30));
        list.add(PosStringUtils.fill("\u70b9\u691c\u5dee\u984d", PosNumberUtils.currencyFormat(this.diff), 30));
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(true));
        list.add(this.getReceiptLine());
        JournalHeadDAO journalHeadDAO = new JournalHeadDAO();
        List<String> empCdList = journalHeadDAO.getEmpListBizDate();
        for (String empCd : empCdList) {
            EmpMst empMst = null;
            try {
                empMst = MstManager.getInstance().findEmpMstByCD(empCd);
            }
            catch (AbsentMstException absentMstException) {
                continue;
            }
            list.add(String.format("%s:%s", empMst.getEmpCd(), empMst.getEmpName()));
        }
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u70b9\u691c\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }

    private ArrayList<String> getWebSaleLines(String webSaleKind) {
        ArrayList<String> list = new ArrayList<String>();
        long totalAmount = 0L;
        long totalDiscountAmount = 0L;
        long totalCancel = 0L;
        int i = 0;
        while (i < this.listWebSaleKindData.size()) {
            if (webSaleKind.equals(this.listWebSaleKindData.get(i).getWebSaleKind())) {
                totalAmount = this.listWebSaleKindData.get(i).getSumAmount();
                totalDiscountAmount = this.listWebSaleKindData.get(i).getSumDiscountAmount();
            }
            ++i;
        }
        int j = 0;
        while (j < this.listWebSaleKindCancel.size()) {
            if (webSaleKind.equals(this.listWebSaleKindCancel.get(j).getWebSaleKind())) {
                totalCancel = this.listWebSaleKindCancel.get(j).getSumAmount();
                totalCancel -= this.listWebSaleKindCancel.get(j).getSumDiscountAmount().longValue();
            }
            ++j;
        }
        list.add(PosStringUtils.fill("  \u58f2\u4e0a", PosNumberUtils.currencyFormat(totalAmount), 30));
        list.add(PosStringUtils.fill("  \u5024\u5f15", PosNumberUtils.currencyFormat(totalDiscountAmount * -1L), 30));
        list.add(PosStringUtils.fill("  \u53d6\u6d88", PosNumberUtils.currencyFormat(totalCancel * -1L), 30));
        return list;
    }
}

