/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.math.BigDecimal;
import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.exception.InappropriateUsageException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Indicate;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptIndicate
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptIndicate.class);
    ArrayList<String> list = new ArrayList();
    private int kindCd;
    private String itemName = null;
    private String storeName = null;
    private String labelName = null;
    private String actressName = null;
    private String className = null;
    private String genreName = null;
    private String suppName = null;
    private String price = null;
    private String cost = null;

    public ReceiptIndicate(int indicateKindCd) {
        this.kindCd = indicateKindCd;
        switch (indicateKindCd) {
            case 0: {
                this.list.add("|2C\u2605\u51fa\u5eab\u6307\u793a\u4e00\u89a7");
                break;
            }
            case 1: {
                this.list.add("|2C\u25cf\u8fd4\u54c1\u6307\u793a\u4e00\u89a7");
                this.list.add("\u3000\u3000\u8fd4\u54c1\u5148\u306f\u6b21\u306e\u3068\u304a\u308a\u3067\u3059");
                break;
            }
            default: {
                throw new InappropriateUsageException(String.format("\u6307\u793a\u533a\u5206\u304c\u4e0d\u9069\u5207\u3067\u3059[%d]", indicateKindCd));
            }
        }
    }

    @Override
    protected void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u6307\u793a\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        int line = 0;
        if (this.kindCd == 0) {
            try {
                this.setStoreName(MstManager.getInstance().findStoreNameByCD(((Indicate)this.indicate.get(0)).getToStoreCd()));
                this.list.add("\u3000\u3000\u79fb\u52d5\u5148:" + this.getStoreName() + "\u5e97(" + ((Indicate)this.indicate.get(0)).getToStoreCd() + ")");
            }
            catch (AbsentMstException absentMstException) {
                return;
            }
        } else {
            this.list.add(" ");
            this.list.add("\u3012" + this.toStr(((Indicate)this.indicate.get(0)).getBackZip()));
            this.list.add(this.toStr(((Indicate)this.indicate.get(0)).getBackAddress()));
            this.list.add(this.toStr(((Indicate)this.indicate.get(0)).getBackName()));
            this.list.add(this.toStr(((Indicate)this.indicate.get(0)).getBackTel()));
            this.list.add("\u904b\u9001\u4f1a\u793e:" + this.toStr(((Indicate)this.indicate.get(0)).getBackTransportName()) + this.getPayment(((Indicate)this.indicate.get(0)).getBackTransportKind()));
            this.list.add(this.toStr(((Indicate)this.indicate.get(0)).getBackMemo()));
            this.list.add(" ");
        }
        this.list.add(this.getReceiptLine());
        int j = 0;
        while (j < this.indicate.size()) {
            block9: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u30ec\u30b7\u30fc\u30c8\u5370\u5237::::::::::::::::::::::::::::::");
                    log.debug((Object)PosStringUtils.toString4Bean(this.indicate.get(j)));
                }
                try {
                    this.setItemName(((Indicate)this.indicate.get(j)).getItemName());
                    this.setLabelName(((Indicate)this.indicate.get(j)).getItemDetail1());
                    this.setActressName(((Indicate)this.indicate.get(j)).getItemDetail2());
                    this.setClassName(MstManager.getInstance().findClassNameByCD(((Indicate)this.indicate.get(j)).getClassCd()));
                    this.setGenreName(MstManager.getInstance().findGenreNameByCD(((Indicate)this.indicate.get(j)).getGenreCd()));
                    this.setSuppName(MstManager.getInstance().findSupplierNameByCD(((Indicate)this.indicate.get(j)).getSuppCd()));
                    this.setPrice(((Indicate)this.indicate.get(j)).getPrice());
                    this.setCost(((Indicate)this.indicate.get(j)).getCost());
                }
                catch (AbsentMstException absentMstException) {
                    log.debug((Object)String.format("\u5206\u985e[%s]\u30fb\u30b8\u30e3\u30f3\u30eb[%s]\u30fb\u4ed5\u5165\u5148[%s]\u306e\u30de\u30b9\u30bf\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002", ((Indicate)this.indicate.get(j)).getClassCd(), ((Indicate)this.indicate.get(j)).getGenreCd(), ((Indicate)this.indicate.get(j)).getSuppCd()));
                    break block9;
                }
                this.list.add(this.getItemName());
                this.list.add("|bC " + ((Indicate)this.indicate.get(j)).getItemCd());
                this.list.add("\u30ec\u30fc\u30d9\u30eb:" + this.getLabelName());
                this.list.add("\u3000\u5973\u512a\u540d:" + this.getActressName());
                this.list.add("\u3000\u3000\u5206\u985e:" + this.getClassName());
                this.list.add("\u30b8\u30e3\u30f3\u30eb:" + this.getGenreName());
                this.list.add("\u3000\u4ed5\u5165\u5148:" + this.getSuppName());
                this.list.add("\u8ca9\u58f2\u4fa1\u683c:" + this.getPrice());
                this.list.add("\u3000\u3000\u4ed5\u5207:" + this.getCost());
                this.list.add("\u3000\u6307\u793a\u65e5:" + PosDateUtils.format_yyyyMMdd(((Indicate)this.indicate.get(j)).getIndicateDate()));
                String additional = "";
                if (this.kindCd == 1) {
                    additional = " (\u5e97\u8217\u306b\u6b8b\u3059\u6570\uff1a" + ((Indicate)this.indicate.get(j)).getLeaveStockQuantity() + ")";
                }
                this.list.add("\u3000\u3000\u6570\u91cf:" + (((Indicate)this.indicate.get(j)).getIndicateQuantity() - (((Indicate)this.indicate.get(j)).getAfterQuantity() == null ? 0 : ((Indicate)this.indicate.get(j)).getAfterQuantity())) + additional);
                line += ((Indicate)this.indicate.get(j)).getIndicateQuantity() - (((Indicate)this.indicate.get(j)).getAfterQuantity() == null ? 0 : ((Indicate)this.indicate.get(j)).getAfterQuantity());
                this.list.add(this.getReceiptLine());
            }
            ++j;
        }
        this.list.add("\u3000\u3000\u5546\u54c1\u70b9\u6570:" + line + "\u70b9");
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, this.list);
        this.list.clear();
        log.info((Object)"\u6307\u793a\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }

    public String getItemName() {
        if (this.itemName != null && this.itemName.length() > 15) {
            this.itemName.substring(0, 15);
        }
        return this.itemName != null ? this.itemName : "";
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getClassName() {
        if (this.className != null && this.className.length() > 10) {
            return this.className.substring(0, 10);
        }
        return this.className != null ? this.className : "";
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getActressName() {
        if (this.actressName != null && this.actressName.length() > 10) {
            this.actressName.substring(0, 10);
        }
        return this.actressName != null ? this.actressName : "";
    }

    public void setActressName(String actressName) {
        this.actressName = actressName;
    }

    public String getGenreName() {
        if (this.genreName != null && this.genreName.length() > 10) {
            return this.genreName.substring(0, 10);
        }
        return this.genreName != null ? this.genreName : "";
    }

    public void setGenreName(String genreName) {
        this.genreName = genreName;
    }

    public String getLabelName() {
        if (this.labelName != null && this.labelName.length() > 10) {
            return this.labelName.substring(0, 10);
        }
        return this.labelName != null ? this.labelName : "";
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getSuppName() {
        if (this.suppName != null && this.suppName.length() > 10) {
            return this.suppName.substring(0, 10);
        }
        return this.suppName != null ? this.suppName : "";
    }

    public void setSuppName(String suppName) {
        this.suppName = suppName;
    }

    public String getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        if (price == null) {
            this.price = "0";
        }
        this.price = PosNumberUtils.currencyFormat(price.longValue());
    }

    public String getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        if (cost == null) {
            this.cost = "0";
        }
        this.cost = PosNumberUtils.currencyFormat(cost.longValue());
    }

    private String getPayment(String transportKind) {
        String payment = "(------)";
        if (PosStringUtils.isNotEmpty(transportKind)) {
            if (transportKind.equals("1")) {
                payment = "(\u5143\u6255\u3044)";
            } else if (transportKind.equals("2")) {
                payment = "(\u7740\u6255\u3044)";
            }
        }
        return payment;
    }

    private String toStr(String target) {
        return StringUtils.defaultString((String)target);
    }
}

