/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.StoreMst;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptSales
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptSales.class);

    @Override
    public void executeReceiptPrint(String slipNo) {
        int usePoint;
        log.info((Object)"\u8ca9\u58f2\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getEmptyLine());
        StoreMst storeMst = null;
        try {
            storeMst = MstManager.getInstance().findStoreMstByCD();
        }
        catch (AbsentMstException absentMstException) {}
        long totalDiscount = 0L;
        int i = 0;
        while (i < this.journalDetail.size()) {
            long discount;
            JournalDetail element = (JournalDetail)this.journalDetail.get(i);
            if (this.showItemName()) {
                list.add(element.getItemName());
            } else {
                list.add(element.getItemCd());
            }
            String price = PosNumberUtils.currencyFormat(element.getPrice());
            price = element.getPriceTaxKind().equals("0") ? price.concat(" " + PosConstants.TAX_KIND_NAMES_HEAD[Integer.valueOf("0")]) : (element.getPriceTaxKind().equals("1") ? price.concat(" " + PosConstants.TAX_KIND_NAMES_HEAD[Integer.valueOf("1")]) : (element.getPriceTaxKind().equals("2") ? price.concat(" " + PosConstants.TAX_KIND_NAMES_HEAD[Integer.valueOf("2")]) : price.concat("   ")));
            String itemQuantity = PosStringUtils.fill(element.getItemQuantity().toString(), 15);
            list.add(PosStringUtils.fill(itemQuantity, price, 30));
            long l = discount = element.getDiscountAmount() == null ? 0L : element.getDiscountAmount();
            if (discount != 0L) {
                list.add(PosStringUtils.fill("       ( \u5024\u5f15\u8a08", String.valueOf(PosNumberUtils.currencyFormat(discount * -1L)) + " )", 29));
            }
            totalDiscount += discount;
            ++i;
        }
        list.add(this.getReceiptLine());
        list.add(PosStringUtils.fill("\u6d88\u8cbb\u7a0e", PosNumberUtils.currencyFormat(this.journalHead.getTotalSaleTax()), 27));
        if (totalDiscount > 0L) {
            list.add(PosStringUtils.fill("\u5024\u5f15\u5408\u8a08", PosNumberUtils.currencyFormat(totalDiscount * -1L), 27));
        }
        int n = usePoint = this.journalHead.getUsePoint() == null ? 0 : this.journalHead.getUsePoint();
        if (usePoint > 0) {
            list.add(PosStringUtils.fill("(\u5229\u7528\u30dd\u30a4\u30f3\u30c8 " + PosNumberUtils.commaFormat(usePoint) + ")", 28));
        }
        String totalItemQuantity = PosStringUtils.fill("\u304a\u8cb7\u4e0a", String.valueOf(this.journalHead.getTotalItemQuantity()), 15);
        list.add("|bC" + PosStringUtils.fill(totalItemQuantity, PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()), 27));
        list.add(this.getReceiptLine());
        if (this.journalHead.getCreditKind().equals("1")) {
            list.add(PosStringUtils.fill("\u30af\u30ec\u30b8\u30c3\u30c8\u5229\u7528", 30));
        } else {
            list.add(PosStringUtils.fill("\u304a\u9810\u308a", PosNumberUtils.currencyFormat(this.journalHead.getSaleReceiveAmount()), 27));
            list.add(PosStringUtils.fill("\u304a\u91e3\u308a", PosNumberUtils.currencyFormat(this.journalHead.getSaleBackAmount()), 27));
        }
        if (PosStringUtils.isEmpty(storeMst.getSalesMessage())) {
            list.add("::  \u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3057\u305f  ::");
        } else {
            list.add(storeMst.getSalesMessage());
        }
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(false));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u8ca9\u58f2\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }
}

