/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.FileUtils;

/**
 * AXyNgONXEXgłB
 * <p>
 * @author C/pHeR
 */
public class ExcludesClassList {

	/** K[ */
	private static final Logger log = Logger.getLogger(ExcludesClassList.class);
	
	/** AXyNgONXEXgEt@C */
	public static final File file = new File(Pleiades.configurationPath, "excludes-class.list");
	
	/** ̃NX̃VOgECX^X */
	private static final ExcludesClassList singleton = new ExcludesClassList();
	
	/**
	 * AXyNgONXEXgEIuWFNg擾܂B
	 * <p>
	 * @return AXyNgONXEXgEIuWFNg
	 */
	public static ExcludesClassList getInstance() {
		return singleton;
	}
	
	/** AXyNgONXEZbg */
	private Set<String> excludeSet = new HashSet<String>();
	
	/**
	 * AXyNgONXEXg\z܂B
	 */
	@SuppressWarnings("unchecked")
	private ExcludesClassList() {
		if (Pleiades.getInstance().getPleiadesOption().isClean()) {
			log.info("-clean ɂAXyNgONXEXg̓[h܂B");
			return;
		}
		if (!file.exists()) {
			log.info("AXyNgONXEXg݂܂B");
			return;
		}
		try {
			excludeSet.addAll(FileUtils.readLines(file, null));
			log.info("AXyNgONXEXg[h܂B" + excludeSet.size());
		} catch (IOException e) {
			log.fatal("AXyNgONXEXg̃[hɎs܂B", e);
		}
	}
	
	/**
	 * ǉꂽNXLbVƂĉi܂B
	 */
	public void store() {
		try {
			FileUtils.writeLines(file, null, excludeSet);
			log.info("AXyNgONXEXgۊǂ܂B" + excludeSet.size());
		} catch (IOException e) {
			log.error("AXyNgONXEXg̕ۊǂɎs܂B", e);
		}
	}
	
	/**
	 * AXyNg珜ONXǉ܂B
	 * <p>
	 * @param className NX
	 */
	public void add(String className) {
		excludeSet.add(className);
	}
	
	/**
	 * AXyNg珜ONX폜܂B
	 * <p>
	 * @param className NX
	 * @return w肳ꂽNX݂ꍇ true
	 */
	public boolean remove(String className) {
		return excludeSet.remove(className);
	}
}
