package PositLogConfig;

# --------------------------------------------------------
# PositLogConfig.pm
#      global configuration file for PositLog
#  (tested under perl 5.8.4)
#
#  This file is part of PositLog.
# --------------------------------------------------------

#-------------------------------------------------------------------
# 以下の設定において挙げる例は，次のようなディレクトリ構成，
# サイト構成の場合について記述しています．
#
# /var/www/html/positlog/positlog.cgi
# /var/www/html/positlog/pages/
#
# http://xxx.com/positlog/positlog.cgi でPositLogへアクセス
#-------------------------------------------------------------------

#-------------------------------------------------------------------
# PositLogのルートURL
#（おわりの"/"を省略しないでください）
# 例）http://xxx.com/positlog/

my $rooturl = "http://xxx.com/positlog/";

#-------------------------------------------------------------------
# ページデータ保存用ディレクトリ
# （positlog.cgiのあるディレクトリからの相対パスで指定してください）
# （おわりの"/"を省略しないでください）
# 例) ./pages/

$datapath = "./pages/";

#-------------------------------------------------------------------
# 添付ファイルの最大バイト数
# スプライトの添付ファイルとしてアップロード可能なファイルの
# 最大サイズを指定します．バイト数で指定してください．
# 例）100キロバイトの場合，$uploadmax = 102400;
# 1メガバイトの場合　$uploadmax = 1048576;

$uploadmax = 102400;

#-------------------------------------------------------------------
# システムやメッセージの言語
# 日本語: ja
# 英語: en

$language = "ja";


#-------------------------------------------------------------------
# インストール先サーバでのmod_rewriteの利用
#
# 可能: 1
# 不可能: 0
#
# 利用可能の場合，$mod_rewrite = 1; として，PositLogに付属のファイル
# htaccess_mod_rewrite を内容に問題がないか確認の上，
# .htaccess という名前でPositLogのルートURLに置いてください．
#
# mod_rewriteが利用可能なサーバでは，ページのURLの
# positlog.cgi?load=000000XX の部分を 000000XX.html で置き換えたり
# タグをmicroformatsのrel-tagに対応させることが出来るようになります．
#
# レンタルサーバなど自分がサーバの管理者でない場合，
# mod_rewriteが使えるかどうかは，どこかで別途調べてください．

$mod_rewrite = 0;

#-------------------------------------------------------------------
# gzip圧縮転送
#
# 可能: 1
# 不可能: 0
#
# サーバでgzipが利用できる場合，$gzip = 1; にすると
# positlog.cgi の出力するHTMLファイルをgzip圧縮して
# 転送量を減らすことができます．
# $gzippathには正しいパスを入力してください．

$gzip = 0;
$gzippath = "/bin/gzip";


#-------------------------------------------------------------------
# 添付ファイルのセキュリティ
#
# PositLogを用いてアップロードした添付ファイルは，通常，
# そのURLさえ判っていれば，誰でもアクセスすることができます．
#
# アカウントをもつユーザ以外に添付ファイルが見えないようにするためには，
# $datapath に，外部からhttpプロトコルでアクセス出来ない場所を指定する
# 必要があります．
# この場合，ファイルアップロード機能を利用するには，次の手順でファイル
# ローダーを設置する必要があります．
#
# 1. まずmod_rewriteの利用できることが前提
# 2．以下のRewriteRuleを.htaccess 等に設定
#   (fileloader.cgiのパスは適当なものに変更してください)
#
#   RewriteRule ^(.*)([0-9]{6}[a-zA-Z]{2})(/images/.+)$ /fileloader.cgi?page=$2&path=$3 [L]
#   RewriteRule ^(.*)([0-9]{6}[a-zA-Z]{2})(/files/.+)$ /fileloader.cgi?page=$2&path=$3 [L]
#
# 3．fileloader.cgi を positlog.cgiと同じディレクトリに設置（755）
# 4．以下の $filesecure の値を1にする．
#

$filesecure = 0;

# 以上でファイルアップロードが可能となります．ただし，ファイルへの
# アクセスがすべてCGIを経由するので若干遅くなります．
#
# 以上の設定が不可能なサーバの場合，または意味の判らない場合，
# $filesecure = 0 のままにしておいてください．
# この場合，アカウントをもつユーザ以外に見せたくないファイルのURLがばれない
# ように気をつけてください．あるいは，ページにBASIC 認証をつけてください．


# 設定が必要なのはここまでです．以下には手を加えないでください．

$rooturl =~ /^http:\/\/.+?(\/.*)$/;
$cgipath = $1;
$systempath = $cgipath . "system/";
$bgimagespath = $cgipath ."bgimages/";
$adminpath = "./admindata/";
$rooturl =~ /^(http:\/\/.+?\/).*$/;
$site = $1;

1;
