/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import com.itextpdf.text.Document;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.OutputStream;
import jp.sourceforge.posterdivider.ImageContainer;

public class PdfGenerator {
    private static int calcPaperCount(float f, float f2) {
        if (f < 0.0f || f2 <= 0.0f) {
            return -1;
        }
        float f3 = f / f2;
        return (int)Math.ceil(f3);
    }

    public static int simulateOutputPaperCount(CreatePosterArgs createPosterArgs) {
        int n = PdfGenerator.simulateOutputPaperCountX(createPosterArgs);
        int n2 = PdfGenerator.simulateOutputPaperCountY(createPosterArgs);
        if (n < 0 || n2 < 0) {
            return -1;
        }
        return n * n2;
    }

    public static int simulateOutputPaperCountX(CreatePosterArgs createPosterArgs) {
        float f = createPosterArgs.getPosterWidth();
        float f2 = createPosterArgs.getPaperWidth();
        float f3 = createPosterArgs.getMarginLeft();
        float f4 = createPosterArgs.getMarginRight();
        if (f < 0.0f) {
            return -1;
        }
        if (f2 < 0.0f) {
            return -1;
        }
        if (f3 < 0.0f || f4 < 0.0f) {
            return -1;
        }
        float f5 = f2 - f3 - f4;
        int n = PdfGenerator.calcPaperCount(f, f5);
        if (n < 0) {
            return -1;
        }
        return n;
    }

    public static int simulateOutputPaperCountY(CreatePosterArgs createPosterArgs) {
        float f = createPosterArgs.getPosterHeight();
        float f2 = createPosterArgs.getPaperHeight();
        float f3 = createPosterArgs.getMarginTop();
        float f4 = createPosterArgs.getMarginBottom();
        if (f < 0.0f) {
            return -1;
        }
        if (f2 < 0.0f) {
            return -1;
        }
        if (f3 < 0.0f || f4 < 0.0f) {
            return -1;
        }
        float f5 = f2 - f3 - f4;
        int n = PdfGenerator.calcPaperCount(f, f5);
        if (n < 0) {
            return -1;
        }
        return n;
    }

    public static void createPosterFromPdf(PdfReader pdfReader, int n, CreatePosterArgs createPosterArgs, OutputStream outputStream) {
        float f;
        PdfWriter pdfWriter;
        float f2 = createPosterArgs.getSrcLeft();
        float f3 = createPosterArgs.getSrcBottom();
        float f4 = createPosterArgs.getSrcWidth();
        float f5 = createPosterArgs.getSrcHeight();
        float f6 = createPosterArgs.getPosterWidth();
        float f7 = createPosterArgs.getPosterHeight();
        float f8 = createPosterArgs.getPaperWidth();
        float f9 = createPosterArgs.getPaperHeight();
        float f10 = createPosterArgs.getMarginLeft();
        float f11 = createPosterArgs.getMarginTop();
        float f12 = createPosterArgs.getMarginRight();
        float f13 = createPosterArgs.getMarginBottom();
        if (pdfReader == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n > pdfReader.getNumberOfPages()) {
            throw new IllegalArgumentException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (f4 <= 0.0f || f5 <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (f6 < 0.0f || f7 < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (f8 < 0.0f || f9 < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (f10 < 0.0f || f11 < 0.0f || f12 < 0.0f || f13 < 0.0f) {
            throw new IllegalArgumentException();
        }
        Document document = new Document(new Rectangle(f8, f9), f10, f12, f11, f13);
        f8 = document.getPageSize().getWidth();
        f9 = document.getPageSize().getHeight();
        f10 = document.leftMargin();
        f11 = document.topMargin();
        f12 = document.rightMargin();
        f13 = document.bottomMargin();
        float f14 = f8 - f10 - f12;
        float f15 = f9 - f11 - f13;
        int n2 = PdfGenerator.calcPaperCount(f6, f14);
        int n3 = PdfGenerator.calcPaperCount(f7, f15);
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        try {
            pdfWriter = PdfWriter.getInstance(document, outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        document.open();
        PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n);
        float f16 = f6 / f4;
        float f17 = f7 / f5;
        float f18 = f10 - f2 * f16;
        float f19 = f = f9 - f11 - f7 - f3 * f17;
        for (int i = 0; i < n3; ++i) {
            float f20 = f18;
            for (int j = 0; j < n2; ++j) {
                document.newPage();
                pdfWriter.getDirectContent().addTemplate(pdfImportedPage, f16, 0.0f, 0.0f, f17, f20, f19);
                f20 -= f14;
            }
            f19 += f15;
        }
        document.close();
        pdfWriter.close();
    }

    public static void createPosterFromImage(Image image, CreatePosterArgs createPosterArgs, OutputStream outputStream) {
        float f;
        PdfWriter pdfWriter;
        float f2 = createPosterArgs.getSrcLeft();
        float f3 = createPosterArgs.getSrcBottom();
        float f4 = createPosterArgs.getSrcWidth();
        float f5 = createPosterArgs.getSrcHeight();
        float f6 = createPosterArgs.getPosterWidth();
        float f7 = createPosterArgs.getPosterHeight();
        float f8 = createPosterArgs.getPaperWidth();
        float f9 = createPosterArgs.getPaperHeight();
        float f10 = createPosterArgs.getMarginLeft();
        float f11 = createPosterArgs.getMarginTop();
        float f12 = createPosterArgs.getMarginRight();
        float f13 = createPosterArgs.getMarginBottom();
        if (image == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (f4 <= 0.0f || f5 <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (f6 < 0.0f || f7 < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (f8 < 0.0f || f9 < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (f10 < 0.0f || f11 < 0.0f || f12 < 0.0f || f13 < 0.0f) {
            throw new IllegalArgumentException();
        }
        Document document = new Document(new Rectangle(f8, f9), f10, f12, f11, f13);
        f8 = document.getPageSize().getWidth();
        f9 = document.getPageSize().getHeight();
        f10 = document.leftMargin();
        f11 = document.topMargin();
        f12 = document.rightMargin();
        f13 = document.bottomMargin();
        float f14 = f8 - f10 - f12;
        float f15 = f9 - f11 - f13;
        int n = PdfGenerator.calcPaperCount(f6, f14);
        int n2 = PdfGenerator.calcPaperCount(f7, f15);
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        try {
            pdfWriter = PdfWriter.getInstance(document, outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
        document.open();
        float f16 = f6 / f4;
        float f17 = f7 / f5;
        float f18 = f16 * image.getWidth();
        float f19 = f17 * image.getHeight();
        float f20 = f10 - f2 * f16;
        float f21 = f = f9 - f11 - f7 - f3 * f17;
        for (int i = 0; i < n2; ++i) {
            float f22 = f20;
            for (int j = 0; j < n; ++j) {
                document.newPage();
                try {
                    pdfWriter.getDirectContent().addImage(image, f18, 0.0f, 0.0f, f19, f22, f21);
                }
                catch (Exception exception) {
                    throw new RuntimeException();
                }
                f22 -= f14;
            }
            f21 += f15;
        }
        document.close();
        pdfWriter.close();
    }

    public static void createPoster(ImageContainer imageContainer, CreatePosterArgs createPosterArgs, OutputStream outputStream) {
        switch (imageContainer.getFileType()) {
            case 1: {
                PdfGenerator.createPosterFromPdf(imageContainer.getPdf(), imageContainer.getPageNum(), createPosterArgs, outputStream);
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                PdfGenerator.createPosterFromImage(imageContainer.getImage(), createPosterArgs, outputStream);
                return;
            }
        }
    }

    public static class CreatePosterArgs {
        private float srcLeft = -1.0f;
        private float srcBottom = -1.0f;
        private float srcRight = -1.0f;
        private float srcTop = -1.0f;
        private float posterWidth = -1.0f;
        private float posterHeight = -1.0f;
        private float paperWidth = -1.0f;
        private float paperHeight = -1.0f;
        private float marginLeft = -1.0f;
        private float marginTop = -1.0f;
        private float marginRight = -1.0f;
        private float marginBottom = -1.0f;

        public float getSrcLeft() {
            return this.srcLeft;
        }

        public void setSrcLeft(float f) {
            this.srcLeft = f;
        }

        public float getSrcBottom() {
            return this.srcBottom;
        }

        public void setSrcBottom(float f) {
            this.srcBottom = f;
        }

        public float getSrcRight() {
            return this.srcRight;
        }

        public void setSrcRight(float f) {
            this.srcRight = f;
        }

        public float getSrcTop() {
            return this.srcTop;
        }

        public void setSrcTop(float f) {
            this.srcTop = f;
        }

        public float getSrcWidth() {
            return this.srcRight - this.srcLeft;
        }

        public float getSrcHeight() {
            return this.srcTop - this.srcBottom;
        }

        public float getPosterWidth() {
            return this.posterWidth;
        }

        public void setPosterWidth(float f) {
            this.posterWidth = f;
        }

        public float getPosterHeight() {
            return this.posterHeight;
        }

        public void setPosterHeight(float f) {
            this.posterHeight = f;
        }

        public float getPaperWidth() {
            return this.paperWidth;
        }

        public void setPaperWidth(float f) {
            this.paperWidth = f;
        }

        public float getPaperHeight() {
            return this.paperHeight;
        }

        public void setPaperHeight(float f) {
            this.paperHeight = f;
        }

        public float getMarginLeft() {
            return this.marginLeft;
        }

        public void setMarginLeft(float f) {
            this.marginLeft = f;
        }

        public float getMarginTop() {
            return this.marginTop;
        }

        public void setMarginTop(float f) {
            this.marginTop = f;
        }

        public float getMarginRight() {
            return this.marginRight;
        }

        public void setMarginRight(float f) {
            this.marginRight = f;
        }

        public float getMarginBottom() {
            return this.marginBottom;
        }

        public void setMarginBottom(float f) {
            this.marginBottom = f;
        }

        public void setSrcRect(float f, float f2, float f3, float f4) {
            this.srcLeft = f;
            this.srcBottom = f2;
            this.srcRight = f3;
            this.srcTop = f4;
        }

        public void setSrcRect(Rectangle rectangle) {
            this.setSrcRect(rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight(), rectangle.getTop());
        }

        public void setPosterSize(float f, float f2) {
            this.posterWidth = f;
            this.posterHeight = f2;
        }

        public void setPosterSize(Rectangle rectangle) {
            this.setPosterSize(rectangle.getWidth(), rectangle.getHeight());
        }

        public void setPaperSize(float f, float f2) {
            this.paperWidth = f;
            this.paperHeight = f2;
        }

        public void setPaperSize(Rectangle rectangle) {
            this.setPaperSize(rectangle.getWidth(), rectangle.getHeight());
        }

        public void setMargin(float f, float f2, float f3, float f4) {
            this.marginLeft = f;
            this.marginTop = f2;
            this.marginRight = f3;
            this.marginBottom = f4;
        }
    }
}

