//
// ImageContainer.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import java.awt.image.BufferedImage;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfReader;

/**
 * Contains image object.
 * 
 * @author s090524
 */
public class ImageContainer {
	private int fileType;
	private PdfReader pdf;
	private Image image;
	private int pageNum;
	// CanvasPreview用
	private BufferedImage awtImage;

	public ImageContainer(FileContainer fc, int pageNum) throws Exception {
		this.fileType = fc.getFileType();
		this.pdf = fc.getPdf();
		this.image = fc.getImage();
		if (pageNum <= 0 || pageNum > fc.getPageCount()) {
			throw new IllegalArgumentException();
		}
		this.pageNum = pageNum;
		this.awtImage = fc.getAwtImage();
	}

	public int getFileType() {
		return this.fileType;
	}

	public PdfReader getPdf() {
		return this.pdf;
	}

	public Image getImage() {
		return this.image;
	}

	public int getPageNum() {
		return this.pageNum;
	}

	public float getImageWidth() {
		switch (this.fileType) {
		case Lib.FT_PDF:
			return this.pdf.getPageSize(this.pageNum).getWidth();
		case Lib.FT_BMP:
		case Lib.FT_GIF:
		case Lib.FT_JBIG2:
		case Lib.FT_JPEG:
		case Lib.FT_JPEG2000:
		case Lib.FT_PNG:
		case Lib.FT_TIFF:
		case Lib.FT_WMF:
		case Lib.FT_OTHERIMAGE:
			return this.image.getWidth();
		default:
			return -1;
		}
	}

	public float getImageHeight() {
		switch (this.fileType) {
		case Lib.FT_PDF:
			return this.pdf.getPageSize(this.pageNum).getHeight();
		case Lib.FT_BMP:
		case Lib.FT_GIF:
		case Lib.FT_JBIG2:
		case Lib.FT_JPEG:
		case Lib.FT_JPEG2000:
		case Lib.FT_PNG:
		case Lib.FT_TIFF:
		case Lib.FT_WMF:
		case Lib.FT_OTHERIMAGE:
			return this.image.getHeight();
		default:
			return -1;
		}
	}

	public BufferedImage getAwtImage() {
		return this.awtImage;
	}
}
