<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * 桼ѥ桼
 *
 * $RCSfile: index.php,v $
 * $Revision: 1.2 $
 * $Date: 2010/06/23 07:44:58 $
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibldap");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");

/********************************************************
 *ƥڡ
 *********************************************************/

define("OPERATION", "桼");
define("MODE_LDAPDATA", 0);
define("MODE_POSTDATA", 1);

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

   /***********************************************************
    * ܥǥɽʥС饤ɡ
    **********************************************************/
    function display_body() {

        global $sesskey;
        global $user;
        global $dispusr;
        global $mode;
        global $domain;

        $save_flag = "";
        if ($mode == MODE_POSTDATA) {
            /* ⡼ */
            $user = htmlspecialchars($user);
            $trans = htmlspecialchars($_POST['trans']);
            if (isset ($_POST['save'])) {
                $save_flag = $_POST['save'];
            }
        } else {
            /* LDAPǡ⡼ */
            global $ldapdata;
            
            /* ž襢ɥ쥹˼ʬΥɥ쥹С    *
             * Ф˥᡼ĤꡢʤлĤʤ*/
            if (isset ($ldapdata[0]['mailForwardingAddr'][1])) {
                $save_flag = "0";
                if ($ldapdata[0]['mail'][0] == $ldapdata[0]['mailForwardingAddr'][0]) {
                    $trans = $ldapdata[0]['mailForwardingAddr'][1];
                } else {
                    $trans = $ldapdata[0]['mailForwardingAddr'][0];
                }
            } else if (isset ($ldapdata[0]['mailForwardingAddr'][0])) {
                $save_flag = "1";
                $trans = $ldapdata[0]['mailForwardingAddr'][0];
            } else {
                $trans = "";
            }

            $user = htmlspecialchars($user);
            $trans = htmlspecialchars($trans);
        } 

        /* ե饰˱ƥ饸ܥΥå */
        $save_mail_check = "";
        $unsave_mail_check = "";
        if ($save_flag == "0") {
            $save_mail_check = "checked";
        } elseif ($save_flag == "1") {
            $unsave_mail_check = "checked";
        }

print <<<EOD

<script type="text/javascript">
<!--
window.onload = function() {
  var i;
  var len = document.mod_form.save.length;
  if(document.mod_form.trans.value == "") {
    for(i=0;i<len;i++) {
      document.mod_form.save[i].disabled = true;
    }
  } else {
    for(i=0;i<len;i++) {
      document.mod_form.save[i].disabled = false;
    }
  }
}
function check(n) {
  var i;
  var len = document.mod_form.save.length;
  if(n == "") {
    for(i=0;i<len;i++) {
      document.mod_form.save[i].disabled = true;
    }
  } else {
    for(i=0;i<len;i++) {
      document.mod_form.save[i].disabled = false;
    }
  }
}
// -->
</script>


<form method="POST" action="index.php" name="mod_form">
<table class="table">
  <tr>
    <td class="key1">桼̾</td>
    <td class="value">$dispusr</td>
  </tr>
  <tr>
    <td class="key1">ѥ</td>
    <td class="value"><input type="password" name="passwd1" size="15" maxlength="8"></td>
  </tr>
  <tr>
    <td class="key1">ѥ(ǧ)</td>
    <td class="value"><input type="password" name="passwd2" size="15" maxlength="8"></td>
  </tr>
  <tr>
    <td class="key1">᡼žɥ쥹</td>
    <td class="value">
      <input type="text" name="trans" size="39" value="$trans" maxlength="256" onBlur="check(this.value)">
      <br>
      Ф˥᡼
      <input type="radio" name="save" value="0" {$save_mail_check} disabled>Ĥ
      <input type="radio" name="save" value="1" {$unsave_mail_check} disabled >Ĥʤ<br>
    </td>
  </tr>
</table>
<br>
<input type="submit" name="modify" value="" class="mod_btn">
<input type="hidden" name="sk" value="$sesskey">
</form>

EOD;
    }
}
/*********************************************************
 * check_user_data
 *
 * ϥեηå
 *
 * []
 *         $mail     ᡼륢ɥ쥹
 *         $passwd   ѥ
 *         $repasswd ѥ(ǧ)
 *         $trans    ž襢ɥ쥹
 *         $save     ᡼¸
 *         &$attrs   °Ǽ
 * [֤]
 *         TRUE      
 *         FALSE     ۾
 *
 **********************************************************/
function check_user_data($mail, $passwd, $repasswd, $trans, $save, &$attrs)
{
    global $err_msg;
    global $web_conf;
    global $user;
    global $ldapdata;

    if (isset($ldapdata[0]['mailAlias'][0])) {
        $alias = $ldapdata[0]['mailAlias'][0];
    }
    $transes = array();

    /* ѥϥå */
    if ($passwd != "" || $repasswd != "") {
        $ret = check_passwd($passwd, MINPASSWD, MAXPASSWD);
        if ($ret === FALSE) {
            return FALSE;
        }
        /* ѥɤΰפǧ */
        if ($passwd != $repasswd) {
            $err_msg = "ѥɤפޤ";
            return FALSE;
        }

        /* ѥɤǼ */
        $attrs['userPassword'] = CRYPT . my_crypt($passwd);
    }

    if ($trans != "") {
        /* ᡼žɥ쥹ϥå */
        if (check_mail ($trans) === FALSE) {
            $err_msg = "᡼žɥ쥹ηǤ";
            return FALSE;
        }
        array_push ($transes, $trans);
        /* ᡼¸å */
        if ($save == "") {
            $err_msg = "᡼Ĥ/Ĥʤ꤬Ƥޤ";
            return FALSE;
        }
        if (check_flg($save) === FALSE) {
            $err_msg = "᡼Ĥ/ĤʤͤǤ";
            return FALSE;
        }
        /* žɥ쥹ʣå */
        if ($trans == $mail) {
            $err_msg = "᡼žɥ쥹᡼륢ɥ쥹" .
                       "ʣƤޤ";
            return FALSE;
        }
        if (isset ($alias) && $trans == $alias) {
            $err_msg = "᡼žɥ쥹᡼륨ꥢ" .
                       "ʣƤޤ";
            return FALSE;
        }
        if ($save == 0) {
            /* ᡼Ĥξžɥ쥹˼᡼륢ɥ쥹ɲ */
            array_push($transes, $mail);
        }

        /* žɥ쥹Ǽ */
        $attrs['mailForwardingAddr'] = $transes;
    } else {
        /* ž襢ɥ쥹ǤСо */
        $attrs['mailForwardingAddr'] = array();
    }

    /* ᡼ǥ쥯ȥ°ʤк */
    if (!isset($ldapdata[0]["mailDirectory"][0])) {
        $attrs["mailDirectory"] = $web_conf[$url_data["script"]]["basemaildir"] . 
                                  "/" . $user . "/";
    }

    return TRUE;
}

/*********************************************************
 * mod_user_data
 *
 * 桼ǡѹԤ
 *
 * []
 *         $attrs   °Ǽ
 * [֤]
 *         TRUE     
 *         FALSE    ۾
 *
 **********************************************************/
function mod_user_data($attrs)
{
    global $err_msg;
    global $env;
    global $user;
    global $sesskey;

    /* DNѹ */
    $env['user_self'] = FALSE;

    /* LDAPǡι */
    $dn = $env['user_selfdn'];
    $ret = LDAP_mod_entry($dn, $attrs);
    if ($ret !== LDAP_OK) {
        return FALSE;
    } else {
        $err_msg = "桼򹹿ޤ";
        result_log(OPERATION . ":OK:" . $err_msg);
        if (isset ($_POST['passwd1']) && $_POST['passwd1'] != "") {
           /* Ѥ˥å󥭡 */
           sess_key_make($user, $_POST['passwd1'], $sesskey);
        }
    }
    return TRUE;
}

/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg  = new my_page();

/* ե롢ִեɹåå */
$ret = user_init();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(NULL);
    exit (1);
}

$err_msg = "";

/***********************************************************
 * main
 **********************************************************/
/* ʬ */

/* 桼̾Ǽ */
$user = $env['loginuser'];
$userdn = $env['user_selfdn'];

/* 桼μ */
$ret = get_userdata ($userdn);
if ($ret === FALSE) {
    result_log(OPERATION . ":NG:" . $err_msg);
    $err_msg = "桼μ˼Ԥޤ";
    $sys_err = TRUE;
    $pg->display(NULL);
    exit (1);
}

$dispusr = $web_conf[$url_data['script']]['displayuser'];
$dispusr = htmlspecialchars($ldapdata[0][$dispusr][0]);

if (isset($_POST['modify'])) {

    $mode = MODE_POSTDATA;

    $mail = $ldapdata[0]['mail'][0];
    $passwd = $_POST['passwd1'];
    $repasswd = $_POST['passwd2'];
    $trans = $_POST['trans'];
    if (isset($_POST['save'])) { 
        $save = $_POST['save'];
    } else {
        $save = NULL;
    }

    /* ϥǡΥå */
    $ret = check_user_data($mail, $passwd, $repasswd, $trans, $save, $attrs);
    if ($ret === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {

        $ret = mod_user_data($attrs);
        if ($ret === FALSE) {
            result_log(OPERATION . ":NG:" . $err_msg);
        } else {
            /* ɽѤ˺LDAPǡ */
            unset($ldapdata);
            $ret = get_userdata($userdn);
            if ($ret === FALSE) {
                result_log(OPERATION . ":NG:" . $err_msg);
                $err_msg = "桼μ˼Ԥޤ";
                $sys_err = TRUE;
                $pg->display(NULL);
                exit (1);
            }
        }
    }
}


/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display(CONTENT);

?>
