# prime/engine/engine-number.rb
# $Id: engine-number.rb,v 1.1 2003/11/28 07:33:53 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine'
$engine_class_name = 'PrimeEngineNumber'

class PrimeEngineNumber < PrimeEngine
  def initialize
    super

    @name = "Number engine"
    @id   = "number"
    @description = "Number engine"
  end

  private
  def lookup (input, method = :prefix)
    results = PrimeResult.new

    calculation = calc(input.original)
    if calculation then
      results << PrimeCandidate.new(calculation, calculation, 20000, "ü")
    end
    return results
  end

  def calc (string)
    if string =~ /[-+*\/ 0-9()]+=$/ then
      begin
	return eval(string[0..-2])
      rescue
	return nil
      end
    end
    return nil
  end

  def taiyaki (string)
    string_numbers     = string.split(/[^0-9]+/)
    if string_numbers == [] then
      return nil
    else
      string_non_numbers = string.split(/[0-9]+/)
      return string_non_numbers.join("#")
    end
  end
end
