%define ruby_libdir %(ruby -rrbconfig -e 'puts Config::CONFIG["rubylibdir"]')
%define name    prime
%define version 0.6.5
%define release 1

Summary: PRIME - a Japanese PRedictive Input Method Editor
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
URL: http://taiyaki.org/prime
Source: http://taiyaki.org/prime/src/%{name}-%{version}.tar.gz
Group: Applications/System
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: ruby, ruby-sary
BuildRequires: ruby

%description
PRIME predicts user's input words using the knowledge of natural
language and the history of user's operations, and reduces the
cost of typing by the user.  For example, if a user wants to input
"application" and types "ap" as the beginning characters of the word,
PRIME might predict some candidate words like "apple", "application",
"appointment", etc...  And then the user can input "application"
easily by selecting the word from the candidate words by PRIME.

%prep
rm -rf %{buildroot}

%setup -q

%build
%configure
make

%install
make prefix=%{buildroot}%{_prefix} \
PRIME_CONFIG_DIR=%{buildroot}%{_sysconfdir} \
PRIME_DOC_DIR=%{buildroot}%{_docdir}/%{name} \
PRIME_GRAMMAR_DIR=%{buildroot}%{_datadir}/prime/grammar \
rubydir=%{buildroot}%{ruby_libdir} \
primedotfilesdir=%{buildroot}%{_docdir}/%{name}/examples \
bindir=%{buildroot}%{_bindir} \
install

mkdir -p %{buildroot}%{_sysconfdir}/prime
install -c -m 644 etc/Custom_prime.rb %{buildroot}%{_sysconfdir}/prime

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_bindir}/*
%{_datadir}/prime
%{_libdir}/ruby/*/*
%{_sysconfdir}/prime
%{_docdir}/%{name}
%doc AUTHORS COPYING NEWS README ChangeLog doc

%changelog
* Tue Dec 16 2003 Masaki Yatsu <yatsu@digital-genes.com>
- (0.6.3-1)
- version up

* Mon Nov  3 2003 Masaki Yatsu <yatsu@digital-genes.com>
- (0.6.2-1)
- version up

* Sun May 18 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (0.5.1-1 / 0.5.1-0pa1)
- version up

* Tue May 13 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (0.5.0-0pa1)
- first build
