# prime/engine/engine-adambnc.rb
# $Id: engine-adambnc.rb,v 1.1.2.1 2004/06/01 06:41:28 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine-basic'

$engine_class_name = 'PrimeEngineAdamBNC'

class PrimeEngineAdamBNC < PrimeEngineBasic
  def initialize
    super('prime-dict-en')

    @name = "Adam BNC engine"
    @id   = "adambnc"
    @description = "Adam BNC engine"
  end

  def search (query)
    query.input += query.input.map {|key| key.downcase }
    query.input.uniq!()
    super(query)
  end
end
