/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.io.UnsupportedEncodingException;
import zephyr.sanshusha.accessdejp.Util;

class Buffer {
    final byte[] data;
    private int len = 0;
    static final int BUFSIZE = 32768;

    Buffer() {
        this(32768);
    }

    Buffer(int n) {
        this.data = new byte[n];
    }

    void add(byte by) {
        this.data[this.len] = by;
        ++this.len;
    }

    void add(String string) {
        byte[] byArray;
        for (byte by : byArray = string.getBytes()) {
            this.add(by);
        }
    }

    void deleteLast() {
        if (this.len > 0) {
            --this.len;
        }
    }

    byte getLeftByte(int n, int n2) {
        byte by = this.data[this.len - n];
        return (byte)(Util.sbyte2int(by) + n2);
    }

    int length() {
        return this.len;
    }

    void clear() {
        this.len = 0;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        try {
            String string = bl ? "Windows-31J" : "UTF-8";
            return new String(this.data, 0, this.len, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.data.toString();
        }
    }
}

