/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UTF8toSJIS;
import zephyr.util.UnescapeChars;
import zephyr.util.ZephyrUtil;

public class CheckLaJpBody {
    private final HashMap<String, FixEntry> fixMap = new HashMap();
    private final LinkedList<EsEntry> esEntries = new LinkedList();
    private static final String HEXCODE_REGEXP = "(0[0-9A-F]{3}|762D)";
    private static final Pattern HEXCODE = Pattern.compile("(0[0-9A-F]{3}|762D)");
    private static final String WORD_REGEXP = "([a-zA-Z\u0100\u0112\u012a\u014c\u016a]+)";
    private static final Pattern WORD = Pattern.compile("([a-zA-Z\u0100\u0112\u012a\u014c\u016a]+)");
    private int nFixed = 0;
    private static final HashMap<Character, String> extCharsMap = new HashMap();

    static {
        extCharsMap.put(Character.valueOf('Y'), "\u0233");
        extCharsMap.put(Character.valueOf('I'), "\u012b\u02d8");
        extCharsMap.put(Character.valueOf('E'), "\u0113\u02d8");
        extCharsMap.put(Character.valueOf('O'), "\u014d\u02d8");
        extCharsMap.put(Character.valueOf('U'), "\u016b\u02d8");
    }

    private void loadLaJpFix(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] words = line.split("\t");
            if (words.length == 3) {
                this.fixMap.put(words[0], new FixEntry(words[1], words[2]));
                continue;
            }
            if (words.length == 2) {
                this.fixMap.put(words[0], new FixEntry(words[0], words[1]));
                continue;
            }
            System.err.println("invalid lajpfix line: " + line);
        }
        System.err.println("loaded " + this.fixMap.size() + " fix entries");
    }

    private String toUnicode(String line) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Matcher m = HEXCODE.matcher(line);
        while (m.find()) {
            if (i < m.start()) {
                sb.append(line.substring(i, m.start()));
            }
            int code = Integer.parseInt(m.group(1), 16);
            char c = Character.toUpperCase((char)code);
            sb.append(c);
            i = m.end();
        }
        if (i < line.length()) {
            sb.append(line.substring(i));
        }
        return sb.toString();
    }

    private void loadEsbody(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        boolean bNew = true;
        EsEntry entry = null;
        while ((line = br.readLine()) != null) {
            if (line.equals("======")) {
                bNew = true;
                continue;
            }
            line = this.toUnicode(line);
            if (bNew) {
                entry = new EsEntry(line);
                this.esEntries.add(entry);
                bNew = false;
                continue;
            }
            entry.lines.add(line);
        }
        System.err.println("loaded " + this.esEntries.size() + " entries");
    }

    private String compare(String dt, String line0, String esline) {
        String kline = line0.toUpperCase();
        if (kline.equals(esline)) {
            return line0;
        }
        String dropChars = "\uff08\uff09\uff3b\uff3d\u300a\u300b\u3008\u3009\uff0b\uff5e\u2019\u300c\u300d";
        int i = 0;
        while (i < "\uff08\uff09\uff3b\uff3d\u300a\u300b\u3008\u3009\uff0b\uff5e\u2019\u300c\u300d".length()) {
            kline = kline.replace("\uff08\uff09\uff3b\uff3d\u300a\u300b\u3008\u3009\uff0b\uff5e\u2019\u300c\u300d".substring(i, i + 1), "");
            ++i;
        }
        String[][] replaces = new String[][]{{"\u00c1", "AACUTE"}, {"\u00c2", "ACIRC"}, {"\u00c7", "CCEDIL"}, {"\u00c9", "EACUTE"}, {"\u00c8", "EGRAVE"}, {"\u00cb", "EUML"}, {"\u00cd", "IACUTE"}, {"\u00ce", "ICIRC"}, {"\u00d1", "NTILDE"}, {"\u00d3", "OACUTE"}, {"\u00d6", "OUML"}, {"\u00d4", "OCIRC"}, {"\u00da", "UACUTE"}, {"\u00dc", "UUML"}};
        int i2 = 0;
        while (i2 < replaces.length) {
            kline = kline.replace(replaces[i2][0], replaces[i2][1]);
            ++i2;
        }
        Matcher m1 = WORD.matcher(kline);
        Matcher m2 = WORD.matcher(esline);
        String fline = null;
        int nFixed = 0;
        while (m1.find()) {
            String w2;
            if (!m2.find()) {
                System.err.println("ERR: dt=" + dt + "\n\tkline=" + line0 + "\n\teline=" + esline);
                this.invalidEntry(dt);
                break;
            }
            String w1 = m1.group(1);
            if (w1.equals(w2 = m2.group(1))) continue;
            String tline = this.makeFixedWord(line0, w1, w2);
            if (tline == null) {
                System.err.println("WARN: dt=" + dt + "\n\tkline=" + line0 + "\n\teline=" + esline);
                this.invalidEntry(dt);
            } else if (nFixed == 0) {
                fline = tline;
            }
            ++nFixed;
        }
        if (nFixed == 1) {
            return fline;
        }
        return null;
    }

    private String keyForEstraier(String key) {
        String[][] replaces = new String[][]{{"\uff0e", "."}, {"\u300a", ""}, {"\u300b", ""}, {"\uff0a", "*"}, {"\u00cf", "IUML"}, {"\uff3b", ""}, {"\uff3d", ""}};
        key = key.toUpperCase();
        int i = 0;
        while (i < replaces.length) {
            key = key.replace(replaces[i][0], replaces[i][1]);
            ++i;
        }
        return key;
    }

    private String fixedKeyByEs(String key, String eskey) {
        if (key.length() == eskey.length() - 1) {
            int ndrop = 0;
            int dIdx = -1;
            char dChar = '\u0000';
            int i = 0;
            while (i < key.length()) {
                char c2;
                char c1 = key.charAt(i - ndrop);
                if (c1 != (c2 = eskey.charAt(i))) {
                    switch (c2) {
                        case 'E': 
                        case 'I': 
                        case 'O': 
                        case 'U': 
                        case 'Y': {
                            if (dIdx < 0) {
                                dIdx = i;
                                ndrop = 1;
                                dChar = c2;
                                break;
                            }
                            return key;
                        }
                        default: {
                            return key;
                        }
                    }
                }
                ++i;
            }
            if (dIdx >= 0) {
                ++this.nFixed;
                return String.valueOf(key.substring(0, dIdx)) + dChar + key.substring(dIdx);
            }
            return eskey;
        }
        return key;
    }

    private String makeFixedWord(String word, String key, String eskey) {
        if (key.length() != eskey.length() - 1) {
            return null;
        }
        int i = 0;
        while (i < key.length()) {
            char c2;
            char c1 = key.charAt(i);
            if (c1 != (c2 = eskey.charAt(i))) break;
            ++i;
        }
        String ex = extCharsMap.get(Character.valueOf(eskey.charAt(i)));
        if (ex == null) {
            return null;
        }
        String dt2 = word.toUpperCase();
        int idx = dt2.indexOf(key);
        if (idx >= 0) {
            ++this.nFixed;
            int k = idx + i;
            if (k < word.length()) {
                return String.valueOf(word.substring(0, k)) + ex + word.substring(k);
            }
            return String.valueOf(word.substring(0, k)) + ex;
        }
        return null;
    }

    private void invalidEntry(String dt) {
        System.err.println();
        System.err.println("*********************");
        String t = UnescapeChars.unescapeCode(UTF8toSJIS.convert(dt));
        System.err.println("ERROR: headword=" + dt + "\t" + t);
        System.exit(1);
    }

    private void loadLaJpBody(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        int idx = 0;
        EsEntry entry = null;
        String dt = "";
        FixEntry fixEntry = null;
        System.err.print("fixing Latin-Japanese entries ");
        while ((line = br.readLine()) != null) {
            String line2;
            boolean bFixed;
            if (line.equals("======")) {
                System.out.println(line);
                continue;
            }
            String trline = line.trim();
            if (trline.isEmpty()) continue;
            if (trline.equals("\uff3b\u2191\uff3d") || trline.equals("\uff3b\u2193\uff3d")) {
                System.out.println(line);
                continue;
            }
            if (line.charAt(0) != ' ') {
                String trline2;
                fixEntry = this.fixMap.get(trline);
                bFixed = false;
                if (fixEntry != null && !(trline2 = trline.replace(fixEntry.before, fixEntry.after)).equals(trline)) {
                    System.out.println(trline2);
                    bFixed = true;
                }
                dt = trline;
                entry = this.esEntries.get(idx);
                if (!bFixed) {
                    String key = this.keyForEstraier(trline);
                    if (!key.equals(entry.dt)) {
                        String key2 = this.fixedKeyByEs(key, entry.dt);
                        if (!key2.equals(entry.dt)) {
                            this.invalidEntry(dt);
                        } else {
                            dt = this.makeFixedWord(dt, key, entry.dt);
                        }
                    }
                    System.out.println(dt);
                }
                if (++idx % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            bFixed = false;
            if (fixEntry != null && !(line2 = line.replace(fixEntry.before, fixEntry.after)).equals(line)) {
                System.out.println(line2);
                bFixed = true;
            }
            String cmpline = entry.lines.poll();
            if (bFixed) continue;
            if (cmpline != null) {
                String kline = this.compare(dt, line, cmpline);
                if (kline != null && kline != line) {
                    line = kline;
                }
            } else {
                System.err.println("ERROR: cannot get esBodyLines for " + entry.dt);
                System.err.println("\t" + line);
            }
            System.out.println(line);
        }
        System.err.println();
        System.err.println("done. " + idx + " entries. " + this.nFixed + " fixed.");
    }

    public static void main(String[] args) {
        if (args.length >= 3) {
            ZephyrUtil.setUTF8Ouput();
            CheckLaJpBody app = new CheckLaJpBody();
            try {
                app.loadLaJpFix(args[2]);
                app.loadEsbody(args[1]);
                app.loadLaJpBody(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java CheckLaJpBody kenkyusya-lajp.txt esloader.txt lajpfix.txt");
        }
    }

    private static class EsEntry {
        final String dt;
        final LinkedList<String> lines = new LinkedList();

        EsEntry(String dt) {
            this.dt = dt;
        }
    }

    private static class FixEntry {
        final String before;
        final String after;

        FixEntry(String before, String after) {
            this.before = before;
            this.after = after;
        }
    }
}

