/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.util.RefEntry;
import zephyr.util.MultiLinkedHashMap;

public class PDFIndex {
    public static final String INDEX_UTF8_FILENAME = "jpgindex.utf8.html";
    private static final Pattern ENTRY_LINE = Pattern.compile("\t*([^\t]+)\t([0-9]+)-?([0-9]*)");
    protected final HashMap<String, RefEntry> entryMap = new HashMap();

    public void init(File file) throws Exception {
        MultiLinkedHashMap<String, ArrayList<String>> multiLinkedHashMap = this.load(file);
        this.makeJpgIndexHtml(new File(INDEX_UTF8_FILENAME), multiLinkedHashMap);
    }

    private MultiLinkedHashMap<String, ArrayList<String>> load(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        String string2 = "";
        String[] stringArray = new String[10];
        MultiLinkedHashMap<String, ArrayList<String>> multiLinkedHashMap = new MultiLinkedHashMap<String, ArrayList<String>>();
        while ((string = bufferedReader.readLine()) != null) {
            String string3 = string;
            if ((string = string.trim()).isEmpty()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = null;
                }
                continue;
            }
            if (string.startsWith("*")) {
                String[] stringArray2 = string.substring(1).split("\t");
                string2 = stringArray2[0];
                stringArray[0] = stringArray2[1];
                continue;
            }
            Matcher matcher = ENTRY_LINE.matcher(string);
            if (matcher.find()) {
                RefEntry refEntry = new RefEntry(string2, matcher.group(1), matcher.group(2), matcher.group(3));
                if (this.entryMap.containsKey(refEntry.key) && !refEntry.key.equals("-ir/-oir/-re")) {
                    System.err.println("\u30ad\u30fc\u91cd\u8907\uff1a" + refEntry.key);
                }
                this.entryMap.put(refEntry.key, refEntry);
                this.handleLine(string2, refEntry);
                this.setTitles(stringArray, string3, refEntry.title);
                for (String string4 : refEntry.jpgs) {
                    multiLinkedHashMap.put(string4, this.pageTitle(stringArray));
                }
                continue;
            }
            this.setTitles(stringArray, string3, string);
        }
        bufferedReader.close();
        return multiLinkedHashMap;
    }

    public void handleLine(String string, RefEntry refEntry) {
    }

    private void setTitles(String[] stringArray, String string, String string2) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '\t'; ++n) {
        }
        stringArray[++n] = string2;
        ++n;
        while (n < stringArray.length) {
            stringArray[n] = null;
            ++n;
        }
    }

    private ArrayList<String> pageTitle(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringArray[0]);
        for (int i = 1; i < stringArray.length && stringArray[i] != null; ++i) {
            if (stringArray[i].equals(stringArray[i - 1])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private void makeHeader(BufferedWriter bufferedWriter, ArrayList<String> arrayList, int n, String[] stringArray) throws IOException {
        String string;
        if (arrayList.size() > n && !(string = arrayList.get(n)).isEmpty() && !string.equals(stringArray[n])) {
            String string2 = "h" + (n + 1);
            bufferedWriter.write("<");
            bufferedWriter.write(string2);
            bufferedWriter.write(">");
            bufferedWriter.write(string);
            bufferedWriter.write("</");
            bufferedWriter.write(string2);
            bufferedWriter.write(">");
            bufferedWriter.newLine();
            stringArray[n] = string;
            for (int i = n + 1; i < stringArray.length; ++i) {
                stringArray[i] = "";
            }
        }
    }

    private void makeJpgIndexHtml(File file, MultiLinkedHashMap<String, ArrayList<String>> multiLinkedHashMap) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        bufferedWriter.write("<html><body>");
        bufferedWriter.newLine();
        String[] stringArray = new String[]{"", "", "", ""};
        ArrayList arrayList = new ArrayList();
        for (String string : multiLinkedHashMap.keySet()) {
            Object object2;
            LinkedList linkedList = multiLinkedHashMap.getList(string);
            for (Object object2 : linkedList) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.makeHeader(bufferedWriter, (ArrayList<String>)object2, i, stringArray);
                }
            }
            bufferedWriter.write("<dt id=\"");
            bufferedWriter.write(string);
            bufferedWriter.write("\">");
            if (string.startsWith("preface")) {
                bufferedWriter.write(string.replace("preface", "pr\u00e9face"));
            } else if (string.startsWith("creole")) {
                bufferedWriter.write(string.replace("creole", "cr\u00e9ole"));
            } else {
                bufferedWriter.write(string);
            }
            bufferedWriter.write("</dt><dd><p>");
            boolean bl = true;
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                ArrayList arrayList2 = (ArrayList)object2.next();
                if (!bl) {
                    bufferedWriter.write(", ");
                }
                boolean bl2 = true;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (i < arrayList.size() && ((String)arrayList.get(i)).equals(arrayList2.get(i))) continue;
                    if (bl2) {
                        bufferedWriter.write("\u25cf");
                        bl2 = false;
                    }
                    bufferedWriter.write((String)arrayList2.get(i));
                    if (i >= arrayList2.size() - 1) continue;
                    bufferedWriter.write(" ");
                }
                bl = false;
                arrayList = arrayList2;
            }
            bufferedWriter.write("</p>");
            bufferedWriter.newLine();
            bufferedWriter.write("<p><img src=\"jpg/");
            bufferedWriter.write(string + ".jpg");
            bufferedWriter.write("\"/></p></dd>");
            bufferedWriter.newLine();
            arrayList.clear();
        }
        bufferedWriter.write("</body></html>");
        bufferedWriter.newLine();
        bufferedWriter.close();
    }
}

