<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/"><html><body><xsl:apply-templates /></body></html></xsl:template>

    <xsl:template match="dt">&#60;dt id="<xsl:value-of select="@id" />"&#62;<xsl:apply-templates/>&#60;/dt&#62;</xsl:template>
    <xsl:template match="body">&#60;dd&#62;<xsl:apply-templates/>&#60;/dd&#62;</xsl:template>
    <xsl:template match="conju">【&#60;a href="conju.html#<xsl:apply-templates/>"&#62;活用表&#60;/a&#62;】<xsl:text> </xsl:text></xsl:template>
    <xsl:template match="sup">&#60;sup&#62;<xsl:apply-templates/>&#60;/sup&#62;</xsl:template>
    <xsl:template match="sub">&#60;sub&#62;<xsl:apply-templates/>&#60;/sub&#62;</xsl:template>
    <xsl:template match="gaiji">&amp;#x<xsl:apply-templates/>;</xsl:template>
    <xsl:template match="b">&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62;</xsl:template>
    <xsl:template match="i">&#60;i&#62;<xsl:apply-templates/>&#60;/i&#62;</xsl:template>
    <xsl:template match="td">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
    <xsl:template match="tr">
    	<xsl:choose>
            <xsl:when test="@class = 'block'">&#60;indent val="2"&#62;<xsl:apply-templates/>&#60;indent val="1"&#62;</xsl:when>
            <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="key">&#60;key type="<xsl:value-of select="@type" />"&#62;<xsl:apply-templates/>&#60;/key&#62;</xsl:template>
    <xsl:template match="jpgref">&#60;a href="jpgindex.html#<xsl:value-of select="@id" />"&#62;付録頁&#60;/a&#62;</xsl:template>

    <!-- See royal\contents\css\itempage.css -->
    <xsl:template match="span">
        <xsl:choose>
            <xsl:when test="@class = 'branch2'">&#60;b&#62;【<xsl:apply-templates/>】&#60;/b&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'branch3'">&#60;b&#62;<xsl:apply-templates/>.&#60;/b&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'branch4'">&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'hinsi'"><xsl:text> </xsl:text>&#60;i&#62;<xsl:apply-templates/>&#60;/i&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'seiku'">&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'rubi'"><xsl:apply-templates/></xsl:when>
            <xsl:when test="@class = 'phonetic_inLine'"><xsl:apply-templates/></xsl:when>
            <xsl:when test="@class = 'block_label'">&#60;b&#62;［<xsl:apply-templates/>］&#60;/b&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'midasi_sub'">&#60;b&#62;<xsl:apply-templates/>&#60;/b&#62;<xsl:text> </xsl:text></xsl:when>
            <xsl:when test="@class = 'dash'"><xsl:text>━━ </xsl:text></xsl:when>
            <xsl:when test="@class = 'jump'">&#60;jump onClick="<xsl:value-of select="@onClick" />"&#62;<xsl:apply-templates/>&#60;/jump&#62;</xsl:when>
            <xsl:when test="@class = 'gosi'"><xsl:apply-templates/></xsl:when>
            <!--  和仏見出し作成用 -->
            <xsl:when test="@class = 'yakugo'">&#60;yakugo&#62;<xsl:apply-templates/>&#60;/yakugo&#62;</xsl:when>
            <xsl:when test="@class = 'sakusya'"> (<xsl:apply-templates/>)</xsl:when>
            <xsl:otherwise><xsl:text> </xsl:text><xsl:apply-templates/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="a">
        <xsl:choose>
            <xsl:when test="@href = '#page_top'"></xsl:when>
            <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
