/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UnescapeChars;
import zephyr.util.ZephyrUtil;

public class AppendLatinKeys {
    protected static int nKey = 0;
    public static final String SUPERPREFIX = "* ";
    public static final String DT_DD_REGEXP = "<dt[^>]+>(.+?)</dt>.*?(<dd>(.*)</dd>)";
    public static final Pattern DT_DD = Pattern.compile("<dt[^>]+>(.+?)</dt>.*?(<dd>(.*)</dd>)");
    static final String WORD_REGEXP = "(<b>)?([A-Za-z\u00c0-\u017e']{2,}+)";
    protected final Pattern WORD;
    private final String keyLang;

    protected String makeKey(String string) {
        if (string.startsWith(SUPERPREFIX)) {
            return string.substring(SUPERPREFIX.length());
        }
        return string;
    }

    protected String makeKeyTitle(String string, String string2) {
        return string2 + " - " + string;
    }

    public String makeKeys(String string, String string2, String string3, Set<String> set) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string4 : set) {
            if (ZephyrUtil.makeKey(string4).equals(string2)) continue;
            stringBuffer.append("<key type=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\" title=\"");
            stringBuffer.append(this.makeKeyTitle(string, string4));
            stringBuffer.append("\">");
            stringBuffer.append(this.makeKey(string4));
            stringBuffer.append("</key>");
            ++nKey;
        }
        return stringBuffer.toString();
    }

    public Set<String> makeKeySet(String string, String string2, Pattern pattern) {
        Matcher matcher = pattern.matcher(string2);
        TreeSet<String> treeSet = new TreeSet<String>();
        while (matcher.find()) {
            String string3 = matcher.group(2);
            if (matcher.group(1) != null) {
                treeSet.remove(string3);
                treeSet.add(SUPERPREFIX + string3);
                continue;
            }
            if (treeSet.contains(SUPERPREFIX + string3)) continue;
            treeSet.add(string3);
        }
        return treeSet;
    }

    public String makeKeys(String string, String string2, Pattern pattern, String string3) {
        Set<String> set = this.makeKeySet(string, string2, pattern);
        if (!set.isEmpty()) {
            Matcher matcher = pattern.matcher(string);
            String string4 = matcher.find() ? ZephyrUtil.makeKey(matcher.group(2)) : null;
            return this.makeKeys(string, string4, string3, set);
        }
        return "";
    }

    public int getKeyNum() {
        return nKey;
    }

    protected AppendLatinKeys(Pattern pattern, String string) {
        this.WORD = pattern != null ? pattern : Pattern.compile(WORD_REGEXP);
        this.keyLang = string == null || string.isEmpty() ? "" : string.trim() + " ";
    }

    protected AppendLatinKeys(String string) {
        this(null, string);
    }

    public AppendLatinKeys() {
        this(null, "");
    }

    protected String makePlainText(String string) {
        return string;
    }

    protected String parse(String string, String string2) {
        Matcher matcher = DT_DD.matcher(string = UnescapeChars.unescape(string));
        if (!matcher.find()) {
            return string;
        }
        String string3 = matcher.group(1);
        String string4 = matcher.group(3);
        String string5 = this.makePlainText(string4);
        String string6 = this.makeKeys(string3, string5, this.WORD, string2);
        return string.substring(0, matcher.start(2)) + string6 + matcher.group(2);
    }

    public static String getKeyType(String string) {
        if (string.equals("\u8868\u8a18") || string.equals("\u6761\u4ef6")) {
            return string;
        }
        System.err.println("invalid keytype: " + string + ", must be \u8868\u8a18 or \u6761\u4ef6");
        System.exit(1);
        return null;
    }

    protected void appendKeys(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = !stringArray[0].equals("-") ? new FileInputStream(new File(stringArray[0])) : System.in;
        String string2 = AppendLatinKeys.getKeyType(stringArray[1]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println(this.parse(string, string2));
        }
        bufferedReader.close();
        if (nKey > 0) {
            System.err.println("append " + nKey + " extra " + this.keyLang + string2 + " keys");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: java AppendLatinKeys utf8file.html [\u8868\u8a18|\u6761\u4ef6]");
            return;
        }
        ZephyrUtil.setUTF8Ouput();
        AppendLatinKeys appendLatinKeys = new AppendLatinKeys();
        try {
            appendLatinKeys.appendKeys(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

