/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import zephyr.util.PDF2MonoBMP;

public class PDF2MonoBMPDual
extends PDF2MonoBMP {
    private static final int DROP_LINE_WIDTH = 1;
    private final int dpi;
    private final int dropLineDot;
    private static final int FIND_SPAN = 50;

    PDF2MonoBMPDual(int n) {
        this.dpi = n;
        this.dropLineDot = this.mm2dot(1);
    }

    private int mm2dot(int n) {
        return (int)((double)(n * this.dpi) / 25.4);
    }

    private int verticalBlackNum(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getHeight();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            ++n3;
        }
        return n3;
    }

    private int findVerticalLine(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth() / 2;
        int n2 = 0;
        int n3 = -1;
        int n4 = Integer.max(0, n - 50);
        int n5 = Integer.min(n + 50, bufferedImage.getWidth());
        for (n = n4; n < n5; ++n) {
            int n6 = this.verticalBlackNum(bufferedImage, n);
            if (n6 <= n2) continue;
            n2 = n6;
            n3 = n;
        }
        if (n3 >= 0) {
            return n3;
        }
        return bufferedImage.getWidth() / 2;
    }

    private int horizontalBlackNum(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            ++n3;
        }
        return n3;
    }

    private int findHorizontalLine(BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight() / 2;
        int n2 = 0;
        int n3 = 0;
        int n4 = bufferedImage.getWidth() / 5;
        for (n = 0; n < n4; ++n) {
            int n5 = this.horizontalBlackNum(bufferedImage, n);
            if (n5 <= n2) continue;
            n2 = n5;
            n3 = n;
        }
        return n3;
    }

    @Override
    protected void write(BufferedImage bufferedImage, String string, File file) throws Exception {
        int n = this.findHorizontalLine(bufferedImage) + this.dropLineDot;
        int n2 = bufferedImage.getHeight() - n;
        int n3 = this.findVerticalLine(bufferedImage);
        int n4 = n3 - this.dropLineDot;
        int n5 = n3 + this.dropLineDot;
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, n, n4, n2);
        File file2 = new File(file.getAbsolutePath().replace(".bmp", "a.bmp"));
        ImageIO.write((RenderedImage)bufferedImage2, string, file2);
        System.out.print(file2.getName() + " ");
        BufferedImage bufferedImage3 = bufferedImage.getSubimage(n5, n, bufferedImage.getWidth() - n5, n2);
        File file3 = new File(file.getAbsolutePath().replace(".bmp", "b.bmp"));
        ImageIO.write((RenderedImage)bufferedImage3, string, file3);
        System.out.print(file3.getName() + " ");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PDF2MonoBMPDual sample.pdf outDir [dpi] [startPage] [endPage] [prefix] [startIdx]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 1;
        int n3 = stringArray.length > 4 ? Integer.parseInt(stringArray[4]) : Integer.MAX_VALUE;
        String string3 = stringArray.length > 5 && !stringArray[5].equals("null") ? stringArray[5] : null;
        int n4 = stringArray.length > 6 ? Integer.parseInt(stringArray[6]) : 1;
        PDF2MonoBMPDual pDF2MonoBMPDual = new PDF2MonoBMPDual(n);
        pDF2MonoBMPDual.convert(string, string2, string3, n4, n, n2, n3);
    }
}

