/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanseido.teniwoha;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import zephyr.sanseido.teniwoha.PageDivider;
import zephyr.sanseido.teniwoha.TatePositionComparator;

public class PDF2Text
extends PDFTextStripper {
    private static final TatePositionComparator POS_COMP = new TatePositionComparator();
    private PageDivider divider = null;
    private static final float[] PART_Y_RATIOS = new float[]{0.048f, 0.274f, 0.5f, 0.724f, 0.946f};

    private LinkedList<TextPosition>[] divideParts() {
        LinkedList[] linkedListArray = new LinkedList[4];
        for (int i = 0; i < linkedListArray.length; ++i) {
            linkedListArray[i] = new LinkedList();
        }
        List list = this.getCharactersByArticle();
        for (List list2 : list) {
            for (TextPosition textPosition : list2) {
                int n = this.divider.findPart(textPosition);
                if (1 <= n && n <= 4) {
                    linkedListArray[n - 1].add(textPosition);
                    continue;
                }
                System.err.printf("(%.1f, %.1f)=%s\n", Float.valueOf(textPosition.getX()), Float.valueOf(textPosition.getY()), textPosition.toString());
            }
        }
        return linkedListArray;
    }

    public void processPage(PDPage pDPage) throws IOException {
        super.processPage(pDPage);
        int n = this.getCurrentPageNo();
        if (n < this.getStartPage() || this.getEndPage() < n) {
            return;
        }
        System.err.print(n + " ");
        this.divider.processPage(n, pDPage);
        LinkedList<TextPosition>[] linkedListArray = this.divideParts();
        for (int i = 0; i < linkedListArray.length; ++i) {
            System.out.println("-----------------------");
            LinkedList<TextPosition> linkedList = linkedListArray[i];
            for (TextPosition textPosition : linkedList) {
                String string = textPosition.toString().trim();
                if (string.length() == 0) {
                    System.out.print("\uff04");
                    continue;
                }
                boolean bl = this.divider.isLemma(textPosition, i + 1);
                if (bl) {
                    System.out.println();
                    System.out.print("\u2605\u3000");
                }
                System.out.print(string);
            }
            System.out.println();
        }
        System.out.println();
        System.out.println();
        System.out.println();
    }

    private void load(String string, int n, int n2, int n3) throws Exception {
        System.err.println(string);
        PDDocument pDDocument = PDDocument.load((File)new File(string));
        this.divider = new PageDivider(pDDocument, n3, PART_Y_RATIOS);
        this.setStartPage(n);
        this.setEndPage(n2);
        this.getText(pDDocument);
        pDDocument.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "sample.pdf";
        int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 1;
        int n2 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : Integer.MAX_VALUE;
        int n3 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 200;
        PDF2Text pDF2Text = new PDF2Text();
        pDF2Text.load(string, n, n2, n3);
    }
}

