/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class R3Gaiji {
    private final TreeMap<String, String> gaijiMap = new TreeMap();
    public static final String SUBREF = "\u25ba";
    private static final Pattern GAIJIMAP = Pattern.compile("<gaijiMap unicode=\"#x([0-9A-F]+)\" ebcode=\"([0-9A-F]+)\"");
    private static final Pattern GAIJI_START = Pattern.compile("<fontData ebcode=\"([0-9A-F]+)\">");
    private static final String GAIJI_END = "</fontData>";
    private int exUnicode = 57344;

    public String gaiji(String string) {
        String string2 = this.gaijiMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return "{" + string + "}";
    }

    R3Gaiji(String string) throws Exception {
        int n;
        Object object;
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string2 = bufferedReader.readLine()) != null) {
            object = GAIJIMAP.matcher(string2);
            if (!((Matcher)object).find()) continue;
            n = Integer.parseInt(((Matcher)object).group(1), 16);
            this.gaijiMap.put(((Matcher)object).group(2), Character.toString((char)n));
        }
        bufferedReader.close();
        fileInputStream = new FileInputStream(new File("Gaiji.xml"));
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        object = "";
        n = 0;
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (n != 0) {
                if (string2.equals(GAIJI_END)) {
                    if (!bl) {
                        this.gaijiMap.put((String)object, "");
                    }
                    n = 0;
                    continue;
                }
                if (string2.trim().isEmpty()) continue;
                bl = true;
                continue;
            }
            Matcher matcher = GAIJI_START.matcher(string2);
            if (!matcher.find()) continue;
            bl = false;
            object = matcher.group(1);
            n = 1;
        }
        bufferedReader.close();
        this.gaijiMap.put("B924", "<i>");
        this.gaijiMap.put("B925", "</i>");
        for (int i = 2342; i <= 2360; ++i) {
            this.gaijiMap.put(String.format("%X", i), "");
        }
    }

    R3Gaiji() {
        this.gaijiMap.put("A128", "~");
        this.gaijiMap.put("A12C", "\u02a4");
        this.gaijiMap.put("A12D", "-");
        this.gaijiMap.put("A132", "\u0304");
        this.gaijiMap.put("A135", "*");
        this.gaijiMap.put("A138", "\u00c1");
        this.gaijiMap.put("A139", "\u00c9");
        this.gaijiMap.put("A13A", "\u00cd");
        this.gaijiMap.put("A13B", "\u00d3");
        this.gaijiMap.put("A13C", "\u00da");
        this.gaijiMap.put("A13D", "\u00dd");
        this.gaijiMap.put("A13E", "\u00e1");
        this.gaijiMap.put("A13F", "\u00e9");
        this.gaijiMap.put("A140", "\u00ed");
        this.gaijiMap.put("A141", "\u00f3");
        this.gaijiMap.put("A142", "\u00fa");
        this.gaijiMap.put("A143", "\u00fd");
        this.gaijiMap.put("A144", "\u00c1");
        this.gaijiMap.put("A145", "\u00c9");
        this.gaijiMap.put("A146", "\u00cd");
        this.gaijiMap.put("A147", "\u00d3");
        this.gaijiMap.put("A148", "\u00da");
        this.gaijiMap.put("A14A", "\u00e1");
        this.gaijiMap.put("A14B", "\u00e9");
        this.gaijiMap.put("A14C", "\u00ed");
        this.gaijiMap.put("A14D", "\u00f3");
        this.gaijiMap.put("A14E", "\u00fa");
        this.gaijiMap.put("A14F", "\u00fd");
        this.gaijiMap.put("A161", "\u00c0");
        this.gaijiMap.put("A162", "\u00c8");
        this.gaijiMap.put("A167", "\u00e0");
        this.gaijiMap.put("A168", "\u00e8");
        this.gaijiMap.put("A169", "\u00ec");
        this.gaijiMap.put("A16A", "\u00f2");
        this.gaijiMap.put("A16B", "\u00f9");
        this.gaijiMap.put("A16E", "\u00c0");
        this.gaijiMap.put("A16F", "\u00c8");
        this.gaijiMap.put("A170", "\u00cc");
        this.gaijiMap.put("A171", "\u00d2");
        this.gaijiMap.put("A172", "\u00d9");
        this.gaijiMap.put("A174", "\u00e0");
        this.gaijiMap.put("A175", "\u00e8");
        this.gaijiMap.put("A176", "\u00ec");
        this.gaijiMap.put("A177", "\u00f2");
        this.gaijiMap.put("A178", "\u00f9");
        this.gaijiMap.put("A17C", "\u00c4");
        this.gaijiMap.put("A221", "\u00d6");
        this.gaijiMap.put("A222", "\u00dc");
        this.gaijiMap.put("A224", "\u00e4");
        this.gaijiMap.put("A225", "\u00eb");
        this.gaijiMap.put("A226", "\u00ef");
        this.gaijiMap.put("A227", "\u00f6");
        this.gaijiMap.put("A228", "\u00fc");
        this.gaijiMap.put("A229", "\u00ff");
        this.gaijiMap.put("A22B", "\u00c2");
        this.gaijiMap.put("A22C", "\u00ca");
        this.gaijiMap.put("A22D", "\u00ce");
        this.gaijiMap.put("A230", "\u00e2");
        this.gaijiMap.put("A231", "\u00ea");
        this.gaijiMap.put("A232", "\u00ee");
        this.gaijiMap.put("A233", "\u00f4");
        this.gaijiMap.put("A234", "\u00fb");
        this.gaijiMap.put("A235", "\u0101");
        this.gaijiMap.put("A236", "\u0113");
        this.gaijiMap.put("A237", "\u012b");
        this.gaijiMap.put("A238", "\u014d");
        this.gaijiMap.put("A239", "\u016b");
        this.gaijiMap.put("A23B", "\u0327");
        this.gaijiMap.put("A23C", "\u00c7");
        this.gaijiMap.put("A23D", "\u00e7");
        this.gaijiMap.put("A259", "\u0303");
        this.gaijiMap.put("A25E", "\u00e3");
        this.gaijiMap.put("A26D", "\u028c");
        this.gaijiMap.put("A26E", "\u00f8");
        this.gaijiMap.put("A26F", "\u0259");
        this.gaijiMap.put("A270", "\u025a");
        this.gaijiMap.put("A271", "\u025b");
        this.gaijiMap.put("A272", "\u026a");
        this.gaijiMap.put("A273", "\u0254");
        this.gaijiMap.put("A274", "\u028a");
        this.gaijiMap.put("A275", "\u03b8");
        this.gaijiMap.put("A276", "\u00f0");
        this.gaijiMap.put("A277", "\u222b");
        this.gaijiMap.put("A278", "\u0292");
        this.gaijiMap.put("A27A", "\u02d0");
        this.gaijiMap.put("A27B", "\u0251");
        this.gaijiMap.put("A27C", "\u03c6");
        this.gaijiMap.put("A27E", "\u2199");
        this.gaijiMap.put("A321", "\u0306");
        this.gaijiMap.put("A322", "\\");
        this.gaijiMap.put("A328", "\u02d8");
        this.gaijiMap.put("A32D", "\u01d3");
        this.gaijiMap.put("A32F", "\u0103");
        this.gaijiMap.put("A334", "\u016d");
        this.gaijiMap.put("A336", "\u030c");
        this.gaijiMap.put("A338", "\u010c");
        this.gaijiMap.put("A33C", "\u0160");
        this.gaijiMap.put("A33D", "\u017d");
        this.gaijiMap.put("A33E", "\u01ce");
        this.gaijiMap.put("A33F", "\u010d");
        this.gaijiMap.put("A340", "\u011b");
        this.gaijiMap.put("A341", "\u013e");
        this.gaijiMap.put("A342", "\u0148");
        this.gaijiMap.put("A343", "\u0159");
        this.gaijiMap.put("A344", "\u0161");
        this.gaijiMap.put("A345", "\u017e");
        this.gaijiMap.put("A348", "\u0328");
        this.gaijiMap.put("A34C", "\u0105");
        this.gaijiMap.put("A34D", "\u0119");
        this.gaijiMap.put("A353", "\u015f");
        this.gaijiMap.put("A354", "\u0163");
        this.gaijiMap.put("A35D", "\u0106");
        this.gaijiMap.put("A35E", "\u015a");
        this.gaijiMap.put("A35F", "\u0107");
        this.gaijiMap.put("A361", "\u015b");
        this.gaijiMap.put("A362", "\u017a");
        this.gaijiMap.put("A447", "\u028f");
        this.gaijiMap.put("A448", "\u0265");
        this.gaijiMap.put("A44C", "\u0111");
        this.gaijiMap.put("A44E", "\u00b9");
        this.gaijiMap.put("A44F", "\u0141");
        this.gaijiMap.put("A450", "\u0272");
        this.gaijiMap.put("A452", "\u00bf");
        this.gaijiMap.put("A453", "i");
        this.gaijiMap.put("A454", "\u0142");
        this.gaijiMap.put("A457", "\u00f5");
        this.gaijiMap.put("A45A", "\u0151");
        this.gaijiMap.put("A45B", "\u00c5");
        this.gaijiMap.put("A45C", "\u00e5");
        this.gaijiMap.put("A471", "\u02d9");
        this.gaijiMap.put("A524", "\u0127");
        this.gaijiMap.put("A526", "\u0192");
        this.gaijiMap.put("A527", "\u028a");
        this.gaijiMap.put("A528", "\u028e");
        this.gaijiMap.put("A52A", "\u00fe");
        this.gaijiMap.put("A52B", "\u01bf");
        this.gaijiMap.put("A547", "\u0112");
        this.gaijiMap.put("A549", "\u012a");
        this.gaijiMap.put("A54E", "\u016a");
        this.gaijiMap.put("A55B", "\u03c2");
        this.gaijiMap.put("A56C", "S");
        this.gaijiMap.put("A574", "\u01d4");
        this.gaijiMap.put("B25B", "\u60f2");
        this.gaijiMap.put("B25C", "\u7a1e");
        this.gaijiMap.put("B25E", "\u55c9");
        this.gaijiMap.put("B25F", "\u5676");
        this.gaijiMap.put("B260", "\u5660");
        this.gaijiMap.put("B261", "\u5733");
        this.gaijiMap.put("B262", "\u62fc");
        this.gaijiMap.put("B264", "\u6d31");
        this.gaijiMap.put("B265", "\u7064");
        this.gaijiMap.put("B266", "\u7085");
        this.gaijiMap.put("B267", "\u70e4");
        this.gaijiMap.put("B268", "\u728d");
        this.gaijiMap.put("B269", "\u73a2");
        this.gaijiMap.put("B26A", "\u7664");
        this.gaijiMap.put("B26B", "\u76b6");
        this.gaijiMap.put("B26C", "\u78e0");
        this.gaijiMap.put("B26D", "\u7a03");
        this.gaijiMap.put("B26F", "\u82be");
        this.gaijiMap.put("B270", "\u8386");
        this.gaijiMap.put("B272", "\u8604");
        this.gaijiMap.put("B273", "\u8e70");
        this.gaijiMap.put("B276", "\u9592");
        this.gaijiMap.put("B27A", "\u4f97");
        this.gaijiMap.put("B27B", "\u5088");
        this.gaijiMap.put("B27C", "\u50f3");
        this.gaijiMap.put("B27D", "\u50a3");
        this.gaijiMap.put("B27E", "\u4f64");
        this.gaijiMap.put("B321", "\u503b");
        this.gaijiMap.put("B322", "\u4f8a");
        this.gaijiMap.put("B324", "\u510b");
        this.gaijiMap.put("B325", "\u52f0");
        this.gaijiMap.put("B326", "\u5157");
        this.gaijiMap.put("B327", "\u51f4");
        this.gaijiMap.put("B328", "\u52d0");
        this.gaijiMap.put("B329", "\u5361");
        this.gaijiMap.put("B32A", "\u53b4");
        this.gaijiMap.put("B32B", "\u5535");
        this.gaijiMap.put("B32C", "\u560e");
        this.gaijiMap.put("B32D", "\u5688");
        this.gaijiMap.put("B32F", "\u57f5");
        this.gaijiMap.put("B330", "\u5729");
        this.gaijiMap.put("B331", "\u577b");
        this.gaijiMap.put("B333", "\u588a");
        this.gaijiMap.put("B334", "\u579c");
        this.gaijiMap.put("B335", "\u58e2");
        this.gaijiMap.put("B336", "\u58e9");
        this.gaijiMap.put("B337", "\u596d");
        this.gaijiMap.put("B339", "\u5aa7");
        this.gaijiMap.put("B33D", "\u5d97");
        this.gaijiMap.put("B33E", "\u5d4a");
        this.gaijiMap.put("B33F", "\u5ca2");
        this.gaijiMap.put("B340", "\u5db4");
        this.gaijiMap.put("B341", "\u5d0d");
        this.gaijiMap.put("B343", "\u5d46");
        this.gaijiMap.put("B344", "\u79ed");
        this.gaijiMap.put("B346", "\u5e15");
        this.gaijiMap.put("B347", "\u62d6");
        this.gaijiMap.put("B348", "\u5ebe");
        this.gaijiMap.put("B349", "\u609d");
        this.gaijiMap.put("B34A", "\u6137");
        this.gaijiMap.put("B34F", "\u6615");
        this.gaijiMap.put("B351", "\u66fa");
        this.gaijiMap.put("B352", "\u6677");
        this.gaijiMap.put("B354", "\u6793");
        this.gaijiMap.put("B355", "\u67c4");
        this.gaijiMap.put("B357", "\u68f0");
        this.gaijiMap.put("B358", "\u68f1");
        this.gaijiMap.put("B359", "\u6963");
        this.gaijiMap.put("B35B", "\u90f4");
        this.gaijiMap.put("B35D", "\u6972");
        this.gaijiMap.put("B362", "\u6a45");
        this.gaijiMap.put("B363", "\u6a89");
        this.gaijiMap.put("B364", "\u6b46");
        this.gaijiMap.put("B365", "\u6c10");
        this.gaijiMap.put("B366", "\u6c85");
        this.gaijiMap.put("B367", "\u6c76");
        this.gaijiMap.put("B368", "\u6d2e");
        this.gaijiMap.put("B369", "\u6d87");
        this.gaijiMap.put("B36A", "\u6f2f");
        this.gaijiMap.put("B36B", "\u6daa");
        this.gaijiMap.put("B36C", "\u6ece");
        this.gaijiMap.put("B36D", "\u6dc4");
        this.gaijiMap.put("B36E", "\u6dbf");
        this.gaijiMap.put("B36F", "\u6e44");
        this.gaijiMap.put("B370", "\u6ff0");
        this.gaijiMap.put("B372", "\u6ec7");
        this.gaijiMap.put("B374", "\u6fb6");
        this.gaijiMap.put("B375", "\u6dd6");
        this.gaijiMap.put("B376", "\u6ef9");
        this.gaijiMap.put("B377", "\u6f35");
        this.gaijiMap.put("B378", "\u6f33");
        this.gaijiMap.put("B379", "\u6ea7");
        this.gaijiMap.put("B37A", "\u6ec1");
        this.gaijiMap.put("B37B", "\u6f5e");
        this.gaijiMap.put("B37C", "\u6d79");
        this.gaijiMap.put("B37D", "\u6cad");
        this.gaijiMap.put("B421", "\u6dae");
        this.gaijiMap.put("B422", "\u6f62");
        this.gaijiMap.put("B423", "\u6c94");
        this.gaijiMap.put("B424", "\u6f7d");
        this.gaijiMap.put("B425", "\u6fa0");
        this.gaijiMap.put("B426", "\u6fc9");
        this.gaijiMap.put("B427", "\u6fa7");
        this.gaijiMap.put("B428", "\u6f2a");
        this.gaijiMap.put("B429", "\u6fde");
        this.gaijiMap.put("B42B", "\u7095");
        this.gaijiMap.put("B42C", "\u70bb");
        this.gaijiMap.put("B42D", "\u7146");
        this.gaijiMap.put("B42E", "\u71c1");
        this.gaijiMap.put("B430", "\u71fe");
        this.gaijiMap.put("B431", "\u729b");
        this.gaijiMap.put("B432", "\u72b0");
        this.gaijiMap.put("B433", "\u72f3");
        this.gaijiMap.put("B435", "\u742b");
        this.gaijiMap.put("B436", "\u73d9");
        this.gaijiMap.put("B437", "\u73c5");
        this.gaijiMap.put("B439", "\u741b");
        this.gaijiMap.put("B43B", "\u756c");
        this.gaijiMap.put("B43C", "\u7619");
        this.gaijiMap.put("B43D", "\u75e4");
        this.gaijiMap.put("B43E", "\u766d");
        this.gaijiMap.put("B43F", "\u762d");
        this.gaijiMap.put("B440", "\u7719");
        this.gaijiMap.put("B442", "\u7762");
        this.gaijiMap.put("B443", "\u78ad");
        this.gaijiMap.put("B444", "\u7931");
        this.gaijiMap.put("B445", "\u795c");
        this.gaijiMap.put("B446", "\u799b");
        this.gaijiMap.put("B447", "\u7aa3");
        this.gaijiMap.put("B448", "\u7aa0");
        this.gaijiMap.put("B449", "\u8d1b");
        this.gaijiMap.put("B44A", "\u7b2f");
        this.gaijiMap.put("B44B", "\u7b60");
        this.gaijiMap.put("B44E", "\u7dd9");
        this.gaijiMap.put("B44F", "\u7d47");
        this.gaijiMap.put("B450", "\u7da6");
        this.gaijiMap.put("B451", "\u7fdf");
        this.gaijiMap.put("B453", "\u7fee");
        this.gaijiMap.put("B454", "\u7ffa");
        this.gaijiMap.put("B455", "\u80ca");
        this.gaijiMap.put("B458", "\u8222");
        this.gaijiMap.put("B459", "\u82b7");
        this.gaijiMap.put("B45A", "\u82ae");
        this.gaijiMap.put("B45B", "\u8354");
        this.gaijiMap.put("B45C", "\u8392");
        this.gaijiMap.put("B45D", "\u8398");
        this.gaijiMap.put("B45E", "\u83c7");
        this.gaijiMap.put("B460", "\u83c9");
        this.gaijiMap.put("B461", "\u84b4");
        this.gaijiMap.put("B462", "\u8497");
        this.gaijiMap.put("B464", "\u83cf");
        this.gaijiMap.put("B465", "\u8559");
        this.gaijiMap.put("B467", "\u830c");
        this.gaijiMap.put("B469", "\u8662");
        this.gaijiMap.put("B46A", "\u8611");
        this.gaijiMap.put("B46B", "\u8357");
        this.gaijiMap.put("B46C", "\u95a9");
        this.gaijiMap.put("B46F", "\u8772");
        this.gaijiMap.put("B472", "\u8932");
        this.gaijiMap.put("B473", "\u8940");
        this.gaijiMap.put("B474", "\u8a22");
        this.gaijiMap.put("B476", "\u8dd1");
        this.gaijiMap.put("B478", "\u8dd7");
        this.gaijiMap.put("B479", "\u8dc6");
        this.gaijiMap.put("B47B", "\u909b");
        this.gaijiMap.put("B47C", "\u90a2");
        this.gaijiMap.put("B47D", "\u90dd");
        this.gaijiMap.put("B47E", "\u90df");
        this.gaijiMap.put("B521", "\u90ef");
        this.gaijiMap.put("B522", "\u911e");
        this.gaijiMap.put("B523", "\u9097");
        this.gaijiMap.put("B524", "\u9131");
        this.gaijiMap.put("B526", "\u9127");
        this.gaijiMap.put("B527", "\u9104");
        this.gaijiMap.put("B528", "\u9095");
        this.gaijiMap.put("B529", "\u90a1");
        this.gaijiMap.put("B52A", "\u90b3");
        this.gaijiMap.put("B52B", "\u90eb");
        this.gaijiMap.put("B52C", "\u90fe");
        this.gaijiMap.put("B52D", "\u9148");
        this.gaijiMap.put("B52E", "\u9106");
        this.gaijiMap.put("B52F", "\u9116");
        this.gaijiMap.put("B530", "\u9122");
        this.gaijiMap.put("B531", "\u912f");
        this.gaijiMap.put("B532", "\u9278");
        this.gaijiMap.put("B533", "\u9315");
        this.gaijiMap.put("B535", "\u931f");
        this.gaijiMap.put("B537", "\u9239");
        this.gaijiMap.put("B538", "\u9416");
        this.gaijiMap.put("B539", "\u9472");
        this.gaijiMap.put("B53A", "\u95ac");
        this.gaijiMap.put("B53C", "\u9658");
        this.gaijiMap.put("B53D", "\u9857");
        this.gaijiMap.put("B53E", "\u9865");
        this.gaijiMap.put("B53F", "\u982b");
        this.gaijiMap.put("B541", "\u9a4a");
        this.gaijiMap.put("B542", "\u99e2");
        this.gaijiMap.put("B543", "\u9a36");
        this.gaijiMap.put("B544", "\u99c3");
        this.gaijiMap.put("B545", "\u9a20");
        this.gaijiMap.put("B546", "\u9ac1");
        this.gaijiMap.put("B547", "\u9ab9");
        this.gaijiMap.put("B548", "\u9b10");
        this.gaijiMap.put("B557", "\u9c75");
        this.gaijiMap.put("B55B", "\u9edf");
        this.gaijiMap.put("B55D", "\u9e9e");
        this.gaijiMap.put("B55E", "\u6d60");
        this.gaijiMap.put("B562", "\u9f70");
        this.gaijiMap.put("B563", "\u93de");
        this.gaijiMap.put("B564", "\u5300");
        this.gaijiMap.put("B826", "\u4f6c");
        this.gaijiMap.put("B827", "\u84cd");
        this.gaijiMap.put("A150", "\u028c\u0301");
        this.gaijiMap.put("A151", "\u0278\u0301");
        this.gaijiMap.put("A160", "\u028c\u0301");
        this.gaijiMap.put("A16C", "y\u0300");
        this.gaijiMap.put("A179", "y\u0300");
        this.gaijiMap.put("A17A", "\u028c\u0300");
        this.gaijiMap.put("A17B", "\u0278\u0300");
        this.gaijiMap.put("A23A", "y\u0304");
        this.gaijiMap.put("A23E", "\u0259\u0301");
        this.gaijiMap.put("A240", "\u025b\u0301");
        this.gaijiMap.put("A242", "\u0254\u0301");
        this.gaijiMap.put("A244", "\u026f\u0301");
        this.gaijiMap.put("A245", "\u028f\u0301");
        this.gaijiMap.put("A246", "\u0251\u0301");
        this.gaijiMap.put("A249", "\u025b\u0301");
        this.gaijiMap.put("A24A", "\u026a\u0301");
        this.gaijiMap.put("A24B", "\u0254\u0301");
        this.gaijiMap.put("A24C", "\u028a\u0301");
        this.gaijiMap.put("A24F", "\u0251\u0301");
        this.gaijiMap.put("A250", "\u0259\u0300");
        this.gaijiMap.put("A252", "\u025b\u0300");
        this.gaijiMap.put("A253", "\u026a\u0300");
        this.gaijiMap.put("A254", "\u0254\u0300");
        this.gaijiMap.put("A255", "\u028a\u0300");
        this.gaijiMap.put("A258", "\u0251\u0300");
        this.gaijiMap.put("A25A", "\u025b\u0303");
        this.gaijiMap.put("A25B", "\u026a\u0303");
        this.gaijiMap.put("A25C", "\u0254\u0303");
        this.gaijiMap.put("A25D", "\u0251\u0303");
        this.gaijiMap.put("A25F", "\u00f1");
        this.gaijiMap.put("A261", "\u025b\u0303\u0301");
        this.gaijiMap.put("A262", "\u026a\u0303\u0301");
        this.gaijiMap.put("A263", "\u0254\u0303\u0301");
        this.gaijiMap.put("A264", "\u0251\u0303\u0301");
        this.gaijiMap.put("A265", "\u00e3\u0301");
        this.gaijiMap.put("A266", "\u028c\u0303\u0301");
        this.gaijiMap.put("A267", "\u0254\u0303\u0300");
        this.gaijiMap.put("A26A", "\u0251\u0303\u0300");
        this.gaijiMap.put("A26C", "\u028c\u0303\u0300");
        this.gaijiMap.put("A279", "\u014b");
        this.gaijiMap.put("A27D", "\u1e6d");
        this.gaijiMap.put("A326", "\u014d\u0301");
        this.gaijiMap.put("A331", "g\u0306");
        this.gaijiMap.put("A333", "\u014f");
        this.gaijiMap.put("A346", "\u1e35");
        this.gaijiMap.put("A347", "\u1e6f");
        this.gaijiMap.put("A34E", "\u01eb");
        this.gaijiMap.put("A357", "H\u0325");
        this.gaijiMap.put("A358", "h\u0325");
        this.gaijiMap.put("A359", "m\u0325");
        this.gaijiMap.put("A35A", "n\u0325");
        this.gaijiMap.put("A35C", "m\u0301");
        this.gaijiMap.put("A360", "n\u0301");
        this.gaijiMap.put("A426", "r\u0301");
        this.gaijiMap.put("A445", "\u0287");
        this.gaijiMap.put("A44B", "\u0189");
        this.gaijiMap.put("A44D", "\u2018");
        this.gaijiMap.put("A45D", "u\u030a");
        this.gaijiMap.put("A45E", "y\u030a");
        this.gaijiMap.put("A45F", "\u1f61");
        this.gaijiMap.put("A461", "\u1e24");
        this.gaijiMap.put("A466", "\u1e62");
        this.gaijiMap.put("A467", "\u1e6c");
        this.gaijiMap.put("A469", "\u1e0d");
        this.gaijiMap.put("A46A", "\u1e25");
        this.gaijiMap.put("A46B", "\u1e33");
        this.gaijiMap.put("A46C", "\u1e43");
        this.gaijiMap.put("A46D", "\u1e47");
        this.gaijiMap.put("A46E", "\u1e5b");
        this.gaijiMap.put("A46F", "\u1e63");
        this.gaijiMap.put("A470", "\u1e93");
        this.gaijiMap.put("A476", "\u0130");
        this.gaijiMap.put("A478", "\u017b");
        this.gaijiMap.put("A47A", "\u0117");
        this.gaijiMap.put("A47B", "\u0121");
        this.gaijiMap.put("A47C", "\u1e41");
        this.gaijiMap.put("A47D", "\u1e45");
        this.gaijiMap.put("A52E", "$");
        this.gaijiMap.put("A530", "m\u0325\u0301");
        this.gaijiMap.put("A543", "\u0100");
        this.gaijiMap.put("A621", "\u00f4");
        this.gaijiMap.put("A62E", "\u014f");
        this.gaijiMap.put("A678", "\u1fb3");
        this.gaijiMap.put("A679", "\u1fc3");
        this.gaijiMap.put("A67A", "\u1ff3");
        this.gaijiMap.put("A67B", "\u0259\u0303");
        this.gaijiMap.put("A921", "\u300a");
        this.gaijiMap.put("A922", "\u300b");
        this.gaijiMap.put("A925", "\u3018");
        this.gaijiMap.put("A926", "\u3019");
        this.gaijiMap.put("B144", "\u261e");
        this.gaijiMap.put("B14E", "\u01fd");
        this.gaijiMap.put("B14F", "\u00e6\u0300");
        this.gaijiMap.put("B150", "\u01fd");
        this.gaijiMap.put("B151", "\u01e3");
        this.gaijiMap.put("B152", "\u00e6\u0303\u0301");
        this.gaijiMap.put("B153", "\u00e6\u0303\u0300");
        this.gaijiMap.put("B154", "\u00e6\u0303");
        this.gaijiMap.put("B155", "\u00e6");
        this.gaijiMap.put("B156", "\u0153\u0301");
        this.gaijiMap.put("B157", "\u0153\u0300");
        this.gaijiMap.put("B158", "\u0153\u0301");
        this.gaijiMap.put("B158", "\u0153\u0303");
        this.gaijiMap.put("B158", "\u0153");
        this.gaijiMap.put("B15E", "\u00c6");
        this.gaijiMap.put("B15F", "\u2194");
        this.gaijiMap.put("B168", "o\u0360\u028a\u0301");
        this.gaijiMap.put("B169", "o\u0360\u028a\u0300");
        this.gaijiMap.put("B16B", "o\u0360\u028a");
        this.gaijiMap.put("B16C", "e\u0360\u026a\u0301");
        this.gaijiMap.put("B16F", "e\u0360\u026a");
        this.gaijiMap.put("B170", "a\u0360\u028a\u0301");
        this.gaijiMap.put("B171", "a\u0360\u028a\u0300");
        this.gaijiMap.put("B173", "a\u0360\u028a");
        this.gaijiMap.put("B175", "\u00a9");
        this.gaijiMap.put("B176", "\u00ae");
        this.gaijiMap.put("B22F", "o\u0360u\u0301");
        this.gaijiMap.put("B230", "o\u0360u");
        this.gaijiMap.put("B73D", "\u0153");
        this.gaijiMap.put("B939", SUBREF);
        this.gaijiMap.put("B924", "<i>");
        this.gaijiMap.put("B925", "</i>");
        this.gaijiMap.put("B926", "");
        this.gaijiMap.put("B927", "");
        this.gaijiMap.put("B928", "");
        this.gaijiMap.put("B929", "");
        this.gaijiMap.put("B92A", "");
        this.gaijiMap.put("B92B", "");
        this.gaijiMap.put("B92C", "");
        this.gaijiMap.put("B92D", "");
        this.gaijiMap.put("B92E", "");
        this.gaijiMap.put("B92F", "");
        this.gaijiMap.put("B931", "");
        this.gaijiMap.put("B932", "");
        this.gaijiMap.put("B933", "");
        this.gaijiMap.put("B934", "");
        this.gaijiMap.put("B935", "");
        this.gaijiMap.put("B936", "");
        this.gaijiMap.put("B937", "");
        this.gaijiMap.put("B938", "");
    }

    private void dumpGaiji(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            String string = String.format("%04X", i);
            String string2 = this.gaijiMap.get(string);
            if (string2 != null && string2.length() == 1) {
                String string3 = ZephyrUtil.uniChMap.get(Character.valueOf(string2.charAt(0)));
                if (string3 != null) {
                    System.out.printf("<gaijiMap unicode=\"#x%04X\" ebcode=\"%4X\" alt=\"%s\" />\n", string2.charAt(0), i, string3);
                } else {
                    System.out.printf("<gaijiMap unicode=\"#x%04X\" ebcode=\"%4X\" alt=\"\" />\n", string2.charAt(0), i);
                }
            } else {
                System.out.printf("<gaijiMap unicode=\"#x%04X\" ebcode=\"%4X\" alt=\"\" />\n", this.exUnicode, i);
                ++this.exUnicode;
            }
            if ((i & 0xFF) != 126) continue;
            i = (i & 0xFF00) + 288;
        }
    }

    private void dumpGaijiMap() {
        this.dumpGaiji(41249, 43302);
        this.dumpGaiji(45380, 47417);
    }

    public static void main(String[] stringArray) {
        R3Gaiji r3Gaiji = new R3Gaiji();
        r3Gaiji.dumpGaijiMap();
    }
}

